/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.phoenix;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.airlift.slice.SizeOf;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.phoenix.SerializedPhoenixInputSplit;
import io.trino.spi.HostAddress;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.phoenix.mapreduce.PhoenixInputSplit;
import org.openjdk.jol.info.ClassLayout;

public class PhoenixSplit
extends JdbcSplit {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(PhoenixSplit.class).instanceSize();
    private final List<HostAddress> addresses;
    private final SerializedPhoenixInputSplit serializedPhoenixInputSplit;

    @JsonCreator
    public PhoenixSplit(@JsonProperty(value="addresses") List<HostAddress> addresses, @JsonProperty(value="serializedPhoenixInputSplit") SerializedPhoenixInputSplit serializedPhoenixInputSplit) {
        super(Optional.empty());
        this.addresses = Objects.requireNonNull(addresses, "addresses is null");
        this.serializedPhoenixInputSplit = Objects.requireNonNull(serializedPhoenixInputSplit, "serializedPhoenixInputSplit is null");
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty
    public SerializedPhoenixInputSplit getSerializedPhoenixInputSplit() {
        return this.serializedPhoenixInputSplit;
    }

    @JsonIgnore
    public PhoenixInputSplit getPhoenixInputSplit() {
        return this.serializedPhoenixInputSplit.deserialize();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((Optional)this.getAdditionalPredicate(), SizeOf::estimatedSizeOf) + SizeOf.estimatedSizeOf(this.addresses, HostAddress::getRetainedSizeInBytes) + this.serializedPhoenixInputSplit.getRetainedSizeInBytes();
    }
}

