/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

class InMemoryGlobberFileSystem
extends FileSystem {
    private final Path workingDirectory;
    private final URI uri;
    private final Map<Path, FileStatus> fileStatusesByPath;
    private final Map<Path, List<FileStatus>> fileStatusesByParentPath;

    public static FileSystem createInstance(Configuration config, Path workingDirectory, Collection<FileStatus> fileStatuses) {
        Preconditions.checkNotNull((Object)config, (Object)"configuration can not be null");
        InMemoryGlobberFileSystem fileSystem = new InMemoryGlobberFileSystem(workingDirectory, fileStatuses);
        fileSystem.setConf(config);
        return fileSystem;
    }

    private InMemoryGlobberFileSystem(Path workingDirectory, Collection<FileStatus> fileStatuses) {
        this.workingDirectory = workingDirectory;
        this.uri = workingDirectory.toUri();
        this.fileStatusesByPath = Maps.newHashMapWithExpectedSize((int)fileStatuses.size());
        this.fileStatusesByParentPath = Maps.newHashMapWithExpectedSize((int)(fileStatuses.size() / 5));
        for (FileStatus fileStatus : fileStatuses) {
            this.fileStatusesByPath.put(fileStatus.getPath(), fileStatus);
            if (fileStatus.getPath().getParent() == null) continue;
            this.fileStatusesByParentPath.computeIfAbsent(fileStatus.getPath().getParent(), k -> new ArrayList()).add(fileStatus);
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        Path qualifiedPath = this.makeQualified(f);
        List<FileStatus> fileStatuses = this.fileStatusesByParentPath.get(qualifiedPath);
        if (fileStatuses == null) {
            throw new FileNotFoundException(String.format("Path '%s' (qualified: '%s') does not exist.", f, qualifiedPath));
        }
        return fileStatuses.toArray(new FileStatus[0]);
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        Path qualifiedPath = this.makeQualified(f);
        FileStatus fileStatus = this.fileStatusesByPath.get(f);
        if (fileStatus == null) {
            throw new FileNotFoundException(String.format("Path '%s' (qualified: '%s') does not exist.", f, qualifiedPath));
        }
        return fileStatus;
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean rename(Path src, Path dst) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean delete(Path f) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setWorkingDirectory(Path newDir) {
        throw new UnsupportedOperationException();
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        throw new UnsupportedOperationException();
    }
}

