/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesUnion;
import org.apache.datasketches.quantiles.DoublesUnionImpl;
import org.apache.datasketches.quantiles.DoublesUnionImplR;
import org.apache.datasketches.quantiles.Util;

public class DoublesUnionBuilder {
    private int bMaxK = 128;

    public DoublesUnionBuilder setMaxK(int maxK) {
        Util.checkK(maxK);
        this.bMaxK = maxK;
        return this;
    }

    public int getMaxK() {
        return this.bMaxK;
    }

    public DoublesUnion build() {
        return DoublesUnionImpl.heapInstance(this.bMaxK);
    }

    public DoublesUnion build(WritableMemory dstMem) {
        return DoublesUnionImpl.directInstance(this.bMaxK, dstMem);
    }

    @Deprecated
    public static DoublesUnion heapify(DoublesSketch sketch) {
        return DoublesUnionImpl.heapifyInstance(sketch);
    }

    @Deprecated
    public static DoublesUnion heapify(Memory srcMem) {
        return DoublesUnionImpl.heapifyInstance(srcMem);
    }

    @Deprecated
    public static DoublesUnion wrap(Memory mem) {
        return DoublesUnionImplR.wrapInstance(mem);
    }

    @Deprecated
    public static DoublesUnion wrap(WritableMemory mem) {
        return DoublesUnionImpl.wrapInstance(mem);
    }
}

