/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.HeapCompactSketch;
import org.apache.datasketches.theta.PreambleUtil;

final class HeapCompactOrderedSketch
extends HeapCompactSketch {
    HeapCompactOrderedSketch(long[] cache, boolean empty, short seedHash, int curCount, long thetaLong) {
        super(cache, empty, seedHash, curCount, thetaLong);
    }

    static CompactSketch heapifyInstance(Memory srcMem, long seed) {
        short memSeedHash = (short)PreambleUtil.extractSeedHash(srcMem);
        short computedSeedHash = Util.computeSeedHash(seed);
        Util.checkSeedHashes(memSeedHash, computedSeedHash);
        int preLongs = PreambleUtil.extractPreLongs(srcMem);
        boolean empty = PreambleUtil.isEmpty(srcMem);
        long thetaLong = Long.MAX_VALUE;
        int curCount = PreambleUtil.extractCurCount(srcMem);
        long[] cache = new long[curCount];
        if (preLongs == 2) {
            srcMem.getLongArray(16L, cache, 0, curCount);
        } else {
            srcMem.getLongArray(24L, cache, 0, curCount);
            thetaLong = PreambleUtil.extractThetaLong(srcMem);
        }
        return new HeapCompactOrderedSketch(cache, empty, memSeedHash, curCount, thetaLong);
    }

    static CompactSketch compact(long[] cache, boolean empty, short seedHash, int curCount, long thetaLong) {
        return new HeapCompactOrderedSketch(cache, empty, seedHash, curCount, thetaLong);
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(true);
    }

    @Override
    public boolean isOrdered() {
        return true;
    }
}

