/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.Family;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.SetOperationBuilder;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.theta.UpdateSketchBuilder;

public final class Sketches {
    private Sketches() {
    }

    public static UpdateSketchBuilder updateSketchBuilder() {
        return new UpdateSketchBuilder();
    }

    public static Sketch heapifySketch(Memory srcMem) {
        return Sketch.heapify(srcMem);
    }

    public static Sketch heapifySketch(Memory srcMem, long seed) {
        return Sketch.heapify(srcMem, seed);
    }

    public static UpdateSketch heapifyUpdateSketch(Memory srcMem) {
        return UpdateSketch.heapify(srcMem);
    }

    public static UpdateSketch heapifyUpdateSketch(Memory srcMem, long seed) {
        return UpdateSketch.heapify(srcMem, seed);
    }

    public static Sketch wrapSketch(Memory srcMem) {
        return Sketch.wrap(srcMem);
    }

    public static Sketch wrapSketch(Memory srcMem, long seed) {
        return Sketch.wrap(srcMem, seed);
    }

    public static UpdateSketch wrapUpdateSketch(WritableMemory srcMem) {
        return Sketches.wrapUpdateSketch(srcMem, 9001L);
    }

    public static UpdateSketch wrapUpdateSketch(WritableMemory srcMem, long seed) {
        return UpdateSketch.wrap(srcMem, seed);
    }

    public static SetOperationBuilder setOperationBuilder() {
        return new SetOperationBuilder();
    }

    public static SetOperation heapifySetOperation(Memory srcMem) {
        return SetOperation.heapify(srcMem);
    }

    public static SetOperation heapifySetOperation(Memory srcMem, long seed) {
        return SetOperation.heapify(srcMem, seed);
    }

    public static SetOperation wrapSetOperation(Memory srcMem) {
        return Sketches.wrapSetOperation(srcMem, 9001L);
    }

    public static SetOperation wrapSetOperation(WritableMemory srcMem) {
        return Sketches.wrapSetOperation(srcMem, 9001L);
    }

    public static Union wrapUnion(Memory srcMem) {
        return (Union)SetOperation.wrap(srcMem);
    }

    public static Union wrapUnion(WritableMemory srcMem) {
        return (Union)SetOperation.wrap(srcMem);
    }

    public static Intersection wrapIntersection(Memory srcMem) {
        return (Intersection)SetOperation.wrap(srcMem);
    }

    public static Intersection wrapIntersection(WritableMemory srcMem) {
        return (Intersection)SetOperation.wrap(srcMem);
    }

    public static SetOperation wrapSetOperation(Memory srcMem, long seed) {
        return SetOperation.wrap(srcMem, seed);
    }

    public static SetOperation wrapSetOperation(WritableMemory srcMem, long seed) {
        return SetOperation.wrap(srcMem, seed);
    }

    public static int getMaxCompactSketchBytes(int numberOfEntries) {
        return Sketch.getMaxCompactSketchBytes(numberOfEntries);
    }

    public static int getMaxUpdateSketchBytes(int nomEntries) {
        return Sketch.getMaxUpdateSketchBytes(nomEntries);
    }

    public static int getSerializationVersion(Memory srcMem) {
        return Sketch.getSerializationVersion(srcMem);
    }

    public static int getMaxUnionBytes(int nomEntries) {
        return SetOperation.getMaxUnionBytes(nomEntries);
    }

    public static int getMaxIntersectionBytes(int nomEntries) {
        return SetOperation.getMaxIntersectionBytes(nomEntries);
    }

    public static double getEstimate(Memory srcMem) {
        Sketches.checkIfValidThetaSketch(srcMem);
        return Sketch.estimate(Sketches.getThetaLong(srcMem), Sketches.getRetainedEntries(srcMem), Sketches.getEmpty(srcMem));
    }

    public static double getUpperBound(int numStdDev, Memory srcMem) {
        return Sketch.upperBound(Sketches.getRetainedEntries(srcMem), Sketches.getThetaLong(srcMem), numStdDev, Sketches.getEmpty(srcMem));
    }

    public static double getLowerBound(int numStdDev, Memory srcMem) {
        return Sketch.lowerBound(Sketches.getRetainedEntries(srcMem), Sketches.getThetaLong(srcMem), numStdDev, Sketches.getEmpty(srcMem));
    }

    static int getPreambleLongs(Memory srcMem) {
        return srcMem.getByte(0L) & 0x3F;
    }

    static int getRetainedEntries(Memory srcMem) {
        boolean empty;
        byte serVer = srcMem.getByte(1L);
        if (serVer == 1) {
            int entries = srcMem.getInt(8L);
            if (Sketches.getThetaLong(srcMem) == Long.MAX_VALUE && entries == 0) {
                return 0;
            }
            return entries;
        }
        int preLongs = Sketches.getPreambleLongs(srcMem);
        boolean bl = empty = (srcMem.getByte(5L) & 4) != 0;
        if (preLongs == 1) {
            return empty ? 0 : 1;
        }
        return srcMem.getInt(8L);
    }

    static long getThetaLong(Memory srcMem) {
        int preLongs = Sketches.getPreambleLongs(srcMem);
        return preLongs < 3 ? Long.MAX_VALUE : srcMem.getLong(16L);
    }

    static boolean getEmpty(Memory srcMem) {
        byte serVer = srcMem.getByte(1L);
        if (serVer == 1) {
            return Sketches.getThetaLong(srcMem) == Long.MAX_VALUE && Sketches.getRetainedEntries(srcMem) == 0;
        }
        return (srcMem.getByte(5L) & 4) != 0;
    }

    static void checkIfValidThetaSketch(Memory srcMem) {
        byte fam = srcMem.getByte(2L);
        if (!Sketch.isValidSketchID(fam)) {
            throw new SketchesArgumentException("Source Memory not a valid Sketch. Family: " + Family.idToFamily(fam).toString());
        }
    }
}

