/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.blackhole;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.slice.Slice;
import io.airlift.units.Duration;
import io.trino.plugin.blackhole.BlackHoleColumnHandle;
import io.trino.plugin.blackhole.BlackHoleInsertTableHandle;
import io.trino.plugin.blackhole.BlackHoleOutputTableHandle;
import io.trino.plugin.blackhole.BlackHolePageSourceProvider;
import io.trino.plugin.blackhole.BlackHolePartitioningHandle;
import io.trino.plugin.blackhole.BlackHoleTableHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ColumnStatistics;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.DoubleRange;
import io.trino.spi.statistics.Estimate;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.statistics.TableStatisticsMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class BlackHoleMetadata
implements ConnectorMetadata {
    private static final String SCHEMA_NAME = "default";
    private final List<String> schemas = new ArrayList<String>();
    private final Map<SchemaTableName, BlackHoleTableHandle> tables = new ConcurrentHashMap<SchemaTableName, BlackHoleTableHandle>();
    private final Map<SchemaTableName, ConnectorViewDefinition> views = new ConcurrentHashMap<SchemaTableName, ConnectorViewDefinition>();

    public BlackHoleMetadata() {
        this.schemas.add(SCHEMA_NAME);
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.copyOf(this.schemas);
    }

    public synchronized void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        if (this.schemas.contains(schemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("Schema [%s] already exists", schemaName));
        }
        this.schemas.add(schemaName);
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        return this.tables.get(tableName);
    }

    public ConnectorTableHandle getTableHandleForStatisticsCollection(ConnectorSession session, SchemaTableName tableName, Map<String, Object> analyzeProperties) {
        return this.getTableHandle(session, tableName);
    }

    public TableStatisticsMetadata getStatisticsCollectionMetadata(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        return TableStatisticsMetadata.empty();
    }

    public ConnectorTableHandle beginStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return tableHandle;
    }

    public void finishStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        BlackHoleTableHandle blackHoleTableHandle = (BlackHoleTableHandle)tableHandle;
        return blackHoleTableHandle.toTableMetadata();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return ImmutableSet.builder().addAll((Iterable)this.tables.values().stream().filter(table -> schemaName.isEmpty() || table.getSchemaName().equals(schemaName.get())).map(BlackHoleTableHandle::toSchemaTableName).collect(Collectors.toList())).addAll(this.listViews(session, schemaName)).build().asList();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        BlackHoleTableHandle blackHoleTableHandle = (BlackHoleTableHandle)tableHandle;
        return (Map)blackHoleTableHandle.getColumnHandles().stream().collect(ImmutableMap.toImmutableMap(BlackHoleColumnHandle::getName, column -> column));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        BlackHoleColumnHandle blackHoleColumnHandle = (BlackHoleColumnHandle)columnHandle;
        return blackHoleColumnHandle.toColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        return (Map)this.tables.values().stream().filter(table -> prefix.matches(table.toSchemaTableName())).collect(ImmutableMap.toImmutableMap(BlackHoleTableHandle::toSchemaTableName, handle -> handle.toTableMetadata().getColumns()));
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint constraint) {
        BlackHoleTableHandle table = (BlackHoleTableHandle)tableHandle;
        TableStatistics.Builder tableStats = TableStatistics.builder();
        double rows = (double)table.getSplitCount() * (double)table.getPagesPerSplit() * (double)table.getRowsPerPage();
        tableStats.setRowCount(Estimate.of((double)rows));
        for (BlackHoleColumnHandle column : table.getColumnHandles()) {
            ColumnStatistics.Builder stats = ColumnStatistics.builder().setDistinctValuesCount(Estimate.of((double)1.0)).setNullsFraction(Estimate.of((double)0.0));
            if (BlackHolePageSourceProvider.isNumericType(column.getColumnType())) {
                stats.setRange(new DoubleRange(0.0, 0.0));
            }
            tableStats.setColumnStatistics((ColumnHandle)column, stats.build());
        }
        return tableStats.build();
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        BlackHoleTableHandle blackHoleTableHandle = (BlackHoleTableHandle)tableHandle;
        this.tables.remove(blackHoleTableHandle.toSchemaTableName());
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        BlackHoleTableHandle oldTableHandle = (BlackHoleTableHandle)tableHandle;
        BlackHoleTableHandle newTableHandle = new BlackHoleTableHandle(oldTableHandle.getSchemaName(), newTableName.getTableName(), oldTableHandle.getColumnHandles(), oldTableHandle.getSplitCount(), oldTableHandle.getPagesPerSplit(), oldTableHandle.getRowsPerPage(), oldTableHandle.getFieldsLength(), oldTableHandle.getPageProcessingDelay());
        this.tables.remove(oldTableHandle.toSchemaTableName());
        this.tables.put(newTableName, newTableHandle);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        ConnectorOutputTableHandle outputTableHandle = this.beginCreateTable(session, tableMetadata, Optional.empty());
        this.finishCreateTable(session, outputTableHandle, (Collection<Slice>)ImmutableList.of(), (Collection<ComputedStatistics>)ImmutableList.of());
    }

    public Optional<ConnectorTableLayout> getNewTableLayout(ConnectorSession connectorSession, ConnectorTableMetadata tableMetadata) {
        List distributeColumns = (List)tableMetadata.getProperties().get("distributed_on");
        if (distributeColumns.isEmpty()) {
            return Optional.empty();
        }
        Sets.SetView undefinedColumns = Sets.difference((Set)ImmutableSet.copyOf((Collection)distributeColumns), tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toSet()));
        if (!undefinedColumns.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Distribute columns not defined on table: " + (Set)undefinedColumns);
        }
        return Optional.of(new ConnectorTableLayout((ConnectorPartitioningHandle)BlackHolePartitioningHandle.INSTANCE, distributeColumns));
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout) {
        this.checkSchemaExists(tableMetadata.getTable().getSchemaName());
        int splitCount = (Integer)tableMetadata.getProperties().get("split_count");
        int pagesPerSplit = (Integer)tableMetadata.getProperties().get("pages_per_split");
        int rowsPerPage = (Integer)tableMetadata.getProperties().get("rows_per_page");
        int fieldsLength = (Integer)tableMetadata.getProperties().get("field_length");
        if (splitCount < 0) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "split_count property is negative");
        }
        if (pagesPerSplit < 0) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "pages_per_split property is negative");
        }
        if (rowsPerPage < 0) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "rows_per_page property is negative");
        }
        if (!(splitCount <= 0 && pagesPerSplit <= 0 && rowsPerPage <= 0 || splitCount != 0 && pagesPerSplit != 0 && rowsPerPage != 0)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("All properties [%s, %s, %s] must be set if any are set", "split_count", "pages_per_split", "rows_per_page"));
        }
        Duration pageProcessingDelay = (Duration)tableMetadata.getProperties().get("page_processing_delay");
        BlackHoleTableHandle handle = new BlackHoleTableHandle(tableMetadata, splitCount, pagesPerSplit, rowsPerPage, fieldsLength, pageProcessingDelay);
        return new BlackHoleOutputTableHandle(handle, pageProcessingDelay);
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        BlackHoleOutputTableHandle blackHoleOutputTableHandle = (BlackHoleOutputTableHandle)tableHandle;
        BlackHoleTableHandle table = blackHoleOutputTableHandle.getTable();
        this.tables.put(table.toSchemaTableName(), table);
        return Optional.empty();
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns) {
        BlackHoleTableHandle handle = (BlackHoleTableHandle)tableHandle;
        return new BlackHoleInsertTableHandle(handle.getPageProcessingDelay());
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public ColumnHandle getDeleteRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return new BlackHoleColumnHandle("row_id", (Type)BigintType.BIGINT);
    }

    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return tableHandle;
    }

    public void finishDelete(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
    }

    public void truncateTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
    }

    public void createView(ConnectorSession session, SchemaTableName viewName, ConnectorViewDefinition definition, boolean replace) {
        this.views.put(viewName, definition);
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        this.views.remove(viewName);
    }

    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> schemaName) {
        return ImmutableList.copyOf(this.views.keySet());
    }

    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> schemaName) {
        return ImmutableMap.copyOf(this.views);
    }

    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        return Optional.ofNullable(this.views.get(viewName));
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        return new ConnectorTableProperties();
    }

    private void checkSchemaExists(String schemaName) {
        if (!this.schemas.contains(schemaName)) {
            throw new SchemaNotFoundException(schemaName);
        }
    }
}

