/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Longs;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.orc.metadata.ColumnEncoding;
import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.metadata.CompressionKind;
import io.trino.orc.metadata.Footer;
import io.trino.orc.metadata.Metadata;
import io.trino.orc.metadata.MetadataReader;
import io.trino.orc.metadata.OrcColumnId;
import io.trino.orc.metadata.OrcType;
import io.trino.orc.metadata.PostScript;
import io.trino.orc.metadata.RowGroupIndex;
import io.trino.orc.metadata.Stream;
import io.trino.orc.metadata.StripeFooter;
import io.trino.orc.metadata.StripeInformation;
import io.trino.orc.metadata.statistics.BinaryStatistics;
import io.trino.orc.metadata.statistics.BloomFilter;
import io.trino.orc.metadata.statistics.BooleanStatistics;
import io.trino.orc.metadata.statistics.ColumnStatistics;
import io.trino.orc.metadata.statistics.DateStatistics;
import io.trino.orc.metadata.statistics.DecimalStatistics;
import io.trino.orc.metadata.statistics.DoubleStatistics;
import io.trino.orc.metadata.statistics.IntegerStatistics;
import io.trino.orc.metadata.statistics.StringStatistics;
import io.trino.orc.metadata.statistics.StripeStatistics;
import io.trino.orc.metadata.statistics.TimestampStatistics;
import io.trino.orc.proto.OrcProto;
import io.trino.orc.protobuf.ByteString;
import io.trino.orc.protobuf.CodedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.ByteOrder;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

public class OrcMetadataReader
implements MetadataReader {
    private static final int REPLACEMENT_CHARACTER_CODE_POINT = 65533;
    private static final int PROTOBUF_MESSAGE_MAX_LIMIT = Math.toIntExact(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE).toBytes());

    @Override
    public PostScript readPostScript(InputStream inputStream) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        OrcProto.PostScript postScript = OrcProto.PostScript.parseFrom((CodedInputStream)input);
        return new PostScript(postScript.getVersionList(), postScript.getFooterLength(), postScript.getMetadataLength(), OrcMetadataReader.toCompression(postScript.getCompression()), postScript.getCompressionBlockSize(), OrcMetadataReader.toHiveWriterVersion(postScript.getWriterVersion()));
    }

    private static PostScript.HiveWriterVersion toHiveWriterVersion(int writerVersion) {
        if (writerVersion >= 1) {
            return PostScript.HiveWriterVersion.ORC_HIVE_8732;
        }
        return PostScript.HiveWriterVersion.ORIGINAL;
    }

    @Override
    public Metadata readMetadata(PostScript.HiveWriterVersion hiveWriterVersion, InputStream inputStream) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        input.setSizeLimit(PROTOBUF_MESSAGE_MAX_LIMIT);
        OrcProto.Metadata metadata = OrcProto.Metadata.parseFrom((CodedInputStream)input);
        return new Metadata(OrcMetadataReader.toStripeStatistics(hiveWriterVersion, metadata.getStripeStatsList()));
    }

    private static List<Optional<StripeStatistics>> toStripeStatistics(PostScript.HiveWriterVersion hiveWriterVersion, List<OrcProto.StripeStatistics> types) {
        return (List)types.stream().map(stripeStatistics -> OrcMetadataReader.toStripeStatistics(hiveWriterVersion, stripeStatistics)).collect(ImmutableList.toImmutableList());
    }

    private static Optional<StripeStatistics> toStripeStatistics(PostScript.HiveWriterVersion hiveWriterVersion, OrcProto.StripeStatistics stripeStatistics) {
        return OrcMetadataReader.toColumnStatistics(hiveWriterVersion, stripeStatistics.getColStatsList(), false).map(StripeStatistics::new);
    }

    @Override
    public Footer readFooter(PostScript.HiveWriterVersion hiveWriterVersion, InputStream inputStream) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        input.setSizeLimit(PROTOBUF_MESSAGE_MAX_LIMIT);
        OrcProto.Footer footer = OrcProto.Footer.parseFrom((CodedInputStream)input);
        return new Footer(footer.getNumberOfRows(), footer.getRowIndexStride() == 0 ? OptionalInt.empty() : OptionalInt.of(footer.getRowIndexStride()), OrcMetadataReader.toStripeInformation(footer.getStripesList()), OrcMetadataReader.toType(footer.getTypesList()), OrcMetadataReader.toColumnStatistics(hiveWriterVersion, footer.getStatisticsList(), false), OrcMetadataReader.toUserMetadata(footer.getMetadataList()), Optional.of(footer.getWriter()));
    }

    private static List<StripeInformation> toStripeInformation(List<OrcProto.StripeInformation> types) {
        return (List)types.stream().map(OrcMetadataReader::toStripeInformation).collect(ImmutableList.toImmutableList());
    }

    private static StripeInformation toStripeInformation(OrcProto.StripeInformation stripeInformation) {
        return new StripeInformation(Math.toIntExact(stripeInformation.getNumberOfRows()), stripeInformation.getOffset(), stripeInformation.getIndexLength(), stripeInformation.getDataLength(), stripeInformation.getFooterLength());
    }

    @Override
    public StripeFooter readStripeFooter(ColumnMetadata<OrcType> types, InputStream inputStream, ZoneId legacyFileTimeZone) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        OrcProto.StripeFooter stripeFooter = OrcProto.StripeFooter.parseFrom((CodedInputStream)input);
        return new StripeFooter(OrcMetadataReader.toStream(stripeFooter.getStreamsList()), OrcMetadataReader.toColumnEncoding(stripeFooter.getColumnsList()), Optional.ofNullable(Strings.emptyToNull((String)stripeFooter.getWriterTimezone())).map(ZoneId::of).orElse(legacyFileTimeZone));
    }

    private static Stream toStream(OrcProto.Stream stream) {
        return new Stream(new OrcColumnId(stream.getColumn()), OrcMetadataReader.toStreamKind(stream.getKind()), Math.toIntExact(stream.getLength()), true);
    }

    private static List<Stream> toStream(List<OrcProto.Stream> streams) {
        return (List)streams.stream().map(OrcMetadataReader::toStream).collect(ImmutableList.toImmutableList());
    }

    private static ColumnEncoding toColumnEncoding(OrcProto.ColumnEncoding columnEncoding) {
        return new ColumnEncoding(OrcMetadataReader.toColumnEncodingKind(columnEncoding.getKind()), columnEncoding.getDictionarySize());
    }

    private static ColumnMetadata<ColumnEncoding> toColumnEncoding(List<OrcProto.ColumnEncoding> columnEncodings) {
        return new ColumnMetadata<ColumnEncoding>((List)columnEncodings.stream().map(OrcMetadataReader::toColumnEncoding).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public List<RowGroupIndex> readRowIndexes(PostScript.HiveWriterVersion hiveWriterVersion, InputStream inputStream) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        OrcProto.RowIndex rowIndex = OrcProto.RowIndex.parseFrom((CodedInputStream)input);
        return (List)rowIndex.getEntryList().stream().map(rowIndexEntry -> OrcMetadataReader.toRowGroupIndex(hiveWriterVersion, rowIndexEntry)).collect(ImmutableList.toImmutableList());
    }

    @Override
    public List<BloomFilter> readBloomFilterIndexes(InputStream inputStream) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        OrcProto.BloomFilterIndex bloomFilter = OrcProto.BloomFilterIndex.parseFrom((CodedInputStream)input);
        List bloomFilterList = bloomFilter.getBloomFilterList();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (OrcProto.BloomFilter orcBloomFilter : bloomFilterList) {
            if (orcBloomFilter.hasUtf8Bitset()) {
                ByteString utf8Bitset = orcBloomFilter.getUtf8Bitset();
                long[] bits = new long[utf8Bitset.size() / 8];
                utf8Bitset.asReadOnlyByteBuffer().order(ByteOrder.LITTLE_ENDIAN).asLongBuffer().get(bits);
                builder.add((Object)new BloomFilter(bits, orcBloomFilter.getNumHashFunctions()));
                continue;
            }
            builder.add((Object)new BloomFilter(Longs.toArray((Collection)orcBloomFilter.getBitsetList()), orcBloomFilter.getNumHashFunctions()));
        }
        return builder.build();
    }

    private static RowGroupIndex toRowGroupIndex(PostScript.HiveWriterVersion hiveWriterVersion, OrcProto.RowIndexEntry rowIndexEntry) {
        List positionsList = rowIndexEntry.getPositionsList();
        ImmutableList.Builder positions = ImmutableList.builder();
        for (int index = 0; index < positionsList.size(); ++index) {
            long longPosition = (Long)positionsList.get(index);
            int intPosition = (int)longPosition;
            Preconditions.checkArgument(((long)intPosition == longPosition ? 1 : 0) != 0, (String)"Expected checkpoint position [%s] value [%s] to be an integer", (int)index, (long)longPosition);
            positions.add((Object)intPosition);
        }
        return new RowGroupIndex((List<Integer>)positions.build(), OrcMetadataReader.toColumnStatistics(hiveWriterVersion, rowIndexEntry.getStatistics(), true));
    }

    private static ColumnStatistics toColumnStatistics(PostScript.HiveWriterVersion hiveWriterVersion, OrcProto.ColumnStatistics statistics, boolean isRowGroup) {
        long minAverageValueBytes;
        if (statistics.hasBucketStatistics()) {
            minAverageValueBytes = 2L;
        } else if (statistics.hasIntStatistics()) {
            minAverageValueBytes = 9L;
        } else if (statistics.hasDoubleStatistics()) {
            minAverageValueBytes = 9L;
        } else if (statistics.hasStringStatistics()) {
            minAverageValueBytes = 5L;
            if (statistics.hasNumberOfValues() && statistics.getNumberOfValues() > 0L) {
                minAverageValueBytes += statistics.getStringStatistics().getSum() / statistics.getNumberOfValues();
            }
        } else if (statistics.hasDateStatistics()) {
            minAverageValueBytes = 5L;
        } else if (statistics.hasTimestampStatistics()) {
            minAverageValueBytes = 9L;
        } else if (statistics.hasDecimalStatistics()) {
            minAverageValueBytes = 9L;
        } else if (statistics.hasBinaryStatistics()) {
            minAverageValueBytes = 5L;
            if (statistics.hasNumberOfValues() && statistics.getNumberOfValues() > 0L) {
                minAverageValueBytes += statistics.getBinaryStatistics().getSum() / statistics.getNumberOfValues();
            }
        } else {
            minAverageValueBytes = 0L;
        }
        if (statistics.hasHasNull() && statistics.getNumberOfValues() == 0L && !statistics.getHasNull()) {
            return new ColumnStatistics(null, 0L, null, null, null, null, null, null, null, null, null);
        }
        return new ColumnStatistics(statistics.getNumberOfValues(), minAverageValueBytes, statistics.hasBucketStatistics() ? OrcMetadataReader.toBooleanStatistics(statistics.getBucketStatistics()) : null, statistics.hasIntStatistics() ? OrcMetadataReader.toIntegerStatistics(statistics.getIntStatistics()) : null, statistics.hasDoubleStatistics() ? OrcMetadataReader.toDoubleStatistics(statistics.getDoubleStatistics()) : null, statistics.hasStringStatistics() ? OrcMetadataReader.toStringStatistics(hiveWriterVersion, statistics.getStringStatistics(), isRowGroup) : null, statistics.hasDateStatistics() ? OrcMetadataReader.toDateStatistics(hiveWriterVersion, statistics.getDateStatistics(), isRowGroup) : null, statistics.hasTimestampStatistics() ? OrcMetadataReader.toTimestampStatistics(hiveWriterVersion, statistics.getTimestampStatistics(), isRowGroup) : null, statistics.hasDecimalStatistics() ? OrcMetadataReader.toDecimalStatistics(statistics.getDecimalStatistics()) : null, statistics.hasBinaryStatistics() ? OrcMetadataReader.toBinaryStatistics(statistics.getBinaryStatistics()) : null, null);
    }

    private static Optional<ColumnMetadata<ColumnStatistics>> toColumnStatistics(PostScript.HiveWriterVersion hiveWriterVersion, List<OrcProto.ColumnStatistics> columnStatistics, boolean isRowGroup) {
        if (columnStatistics == null || columnStatistics.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ColumnMetadata((List)columnStatistics.stream().map(statistics -> OrcMetadataReader.toColumnStatistics(hiveWriterVersion, statistics, isRowGroup)).collect(ImmutableList.toImmutableList())));
    }

    private static Map<String, Slice> toUserMetadata(List<OrcProto.UserMetadataItem> metadataList) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (OrcProto.UserMetadataItem item : metadataList) {
            mapBuilder.put((Object)item.getName(), (Object)OrcMetadataReader.byteStringToSlice(item.getValue()));
        }
        return mapBuilder.buildOrThrow();
    }

    private static BooleanStatistics toBooleanStatistics(OrcProto.BucketStatistics bucketStatistics) {
        if (bucketStatistics.getCountCount() == 0) {
            return null;
        }
        return new BooleanStatistics(bucketStatistics.getCount(0));
    }

    private static IntegerStatistics toIntegerStatistics(OrcProto.IntegerStatistics integerStatistics) {
        return new IntegerStatistics(integerStatistics.hasMinimum() ? Long.valueOf(integerStatistics.getMinimum()) : null, integerStatistics.hasMaximum() ? Long.valueOf(integerStatistics.getMaximum()) : null, integerStatistics.hasSum() ? Long.valueOf(integerStatistics.getSum()) : null);
    }

    private static DoubleStatistics toDoubleStatistics(OrcProto.DoubleStatistics doubleStatistics) {
        if (doubleStatistics.hasMinimum() && Double.isNaN(doubleStatistics.getMinimum()) || doubleStatistics.hasMaximum() && Double.isNaN(doubleStatistics.getMaximum()) || doubleStatistics.hasSum() && Double.isNaN(doubleStatistics.getSum())) {
            return null;
        }
        return new DoubleStatistics(doubleStatistics.hasMinimum() ? Double.valueOf(doubleStatistics.getMinimum()) : null, doubleStatistics.hasMaximum() ? Double.valueOf(doubleStatistics.getMaximum()) : null);
    }

    static StringStatistics toStringStatistics(PostScript.HiveWriterVersion hiveWriterVersion, OrcProto.StringStatistics stringStatistics, boolean isRowGroup) {
        if (hiveWriterVersion == PostScript.HiveWriterVersion.ORIGINAL && !isRowGroup) {
            return null;
        }
        Slice maximum = stringStatistics.hasMaximum() ? OrcMetadataReader.maxStringTruncateToValidRange(OrcMetadataReader.byteStringToSlice(stringStatistics.getMaximumBytes()), hiveWriterVersion) : null;
        Slice minimum = stringStatistics.hasMinimum() ? OrcMetadataReader.minStringTruncateToValidRange(OrcMetadataReader.byteStringToSlice(stringStatistics.getMinimumBytes()), hiveWriterVersion) : null;
        long sum = stringStatistics.hasSum() ? stringStatistics.getSum() : 0L;
        return new StringStatistics(minimum, maximum, sum);
    }

    private static DecimalStatistics toDecimalStatistics(OrcProto.DecimalStatistics decimalStatistics) {
        BigDecimal minimum = decimalStatistics.hasMinimum() ? new BigDecimal(decimalStatistics.getMinimum()) : null;
        BigDecimal maximum = decimalStatistics.hasMaximum() ? new BigDecimal(decimalStatistics.getMaximum()) : null;
        return new DecimalStatistics(minimum, maximum, 8L);
    }

    private static BinaryStatistics toBinaryStatistics(OrcProto.BinaryStatistics binaryStatistics) {
        if (!binaryStatistics.hasSum()) {
            return null;
        }
        return new BinaryStatistics(binaryStatistics.getSum());
    }

    private static Slice byteStringToSlice(ByteString value) {
        return Slices.wrappedBuffer((byte[])value.toByteArray());
    }

    @VisibleForTesting
    public static Slice maxStringTruncateToValidRange(Slice value, PostScript.HiveWriterVersion version) {
        if (value == null) {
            return null;
        }
        if (version != PostScript.HiveWriterVersion.ORIGINAL) {
            return value;
        }
        int index = OrcMetadataReader.findStringStatisticTruncationPositionForOriginalOrcWriter(value);
        if (index == value.length()) {
            return value;
        }
        Slice newValue = Slices.copyOf((Slice)value, (int)0, (int)(index + 1));
        newValue.setByte(index, 255);
        return newValue;
    }

    @VisibleForTesting
    public static Slice minStringTruncateToValidRange(Slice value, PostScript.HiveWriterVersion version) {
        if (value == null) {
            return null;
        }
        if (version != PostScript.HiveWriterVersion.ORIGINAL) {
            return value;
        }
        int index = OrcMetadataReader.findStringStatisticTruncationPositionForOriginalOrcWriter(value);
        if (index == value.length()) {
            return value;
        }
        return Slices.copyOf((Slice)value, (int)0, (int)index);
    }

    @VisibleForTesting
    static int findStringStatisticTruncationPositionForOriginalOrcWriter(Slice utf8) {
        int position;
        int codePoint;
        int length = utf8.length();
        for (position = 0; position < length && (codePoint = SliceUtf8.tryGetCodePointAt((Slice)utf8, (int)position)) >= 0 && codePoint != 65533 && codePoint < 65536; position += SliceUtf8.lengthOfCodePoint((int)codePoint)) {
        }
        return position;
    }

    private static DateStatistics toDateStatistics(PostScript.HiveWriterVersion hiveWriterVersion, OrcProto.DateStatistics dateStatistics, boolean isRowGroup) {
        if (hiveWriterVersion == PostScript.HiveWriterVersion.ORIGINAL && !isRowGroup) {
            return null;
        }
        return new DateStatistics(dateStatistics.hasMinimum() ? Integer.valueOf(dateStatistics.getMinimum()) : null, dateStatistics.hasMaximum() ? Integer.valueOf(dateStatistics.getMaximum()) : null);
    }

    private static TimestampStatistics toTimestampStatistics(PostScript.HiveWriterVersion hiveWriterVersion, OrcProto.TimestampStatistics timestampStatistics, boolean isRowGroup) {
        if (hiveWriterVersion == PostScript.HiveWriterVersion.ORIGINAL && !isRowGroup) {
            return null;
        }
        return new TimestampStatistics(timestampStatistics.hasMinimumUtc() ? Long.valueOf(timestampStatistics.getMinimumUtc()) : null, timestampStatistics.hasMaximumUtc() ? Long.valueOf(timestampStatistics.getMaximumUtc()) : null);
    }

    private static OrcType toType(OrcProto.Type type) {
        Optional<Integer> length = Optional.empty();
        if (type.getKind() == OrcProto.Type.Kind.VARCHAR || type.getKind() == OrcProto.Type.Kind.CHAR) {
            length = Optional.of(type.getMaximumLength());
        }
        Optional<Integer> precision = Optional.empty();
        Optional<Integer> scale = Optional.empty();
        if (type.getKind() == OrcProto.Type.Kind.DECIMAL) {
            precision = Optional.of(type.getPrecision());
            scale = Optional.of(type.getScale());
        }
        return new OrcType(OrcMetadataReader.toTypeKind(type.getKind()), OrcMetadataReader.toOrcColumnId(type.getSubtypesList()), (List<String>)type.getFieldNamesList(), length, precision, scale, OrcMetadataReader.toMap(type.getAttributesList()));
    }

    private static List<OrcColumnId> toOrcColumnId(List<Integer> columnIds) {
        return (List)columnIds.stream().map(OrcColumnId::new).collect(ImmutableList.toImmutableList());
    }

    private static ColumnMetadata<OrcType> toType(List<OrcProto.Type> types) {
        return new ColumnMetadata<OrcType>((List)types.stream().map(OrcMetadataReader::toType).collect(ImmutableList.toImmutableList()));
    }

    private static OrcType.OrcTypeKind toTypeKind(OrcProto.Type.Kind typeKind) {
        switch (typeKind) {
            case BOOLEAN: {
                return OrcType.OrcTypeKind.BOOLEAN;
            }
            case BYTE: {
                return OrcType.OrcTypeKind.BYTE;
            }
            case SHORT: {
                return OrcType.OrcTypeKind.SHORT;
            }
            case INT: {
                return OrcType.OrcTypeKind.INT;
            }
            case LONG: {
                return OrcType.OrcTypeKind.LONG;
            }
            case FLOAT: {
                return OrcType.OrcTypeKind.FLOAT;
            }
            case DOUBLE: {
                return OrcType.OrcTypeKind.DOUBLE;
            }
            case STRING: {
                return OrcType.OrcTypeKind.STRING;
            }
            case BINARY: {
                return OrcType.OrcTypeKind.BINARY;
            }
            case TIMESTAMP: {
                return OrcType.OrcTypeKind.TIMESTAMP;
            }
            case TIMESTAMP_INSTANT: {
                return OrcType.OrcTypeKind.TIMESTAMP_INSTANT;
            }
            case LIST: {
                return OrcType.OrcTypeKind.LIST;
            }
            case MAP: {
                return OrcType.OrcTypeKind.MAP;
            }
            case STRUCT: {
                return OrcType.OrcTypeKind.STRUCT;
            }
            case UNION: {
                return OrcType.OrcTypeKind.UNION;
            }
            case DECIMAL: {
                return OrcType.OrcTypeKind.DECIMAL;
            }
            case DATE: {
                return OrcType.OrcTypeKind.DATE;
            }
            case VARCHAR: {
                return OrcType.OrcTypeKind.VARCHAR;
            }
            case CHAR: {
                return OrcType.OrcTypeKind.CHAR;
            }
        }
        throw new IllegalStateException(typeKind + " stream type not implemented yet");
    }

    private static Map<String, String> toMap(List<OrcProto.StringPair> attributes) {
        ImmutableMap.Builder results = ImmutableMap.builder();
        if (attributes != null) {
            for (OrcProto.StringPair attribute : attributes) {
                if (!attribute.hasKey() || !attribute.hasValue()) continue;
                results.put((Object)attribute.getKey(), (Object)attribute.getValue());
            }
        }
        return results.buildOrThrow();
    }

    private static Stream.StreamKind toStreamKind(OrcProto.Stream.Kind streamKind) {
        switch (streamKind) {
            case PRESENT: {
                return Stream.StreamKind.PRESENT;
            }
            case DATA: {
                return Stream.StreamKind.DATA;
            }
            case LENGTH: {
                return Stream.StreamKind.LENGTH;
            }
            case DICTIONARY_DATA: {
                return Stream.StreamKind.DICTIONARY_DATA;
            }
            case DICTIONARY_COUNT: {
                return Stream.StreamKind.DICTIONARY_COUNT;
            }
            case SECONDARY: {
                return Stream.StreamKind.SECONDARY;
            }
            case ROW_INDEX: {
                return Stream.StreamKind.ROW_INDEX;
            }
            case BLOOM_FILTER: {
                return Stream.StreamKind.BLOOM_FILTER;
            }
            case BLOOM_FILTER_UTF8: {
                return Stream.StreamKind.BLOOM_FILTER_UTF8;
            }
        }
        throw new IllegalStateException(streamKind + " stream type not implemented yet");
    }

    private static ColumnEncoding.ColumnEncodingKind toColumnEncodingKind(OrcProto.ColumnEncoding.Kind columnEncodingKind) {
        switch (columnEncodingKind) {
            case DIRECT: {
                return ColumnEncoding.ColumnEncodingKind.DIRECT;
            }
            case DIRECT_V2: {
                return ColumnEncoding.ColumnEncodingKind.DIRECT_V2;
            }
            case DICTIONARY: {
                return ColumnEncoding.ColumnEncodingKind.DICTIONARY;
            }
            case DICTIONARY_V2: {
                return ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2;
            }
        }
        throw new IllegalStateException(columnEncodingKind + " stream encoding not implemented yet");
    }

    private static CompressionKind toCompression(OrcProto.CompressionKind compression) {
        switch (compression) {
            case NONE: {
                return CompressionKind.NONE;
            }
            case ZLIB: {
                return CompressionKind.ZLIB;
            }
            case SNAPPY: {
                return CompressionKind.SNAPPY;
            }
            case LZO: {
                break;
            }
            case LZ4: {
                return CompressionKind.LZ4;
            }
            case ZSTD: {
                return CompressionKind.ZSTD;
            }
        }
        throw new IllegalStateException(compression + " compression not implemented yet");
    }
}

