/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.memsql;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.base.util.JsonTypeUtil;
import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.BooleanWriteFunction;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DecimalConfig;
import io.trino.plugin.jdbc.DecimalSessionSessionProperties;
import io.trino.plugin.jdbc.DoubleWriteFunction;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcSortItem;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.LongReadFunction;
import io.trino.plugin.jdbc.LongWriteFunction;
import io.trino.plugin.jdbc.ObjectWriteFunction;
import io.trino.plugin.jdbc.PredicatePushdownController;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.SliceWriteFunction;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.jdbc.TypeHandlingJdbcSessionProperties;
import io.trino.plugin.jdbc.UnsupportedTypeHandling;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.mapping.IdentifierMapping;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.JoinCondition;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;

public class MemSqlClient
extends BaseJdbcClient {
    private static final Logger log = Logger.get(MemSqlClient.class);
    static final int MEMSQL_DATE_TIME_MAX_PRECISION = 6;
    static final int MEMSQL_VARCHAR_MAX_LENGTH = 21844;
    static final int MEMSQL_TEXT_MAX_LENGTH = 65535;
    static final int MEMSQL_MEDIUMTEXT_MAX_LENGTH = 0xFFFFFF;
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd");
    private final Type jsonType;

    @Inject
    public MemSqlClient(BaseJdbcConfig config, ConnectionFactory connectionFactory, QueryBuilder queryBuilder, TypeManager typeManager, IdentifierMapping identifierMapping) {
        super(config, "`", connectionFactory, queryBuilder, identifierMapping);
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.jsonType = typeManager.getType(new TypeSignature("json", new TypeSignatureParameter[0]));
    }

    public boolean supportsAggregationPushdown(ConnectorSession session, JdbcTableHandle table, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        return MemSqlClient.preventTextualTypeAggregationPushdown(groupingSets);
    }

    public Collection<String> listSchemas(Connection connection) {
        ImmutableSet immutableSet;
        block9: {
            ResultSet resultSet = connection.getMetaData().getCatalogs();
            try {
                ImmutableSet.Builder schemaNames = ImmutableSet.builder();
                while (resultSet.next()) {
                    String schemaName = resultSet.getString("TABLE_CAT");
                    if (!this.filterSchema(schemaName)) continue;
                    schemaNames.add((Object)schemaName);
                }
                immutableSet = schemaNames.build();
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            resultSet.close();
        }
        return immutableSet;
    }

    protected boolean filterSchema(String schemaName) {
        if (schemaName.equalsIgnoreCase("memsql")) {
            return false;
        }
        return super.filterSchema(schemaName);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<JdbcColumnHandle> getColumns(ConnectorSession session, JdbcTableHandle tableHandle) {
        if (tableHandle.getColumns().isPresent()) {
            return (List)tableHandle.getColumns().get();
        }
        Preconditions.checkArgument((boolean)tableHandle.isNamedRelation(), (String)"Cannot get columns for %s", (Object)tableHandle);
        SchemaTableName schemaTableName = tableHandle.getRequiredNamedRelation().getSchemaTableName();
        RemoteTableName remoteTableName = tableHandle.getRequiredNamedRelation().getRemoteTableName();
        try (Connection connection = this.connectionFactory.openConnection(session);){
            ImmutableList immutableList;
            block19: {
                ResultSet resultSet = this.getColumns(tableHandle, connection.getMetaData());
                try {
                    Map<String, Integer> timestampPrecisions = MemSqlClient.getTimestampPrecisions(connection, tableHandle);
                    int allColumns = 0;
                    ArrayList<JdbcColumnHandle> columns = new ArrayList<JdbcColumnHandle>();
                    while (resultSet.next()) {
                        if (!Objects.equals(remoteTableName, MemSqlClient.getRemoteTable(resultSet))) continue;
                        ++allColumns;
                        String columnName = resultSet.getString("COLUMN_NAME");
                        Optional<Integer> decimalDigits = MemSqlClient.getInteger((ResultSet)resultSet, (String)"DECIMAL_DIGITS");
                        if (timestampPrecisions.containsKey(columnName)) {
                            decimalDigits = Optional.of(timestampPrecisions.get(columnName));
                        }
                        JdbcTypeHandle typeHandle = new JdbcTypeHandle(((Integer)MemSqlClient.getInteger((ResultSet)resultSet, (String)"DATA_TYPE").orElseThrow(() -> new IllegalStateException("DATA_TYPE is null"))).intValue(), Optional.ofNullable(resultSet.getString("TYPE_NAME")), MemSqlClient.getInteger((ResultSet)resultSet, (String)"COLUMN_SIZE"), decimalDigits, Optional.empty(), Optional.empty());
                        Optional<ColumnMapping> columnMapping = this.toColumnMapping(session, connection, typeHandle);
                        log.debug("Mapping data type of '%s' column '%s': %s mapped to %s", new Object[]{schemaTableName, columnName, typeHandle, columnMapping});
                        boolean nullable = resultSet.getInt("NULLABLE") != 0;
                        Optional<String> comment = Optional.ofNullable(Strings.emptyToNull((String)resultSet.getString("REMARKS")));
                        if (columnMapping.isPresent()) {
                            columns.add(JdbcColumnHandle.builder().setColumnName(columnName).setJdbcTypeHandle(typeHandle).setColumnType(columnMapping.get().getType()).setNullable(nullable).setComment(comment).build());
                        }
                        if (!columnMapping.isEmpty()) continue;
                        UnsupportedTypeHandling unsupportedTypeHandling = TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling((ConnectorSession)session);
                        Verify.verify((unsupportedTypeHandling == UnsupportedTypeHandling.IGNORE ? 1 : 0) != 0, (String)"Unsupported type handling is set to %s, but toTrinoType() returned empty for %s", (Object)unsupportedTypeHandling, (Object)typeHandle);
                    }
                    if (columns.isEmpty()) {
                        throw new TableNotFoundException(schemaTableName, String.format("Table '%s' has no supported columns (all %s columns are not supported)", schemaTableName, allColumns));
                    }
                    immutableList = ImmutableList.copyOf(columns);
                    if (resultSet == null) break block19;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return immutableList;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    private static RemoteTableName getRemoteTable(ResultSet resultSet) throws SQLException {
        return new RemoteTableName(Optional.ofNullable(resultSet.getString("TABLE_CAT")), Optional.ofNullable(resultSet.getString("TABLE_SCHEM")), resultSet.getString("TABLE_NAME"));
    }

    private static Map<String, Integer> getTimestampPrecisions(Connection connection, JdbcTableHandle tableHandle) throws SQLException {
        String sql = "SELECT column_name, column_type FROM information_schema.columns WHERE table_schema = ? AND table_name = ? AND column_type IN ('datetime', 'datetime(6)', 'time', 'time(6)', 'timestamp', 'timestamp(6)')";
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, tableHandle.getCatalogName());
            statement.setString(2, tableHandle.getTableName());
            HashMap<String, Integer> timestampColumnPrecisions = new HashMap<String, Integer>();
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String columnType = resultSet.getString("column_type");
                    int size = columnType.equals("datetime") || columnType.equals("time") || columnType.equals("timestamp") ? 0 : 6;
                    timestampColumnPrecisions.put(resultSet.getString("column_name"), size);
                }
            }
            HashMap<String, Integer> hashMap = timestampColumnPrecisions;
            return hashMap;
        }
    }

    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        String jdbcTypeName = (String)typeHandle.getJdbcTypeName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Type name is missing: " + typeHandle));
        Optional mapping = this.getForcedMappingToVarchar(typeHandle);
        if (mapping.isPresent()) {
            return mapping;
        }
        Optional<ColumnMapping> unsignedMapping = MemSqlClient.getUnsignedMapping(typeHandle);
        if (unsignedMapping.isPresent()) {
            return unsignedMapping;
        }
        if (jdbcTypeName.equalsIgnoreCase("json")) {
            return Optional.of(this.jsonColumnMapping());
        }
        switch (typeHandle.getJdbcType()) {
            case -7: 
            case 16: {
                return Optional.of(StandardColumnMappings.booleanColumnMapping());
            }
            case -6: {
                return Optional.of(StandardColumnMappings.tinyintColumnMapping());
            }
            case 5: {
                return Optional.of(StandardColumnMappings.smallintColumnMapping());
            }
            case 4: {
                return Optional.of(StandardColumnMappings.integerColumnMapping());
            }
            case -5: {
                return Optional.of(StandardColumnMappings.bigintColumnMapping());
            }
            case 7: {
                return Optional.of(ColumnMapping.longMapping((Type)RealType.REAL, (resultSet, columnIndex) -> Float.floatToRawIntBits(resultSet.getFloat(columnIndex)), (LongWriteFunction)StandardColumnMappings.realWriteFunction(), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN));
            }
            case 8: {
                return Optional.of(StandardColumnMappings.doubleColumnMapping());
            }
            case -15: 
            case 1: {
                return Optional.of(StandardColumnMappings.defaultCharColumnMapping((int)typeHandle.getRequiredColumnSize(), (boolean)false));
            }
            case -1: 
            case 12: {
                return Optional.of(StandardColumnMappings.defaultVarcharColumnMapping((int)typeHandle.getRequiredColumnSize(), (boolean)false));
            }
            case 3: {
                int precision = typeHandle.getRequiredColumnSize();
                int decimalDigits = typeHandle.getRequiredDecimalDigits();
                if (DecimalSessionSessionProperties.getDecimalRounding((ConnectorSession)session) == DecimalConfig.DecimalMapping.ALLOW_OVERFLOW && precision > 38) {
                    int scale = Math.min(decimalDigits, DecimalSessionSessionProperties.getDecimalDefaultScale((ConnectorSession)session));
                    return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)38, (int)scale), (RoundingMode)DecimalSessionSessionProperties.getDecimalRoundingMode((ConnectorSession)session)));
                }
                if (precision > 38) break;
                return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)precision, (int)Math.max(decimalDigits, 0))));
            }
            case -4: 
            case -3: 
            case -2: {
                return Optional.of(StandardColumnMappings.varbinaryColumnMapping());
            }
            case 91: {
                return Optional.of(ColumnMapping.longMapping((Type)DateType.DATE, (LongReadFunction)StandardColumnMappings.dateReadFunctionUsingLocalDate(), (LongWriteFunction)MemSqlClient.dateWriteFunction()));
            }
            case 92: {
                TimeType timeType = TimeType.createTimeType((int)typeHandle.getRequiredDecimalDigits());
                return Optional.of(StandardColumnMappings.timeColumnMapping((TimeType)timeType));
            }
            case 93: {
                TimestampType timestampType = TimestampType.createTimestampType((int)typeHandle.getRequiredDecimalDigits());
                return Optional.of(StandardColumnMappings.timestampColumnMapping((TimestampType)timestampType));
            }
        }
        if (TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling((ConnectorSession)session) == UnsupportedTypeHandling.CONVERT_TO_VARCHAR) {
            return MemSqlClient.mapToUnboundedVarchar((JdbcTypeHandle)typeHandle);
        }
        return Optional.empty();
    }

    public ResultSet getTables(Connection connection, Optional<String> schemaName, Optional<String> tableName) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        return metadata.getTables(schemaName.orElse(null), null, MemSqlClient.escapeNamePattern(tableName, (String)metadata.getSearchStringEscape()).orElse(null), this.getTableTypes().map(types -> (String[])types.toArray(String[]::new)).orElse(null));
    }

    public void renameTable(ConnectorSession session, JdbcTableHandle handle, SchemaTableName newTableName) {
        Verify.verify((handle.getSchemaName() == null ? 1 : 0) != 0);
        String catalogName = handle.getCatalogName();
        if (catalogName != null && !catalogName.equalsIgnoreCase(newTableName.getSchemaName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming tables across schemas");
        }
        this.renameTable(session, null, handle.getCatalogName(), handle.getTableName(), newTableName);
    }

    public void renameColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        try (Connection connection = this.connectionFactory.openConnection(session);){
            String newRemoteColumnName = this.getIdentifierMapping().toRemoteColumnName(connection, newColumnName);
            String sql = String.format("ALTER TABLE %s CHANGE %s %s", this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTableName()), this.quoted(jdbcColumn.getColumnName()), this.quoted(newRemoteColumnName));
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public void renameSchema(ConnectorSession session, String schemaName, String newSchemaName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming schemas");
    }

    protected String getTableSchemaName(ResultSet resultSet) throws SQLException {
        return resultSet.getString("TABLE_CAT");
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        if (type == BooleanType.BOOLEAN) {
            return WriteMapping.booleanMapping((String)"boolean", (BooleanWriteFunction)StandardColumnMappings.booleanWriteFunction());
        }
        if (type == TinyintType.TINYINT) {
            return WriteMapping.longMapping((String)"tinyint", (LongWriteFunction)StandardColumnMappings.tinyintWriteFunction());
        }
        if (type == SmallintType.SMALLINT) {
            return WriteMapping.longMapping((String)"smallint", (LongWriteFunction)StandardColumnMappings.smallintWriteFunction());
        }
        if (type == IntegerType.INTEGER) {
            return WriteMapping.longMapping((String)"integer", (LongWriteFunction)StandardColumnMappings.integerWriteFunction());
        }
        if (type == BigintType.BIGINT) {
            return WriteMapping.longMapping((String)"bigint", (LongWriteFunction)StandardColumnMappings.bigintWriteFunction());
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            String dataType = String.format("decimal(%s, %s)", decimalType.getPrecision(), decimalType.getScale());
            if (decimalType.isShort()) {
                return WriteMapping.longMapping((String)dataType, (LongWriteFunction)StandardColumnMappings.shortDecimalWriteFunction((DecimalType)decimalType));
            }
            return WriteMapping.objectMapping((String)dataType, (ObjectWriteFunction)StandardColumnMappings.longDecimalWriteFunction((DecimalType)decimalType));
        }
        if (RealType.REAL.equals((Object)type)) {
            return WriteMapping.longMapping((String)"float", (LongWriteFunction)StandardColumnMappings.realWriteFunction());
        }
        if (type == DoubleType.DOUBLE) {
            return WriteMapping.doubleMapping((String)"double precision", (DoubleWriteFunction)StandardColumnMappings.doubleWriteFunction());
        }
        if (type instanceof CharType) {
            return WriteMapping.sliceMapping((String)("char(" + ((CharType)type).getLength() + ")"), (SliceWriteFunction)StandardColumnMappings.charWriteFunction());
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            Object dataType = varcharType.isUnbounded() ? "longtext" : (varcharType.getBoundedLength() <= 21844 ? "varchar(" + varcharType.getBoundedLength() + ")" : (varcharType.getBoundedLength() <= 65535 ? "text" : (varcharType.getBoundedLength() <= 0xFFFFFF ? "mediumtext" : "longtext")));
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return WriteMapping.sliceMapping((String)"longblob", (SliceWriteFunction)StandardColumnMappings.varbinaryWriteFunction());
        }
        if (type == DateType.DATE) {
            return WriteMapping.longMapping((String)"date", (LongWriteFunction)MemSqlClient.dateWriteFunction());
        }
        if (type instanceof TimeType) {
            TimeType timeType = (TimeType)type;
            Preconditions.checkArgument((timeType.getPrecision() <= 6 ? 1 : 0) != 0, (Object)"The max time precision in MemSQL is 6");
            if (timeType.getPrecision() == 0) {
                return WriteMapping.longMapping((String)"time", (LongWriteFunction)StandardColumnMappings.timeWriteFunction((int)0));
            }
            return WriteMapping.longMapping((String)"time(6)", (LongWriteFunction)StandardColumnMappings.timeWriteFunction((int)6));
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            Preconditions.checkArgument((timestampType.getPrecision() <= 6 ? 1 : 0) != 0, (Object)"The max timestamp precision in MemSQL is 6");
            if (timestampType.getPrecision() == 0) {
                return WriteMapping.longMapping((String)"datetime", (LongWriteFunction)StandardColumnMappings.timestampWriteFunction((TimestampType)timestampType));
            }
            return WriteMapping.longMapping((String)String.format("datetime(%s)", 6), (LongWriteFunction)StandardColumnMappings.timestampWriteFunction((TimestampType)TimestampType.TIMESTAMP_MICROS));
        }
        if (type.equals(this.jsonType)) {
            return WriteMapping.sliceMapping((String)"json", (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> sql + " LIMIT " + limit);
    }

    public boolean isLimitGuaranteed(ConnectorSession session) {
        return true;
    }

    public boolean supportsTopN(ConnectorSession session, JdbcTableHandle handle, List<JdbcSortItem> sortOrder) {
        for (JdbcSortItem sortItem : sortOrder) {
            Type sortItemType = sortItem.getColumn().getColumnType();
            if (!(sortItemType instanceof CharType) && !(sortItemType instanceof VarcharType)) continue;
            return false;
        }
        return true;
    }

    protected Optional<BaseJdbcClient.TopNFunction> topNFunction() {
        return Optional.of((query, sortItems, limit) -> {
            String orderBy = sortItems.stream().flatMap(sortItem -> {
                String ordering = sortItem.getSortOrder().isAscending() ? "ASC" : "DESC";
                String columnSorting = String.format("%s %s", this.quoted(sortItem.getColumn().getColumnName()), ordering);
                switch (sortItem.getSortOrder()) {
                    case ASC_NULLS_FIRST: 
                    case DESC_NULLS_LAST: {
                        return Stream.of(columnSorting);
                    }
                    case ASC_NULLS_LAST: {
                        return Stream.of(String.format("ISNULL(%s) ASC", this.quoted(sortItem.getColumn().getColumnName())), columnSorting);
                    }
                    case DESC_NULLS_FIRST: {
                        return Stream.of(String.format("ISNULL(%s) DESC", this.quoted(sortItem.getColumn().getColumnName())), columnSorting);
                    }
                }
                throw new UnsupportedOperationException("Unsupported sort order: " + sortItem.getSortOrder());
            }).collect(Collectors.joining(", "));
            return String.format("%s ORDER BY %s LIMIT %s", query, orderBy, limit);
        });
    }

    public boolean isTopNGuaranteed(ConnectorSession session) {
        return true;
    }

    public Optional<PreparedQuery> implementJoin(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, PreparedQuery rightSource, List<JdbcJoinCondition> joinConditions, Map<JdbcColumnHandle, String> rightAssignments, Map<JdbcColumnHandle, String> leftAssignments, JoinStatistics statistics) {
        if (joinType == JoinType.FULL_OUTER) {
            return Optional.empty();
        }
        return super.implementJoin(session, joinType, leftSource, rightSource, joinConditions, rightAssignments, leftAssignments, statistics);
    }

    protected boolean isSupportedJoinCondition(ConnectorSession session, JdbcJoinCondition joinCondition) {
        if (joinCondition.getOperator() == JoinCondition.Operator.IS_DISTINCT_FROM) {
            return false;
        }
        return Stream.of(joinCondition.getLeftColumn(), joinCondition.getRightColumn()).map(JdbcColumnHandle::getColumnType).noneMatch(type -> type instanceof CharType || type instanceof VarcharType);
    }

    private static Optional<ColumnMapping> getUnsignedMapping(JdbcTypeHandle typeHandle) {
        if (typeHandle.getJdbcTypeName().isEmpty()) {
            return Optional.empty();
        }
        String typeName = (String)typeHandle.getJdbcTypeName().get();
        if (typeName.equalsIgnoreCase("tinyint unsigned")) {
            return Optional.of(StandardColumnMappings.smallintColumnMapping());
        }
        if (typeName.equalsIgnoreCase("smallint unsigned")) {
            return Optional.of(StandardColumnMappings.integerColumnMapping());
        }
        if (typeName.equalsIgnoreCase("int unsigned")) {
            return Optional.of(StandardColumnMappings.bigintColumnMapping());
        }
        if (typeName.equalsIgnoreCase("bigint unsigned")) {
            return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)20)));
        }
        return Optional.empty();
    }

    private static LongWriteFunction dateWriteFunction() {
        return (statement, index, day) -> statement.setString(index, DATE_FORMATTER.format(LocalDate.ofEpochDay(day)));
    }

    private ColumnMapping jsonColumnMapping() {
        return ColumnMapping.sliceMapping((Type)this.jsonType, (resultSet, columnIndex) -> JsonTypeUtil.jsonParse((Slice)Slices.utf8Slice((String)resultSet.getString(columnIndex))), (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction(), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN);
    }
}

