/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.clickhouse;

import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseDataType;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.InetAddresses;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.base.aggregation.AggregateFunctionRewriter;
import io.trino.plugin.clickhouse.ClickHouseEngineType;
import io.trino.plugin.clickhouse.ClickHouseSessionProperties;
import io.trino.plugin.clickhouse.ClickHouseTableProperties;
import io.trino.plugin.clickhouse.ImplementAvgBigint;
import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.BooleanWriteFunction;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DecimalConfig;
import io.trino.plugin.jdbc.DecimalSessionSessionProperties;
import io.trino.plugin.jdbc.DoubleWriteFunction;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.LongReadFunction;
import io.trino.plugin.jdbc.LongWriteFunction;
import io.trino.plugin.jdbc.ObjectWriteFunction;
import io.trino.plugin.jdbc.PredicatePushdownController;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.SliceReadFunction;
import io.trino.plugin.jdbc.SliceWriteFunction;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.aggregation.ImplementAvgFloatingPoint;
import io.trino.plugin.jdbc.aggregation.ImplementCount;
import io.trino.plugin.jdbc.aggregation.ImplementCountAll;
import io.trino.plugin.jdbc.aggregation.ImplementMinMax;
import io.trino.plugin.jdbc.aggregation.ImplementSum;
import io.trino.plugin.jdbc.mapping.IdentifierMapping;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.io.UncheckedIOException;
import java.math.RoundingMode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class ClickHouseClient
extends BaseJdbcClient {
    private static final Splitter TABLE_PROPERTY_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private static final long MIN_SUPPORTED_DATE_EPOCH = LocalDate.parse("1970-01-01").toEpochDay();
    private static final long MAX_SUPPORTED_DATE_EPOCH = LocalDate.parse("2106-02-07").toEpochDay();
    private static final LocalDateTime MIN_SUPPORTED_TIMESTAMP = LocalDateTime.parse("1970-01-01T00:00:00");
    private static final LocalDateTime MAX_SUPPORTED_TIMESTAMP = LocalDateTime.parse("2105-12-31T23:59:59");
    private static final long MIN_SUPPORTED_TIMESTAMP_EPOCH = MIN_SUPPORTED_TIMESTAMP.toEpochSecond(ZoneOffset.UTC);
    private static final long MAX_SUPPORTED_TIMESTAMP_EPOCH = MAX_SUPPORTED_TIMESTAMP.toEpochSecond(ZoneOffset.UTC);
    private final AggregateFunctionRewriter<JdbcExpression> aggregateFunctionRewriter;
    private final Type uuidType;
    private final Type ipAddressType;

    @Inject
    public ClickHouseClient(BaseJdbcConfig config, ConnectionFactory connectionFactory, QueryBuilder queryBuilder, TypeManager typeManager, IdentifierMapping identifierMapping) {
        super(config, "\"", connectionFactory, queryBuilder, identifierMapping);
        this.uuidType = typeManager.getType(new TypeSignature("uuid", new TypeSignatureParameter[0]));
        this.ipAddressType = typeManager.getType(new TypeSignature("ipaddress", new TypeSignatureParameter[0]));
        JdbcTypeHandle bigintTypeHandle = new JdbcTypeHandle(-5, Optional.of("bigint"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        this.aggregateFunctionRewriter = new AggregateFunctionRewriter(arg_0 -> ((ClickHouseClient)this).quoted(arg_0), (Set)ImmutableSet.builder().add((Object)new ImplementCountAll(bigintTypeHandle)).add((Object)new ImplementCount(bigintTypeHandle)).add((Object)new ImplementMinMax(false)).add((Object)new ImplementSum(ClickHouseClient::toTypeHandle)).add((Object)new ImplementAvgFloatingPoint()).add((Object)new ImplementAvgBigint()).build());
    }

    public Optional<JdbcExpression> implementAggregation(ConnectorSession session, AggregateFunction aggregate, Map<String, ColumnHandle> assignments) {
        return this.aggregateFunctionRewriter.rewrite(session, aggregate, assignments);
    }

    public boolean supportsAggregationPushdown(ConnectorSession session, JdbcTableHandle table, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        return ClickHouseClient.preventTextualTypeAggregationPushdown(groupingSets);
    }

    private static Optional<JdbcTypeHandle> toTypeHandle(DecimalType decimalType) {
        return Optional.of(new JdbcTypeHandle(3, Optional.of("Decimal"), Optional.of(decimalType.getPrecision()), Optional.of(decimalType.getScale()), Optional.empty(), Optional.empty()));
    }

    protected String quoted(@Nullable String catalog, @Nullable String schema, String table) {
        StringBuilder sb = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)schema)) {
            sb.append(this.quoted(schema)).append(".");
        }
        sb.append(this.quoted(table));
        return sb.toString();
    }

    protected void copyTableSchema(Connection connection, String catalogName, String schemaName, String tableName, String newTableName, List<String> columnNames) {
        String sql = String.format("CREATE TABLE %s AS %s ", this.quoted(null, schemaName, newTableName), this.quoted(null, schemaName, tableName));
        this.execute(connection, sql);
    }

    protected String createTableSql(RemoteTableName remoteTableName, List<String> columns, ConnectorTableMetadata tableMetadata) {
        ImmutableList.Builder tableOptions = ImmutableList.builder();
        Map tableProperties = tableMetadata.getProperties();
        ClickHouseEngineType engine = ClickHouseTableProperties.getEngine(tableProperties);
        tableOptions.add((Object)("ENGINE = " + engine.getEngineType()));
        if (engine == ClickHouseEngineType.MERGETREE && this.formatProperty(ClickHouseTableProperties.getOrderBy(tableProperties)).isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("The property of %s is required for table engine %s", "order_by", engine.getEngineType()));
        }
        this.formatProperty(ClickHouseTableProperties.getOrderBy(tableProperties)).ifPresent(value -> tableOptions.add((Object)("ORDER BY " + value)));
        this.formatProperty(ClickHouseTableProperties.getPrimaryKey(tableProperties)).ifPresent(value -> tableOptions.add((Object)("PRIMARY KEY " + value)));
        this.formatProperty(ClickHouseTableProperties.getPartitionBy(tableProperties)).ifPresent(value -> tableOptions.add((Object)("PARTITION BY " + value)));
        ClickHouseTableProperties.getSampleBy(tableProperties).ifPresent(value -> tableOptions.add((Object)("SAMPLE BY " + value)));
        return String.format("CREATE TABLE %s (%s) %s", this.quoted(remoteTableName), String.join((CharSequence)", ", columns), String.join((CharSequence)" ", (Iterable<? extends CharSequence>)tableOptions.build()));
    }

    /*
     * Exception decompiling
     */
    public Map<String, Object> getTableProperties(ConnectorSession session, JdbcTableHandle tableHandle) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setTableProperties(ConnectorSession session, JdbcTableHandle handle, Map<String, Optional<Object>> nullableProperties) {
        Preconditions.checkArgument((nullableProperties.size() == 1 && nullableProperties.containsKey("sample_by") ? 1 : 0) != 0, (Object)"Only support setting 'sample_by' property");
        Preconditions.checkArgument((boolean)nullableProperties.values().stream().noneMatch(Optional::isEmpty), (Object)"Setting a property to null is not supported");
        Map properties = (Map)nullableProperties.entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Optional)entry.getValue()).orElseThrow()));
        ImmutableList.Builder tableOptions = ImmutableList.builder();
        ClickHouseTableProperties.getSampleBy(properties).ifPresent(value -> tableOptions.add((Object)("SAMPLE BY " + value)));
        try (Connection connection = this.connectionFactory.openConnection(session);){
            String sql = String.format("ALTER TABLE %s MODIFY %s", this.quoted(handle.asPlainTable().getRemoteTableName()), String.join((CharSequence)" ", (Iterable<? extends CharSequence>)tableOptions.build()));
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected String getColumnDefinitionSql(ConnectorSession session, ColumnMetadata column, String columnName) {
        StringBuilder sb = new StringBuilder().append(this.quoted(columnName)).append(" ");
        if (column.isNullable()) {
            sb.append("Nullable(").append(this.toWriteMapping(session, column.getType()).getDataType()).append(")");
        } else {
            sb.append(this.toWriteMapping(session, column.getType()).getDataType());
        }
        return sb.toString();
    }

    public void createSchema(ConnectorSession session, String schemaName) {
        this.execute(session, "CREATE DATABASE " + this.quoted(schemaName));
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        this.execute(session, "DROP DATABASE " + this.quoted(schemaName));
    }

    protected String renameSchemaSql(String remoteSchemaName, String newRemoteSchemaName) {
        return "RENAME DATABASE " + this.quoted(remoteSchemaName) + " TO " + this.quoted(newRemoteSchemaName);
    }

    public void addColumn(ConnectorSession session, JdbcTableHandle handle, ColumnMetadata column) {
        try (Connection connection = this.connectionFactory.openConnection(session);){
            String remoteColumnName = this.getIdentifierMapping().toRemoteColumnName(connection, column.getName());
            String sql = String.format("ALTER TABLE %s ADD COLUMN %s", this.quoted(handle.asPlainTable().getRemoteTableName()), this.getColumnDefinitionSql(session, column, remoteColumnName));
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public void renameColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        try (Connection connection = this.connectionFactory.openConnection(session);){
            String newRemoteColumnName = this.getIdentifierMapping().toRemoteColumnName(connection, newColumnName);
            String sql = String.format("ALTER TABLE %s RENAME COLUMN %s TO %s ", this.quoted(handle.getRemoteTableName()), this.quoted(jdbcColumn.getColumnName()), this.quoted(newRemoteColumnName));
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public void setColumnComment(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Optional<String> comment) {
        String sql = String.format("ALTER TABLE %s COMMENT COLUMN %s '%s'", this.quoted(handle.asPlainTable().getRemoteTableName()), this.quoted(column.getColumnName()), comment.orElse(""));
        this.execute(session, sql);
    }

    protected Optional<List<String>> getTableTypes() {
        return Optional.empty();
    }

    public void dropTable(ConnectorSession session, JdbcTableHandle handle) {
        String sql = "DROP TABLE " + this.quoted(handle.getRemoteTableName());
        this.execute(session, sql);
    }

    protected void renameTable(ConnectorSession session, String catalogName, String schemaName, String tableName, SchemaTableName newTable) {
        String sql = String.format("RENAME TABLE %s.%s TO %s.%s", this.quoted(schemaName), this.quoted(tableName), this.quoted(newTable.getSchemaName()), this.quoted(newTable.getTableName()));
        this.execute(session, sql);
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> sql + " LIMIT " + limit);
    }

    public boolean isLimitGuaranteed(ConnectorSession session) {
        return true;
    }

    public OptionalLong delete(ConnectorSession session, JdbcTableHandle handle) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support deletes");
    }

    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        String jdbcTypeName = (String)typeHandle.getJdbcTypeName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Type name is missing: " + typeHandle));
        Optional mapping = this.getForcedMappingToVarchar(typeHandle);
        if (mapping.isPresent()) {
            return mapping;
        }
        ClickHouseColumn column = ClickHouseColumn.of((String)"", (String)jdbcTypeName);
        ClickHouseDataType columnDataType = column.getDataType();
        switch (columnDataType) {
            case IPv4: {
                return Optional.of(this.ipAddressColumnMapping("IPv4StringToNum(?)"));
            }
            case IPv6: {
                return Optional.of(this.ipAddressColumnMapping("IPv6StringToNum(?)"));
            }
            case Enum8: 
            case Enum16: {
                return Optional.of(ColumnMapping.sliceMapping((Type)VarcharType.createUnboundedVarcharType(), (SliceReadFunction)StandardColumnMappings.varcharReadFunction((VarcharType)VarcharType.createUnboundedVarcharType()), (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction(), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN));
            }
            case FixedString: 
            case String: {
                if (ClickHouseSessionProperties.isMapStringAsVarchar(session)) {
                    return Optional.of(ColumnMapping.sliceMapping((Type)VarcharType.createUnboundedVarcharType(), (SliceReadFunction)StandardColumnMappings.varcharReadFunction((VarcharType)VarcharType.createUnboundedVarcharType()), (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction(), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN));
                }
                return Optional.of(StandardColumnMappings.varbinaryColumnMapping());
            }
            case UUID: {
                return Optional.of(this.uuidColumnMapping());
            }
        }
        switch (typeHandle.getJdbcType()) {
            case -6: {
                return Optional.of(StandardColumnMappings.tinyintColumnMapping());
            }
            case 5: {
                return Optional.of(StandardColumnMappings.smallintColumnMapping());
            }
            case 4: {
                return Optional.of(StandardColumnMappings.integerColumnMapping());
            }
            case -5: {
                return Optional.of(StandardColumnMappings.bigintColumnMapping());
            }
            case 6: 
            case 7: {
                return Optional.of(ColumnMapping.longMapping((Type)RealType.REAL, (resultSet, columnIndex) -> Float.floatToRawIntBits(resultSet.getFloat(columnIndex)), (LongWriteFunction)StandardColumnMappings.realWriteFunction(), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN));
            }
            case 8: {
                return Optional.of(StandardColumnMappings.doubleColumnMapping());
            }
            case 3: {
                ColumnMapping decimalColumnMapping;
                int decimalDigits = typeHandle.getRequiredDecimalDigits();
                int precision = typeHandle.getRequiredColumnSize();
                if (DecimalSessionSessionProperties.getDecimalRounding((ConnectorSession)session) == DecimalConfig.DecimalMapping.ALLOW_OVERFLOW && precision > 38) {
                    int scale = Math.min(decimalDigits, DecimalSessionSessionProperties.getDecimalDefaultScale((ConnectorSession)session));
                    decimalColumnMapping = StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)38, (int)scale), (RoundingMode)DecimalSessionSessionProperties.getDecimalRoundingMode((ConnectorSession)session));
                } else {
                    decimalColumnMapping = StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)precision, (int)Math.max(decimalDigits, 0)));
                }
                return Optional.of(new ColumnMapping(decimalColumnMapping.getType(), decimalColumnMapping.getReadFunction(), decimalColumnMapping.getWriteFunction(), PredicatePushdownController.DISABLE_PUSHDOWN));
            }
            case 91: {
                return Optional.of(ClickHouseClient.dateColumnMappingUsingLocalDate());
            }
            case 93: {
                if (columnDataType == ClickHouseDataType.DateTime) {
                    Verify.verify((typeHandle.getRequiredDecimalDigits() == 0 ? 1 : 0) != 0, (String)"Expected 0 as timestamp precision, but got %s", (int)typeHandle.getRequiredDecimalDigits());
                    return Optional.of(ColumnMapping.longMapping((Type)TimestampType.TIMESTAMP_SECONDS, (LongReadFunction)StandardColumnMappings.timestampReadFunction((TimestampType)TimestampType.TIMESTAMP_SECONDS), (LongWriteFunction)ClickHouseClient.timestampSecondsWriteFunction()));
                }
                return Optional.of(StandardColumnMappings.timestampColumnMappingUsingSqlTimestampWithRounding((TimestampType)TimestampType.TIMESTAMP_MILLIS));
            }
        }
        return Optional.empty();
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        if (type == BooleanType.BOOLEAN) {
            return WriteMapping.booleanMapping((String)"UInt8", (BooleanWriteFunction)StandardColumnMappings.booleanWriteFunction());
        }
        if (type == TinyintType.TINYINT) {
            return WriteMapping.longMapping((String)"Int8", (LongWriteFunction)StandardColumnMappings.tinyintWriteFunction());
        }
        if (type == SmallintType.SMALLINT) {
            return WriteMapping.longMapping((String)"Int16", (LongWriteFunction)StandardColumnMappings.smallintWriteFunction());
        }
        if (type == IntegerType.INTEGER) {
            return WriteMapping.longMapping((String)"Int32", (LongWriteFunction)StandardColumnMappings.integerWriteFunction());
        }
        if (type == BigintType.BIGINT) {
            return WriteMapping.longMapping((String)"Int64", (LongWriteFunction)StandardColumnMappings.bigintWriteFunction());
        }
        if (type == RealType.REAL) {
            return WriteMapping.longMapping((String)"Float32", (LongWriteFunction)StandardColumnMappings.realWriteFunction());
        }
        if (type == DoubleType.DOUBLE) {
            return WriteMapping.doubleMapping((String)"Float64", (DoubleWriteFunction)StandardColumnMappings.doubleWriteFunction());
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            String dataType = String.format("Decimal(%s, %s)", decimalType.getPrecision(), decimalType.getScale());
            if (decimalType.isShort()) {
                return WriteMapping.longMapping((String)dataType, (LongWriteFunction)StandardColumnMappings.shortDecimalWriteFunction((DecimalType)decimalType));
            }
            return WriteMapping.objectMapping((String)dataType, (ObjectWriteFunction)StandardColumnMappings.longDecimalWriteFunction((DecimalType)decimalType));
        }
        if (type instanceof CharType || type instanceof VarcharType) {
            return WriteMapping.sliceMapping((String)"String", (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        if (type instanceof VarbinaryType) {
            return WriteMapping.sliceMapping((String)"String", (SliceWriteFunction)StandardColumnMappings.varbinaryWriteFunction());
        }
        if (type == DateType.DATE) {
            return WriteMapping.longMapping((String)"Date", (LongWriteFunction)ClickHouseClient.dateWriteFunctionUsingLocalDate());
        }
        if (type == TimestampType.TIMESTAMP_SECONDS) {
            return WriteMapping.longMapping((String)"DateTime", (LongWriteFunction)ClickHouseClient.timestampSecondsWriteFunction());
        }
        if (type.equals(this.uuidType)) {
            return WriteMapping.sliceMapping((String)"UUID", (SliceWriteFunction)ClickHouseClient.uuidWriteFunction());
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type);
    }

    private Optional<String> formatProperty(List<String> prop) {
        if (prop == null || prop.isEmpty()) {
            return Optional.empty();
        }
        if (prop.size() == 1) {
            return Optional.of(prop.get(0));
        }
        return Optional.of("(" + String.join((CharSequence)",", prop) + ")");
    }

    private static ColumnMapping dateColumnMappingUsingLocalDate() {
        return ColumnMapping.longMapping((Type)DateType.DATE, (LongReadFunction)StandardColumnMappings.dateReadFunctionUsingLocalDate(), (LongWriteFunction)ClickHouseClient.dateWriteFunctionUsingLocalDate());
    }

    private static LongWriteFunction dateWriteFunctionUsingLocalDate() {
        return (statement, index, value) -> {
            ClickHouseClient.verifySupportedDate(value);
            statement.setObject(index, LocalDate.ofEpochDay(value));
        };
    }

    private static void verifySupportedDate(long value) {
        if (value < MIN_SUPPORTED_DATE_EPOCH || value > MAX_SUPPORTED_DATE_EPOCH) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Date must be between %s and %s in ClickHouse: %s", LocalDate.ofEpochDay(MIN_SUPPORTED_DATE_EPOCH), LocalDate.ofEpochDay(MAX_SUPPORTED_DATE_EPOCH), LocalDate.ofEpochDay(value)));
        }
    }

    private static LongWriteFunction timestampSecondsWriteFunction() {
        return (statement, index, value) -> {
            long epochSecond = Math.floorDiv(value, 1000000);
            int nanoFraction = Math.floorMod(value, 1000000) * 1000;
            Verify.verify((nanoFraction == 0 ? 1 : 0) != 0, (String)"Nanos of second must be zero: '%s'", (long)value);
            ClickHouseClient.verifySupportedTimestamp(epochSecond);
            statement.setObject(index, LocalDateTime.ofEpochSecond(epochSecond, 0, ZoneOffset.UTC));
        };
    }

    private static void verifySupportedTimestamp(long epochSecond) {
        if (epochSecond < MIN_SUPPORTED_TIMESTAMP_EPOCH || epochSecond > MAX_SUPPORTED_TIMESTAMP_EPOCH) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss");
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Timestamp must be between %s and %s in ClickHouse: %s", MIN_SUPPORTED_TIMESTAMP.format(formatter), MAX_SUPPORTED_TIMESTAMP.format(formatter), LocalDateTime.ofEpochSecond(epochSecond, 0, ZoneOffset.UTC).format(formatter)));
        }
    }

    private ColumnMapping ipAddressColumnMapping(String writeBindExpression) {
        return ColumnMapping.sliceMapping((Type)this.ipAddressType, (resultSet, columnIndex) -> {
            byte[] bytes;
            byte[] address = InetAddresses.forString((String)resultSet.getString(columnIndex)).getAddress();
            if (address.length == 4) {
                bytes = new byte[16];
                bytes[10] = -1;
                bytes[11] = -1;
                System.arraycopy(address, 0, bytes, 12, 4);
            } else if (address.length == 16) {
                bytes = address;
            } else {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Invalid InetAddress length: " + address.length);
            }
            return Slices.wrappedBuffer((byte[])bytes);
        }, (SliceWriteFunction)ClickHouseClient.ipAddressWriteFunction(writeBindExpression));
    }

    private static SliceWriteFunction ipAddressWriteFunction(final String bindExpression) {
        return new SliceWriteFunction(){

            public String getBindExpression() {
                return bindExpression;
            }

            public void set(PreparedStatement statement, int index, Slice value) throws SQLException {
                try {
                    statement.setObject(index, (Object)InetAddresses.toAddrString((InetAddress)InetAddress.getByAddress(value.getBytes())), 1111);
                }
                catch (UnknownHostException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
    }

    private ColumnMapping uuidColumnMapping() {
        return ColumnMapping.sliceMapping((Type)this.uuidType, (resultSet, columnIndex) -> UuidType.javaUuidToTrinoUuid((UUID)((UUID)resultSet.getObject(columnIndex))), (SliceWriteFunction)ClickHouseClient.uuidWriteFunction());
    }

    private static SliceWriteFunction uuidWriteFunction() {
        return (statement, index, value) -> statement.setObject(index, (Object)UuidType.trinoUuidToJavaUuid((Slice)value), 1111);
    }

    private static /* synthetic */ void lambda$getTableProperties$4(ImmutableMap.Builder properties, ClickHouseEngineType type) {
        properties.put((Object)"engine", (Object)type);
    }
}

