/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.clickhouse;

import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.ForwardingConnection;
import io.trino.spi.connector.ConnectorSession;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import javax.annotation.PreDestroy;

public class ClickHouseConnectionFactory
implements ConnectionFactory {
    private final ConnectionFactory delegate;

    public ClickHouseConnectionFactory(ConnectionFactory delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    public Connection openConnection(final ConnectorSession session) throws SQLException {
        return new ForwardingConnection(){
            private final Connection delegate;
            {
                this.delegate = ClickHouseConnectionFactory.this.delegate.openConnection(session);
            }

            protected Connection getDelegate() {
                return this.delegate;
            }

            public void setAutoCommit(boolean autoCommit) {
            }

            public void commit() {
            }

            public void rollback() {
            }
        };
    }

    @PreDestroy
    public void close() throws SQLException {
        this.delegate.close();
    }
}

