/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.VerifyException;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.util.Timestamps;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.False;
import org.apache.iceberg.expressions.True;

public final class ExpressionConverter {
    private ExpressionConverter() {
    }

    public static Expression toIcebergExpression(TupleDomain<IcebergColumnHandle> tupleDomain) {
        if (tupleDomain.isAll()) {
            return Expressions.alwaysTrue();
        }
        if (tupleDomain.getDomains().isEmpty()) {
            return Expressions.alwaysFalse();
        }
        Map domainMap = (Map)tupleDomain.getDomains().get();
        True expression = Expressions.alwaysTrue();
        for (Map.Entry entry : domainMap.entrySet()) {
            IcebergColumnHandle columnHandle = (IcebergColumnHandle)entry.getKey();
            Domain domain = (Domain)entry.getValue();
            expression = Expressions.and((Expression)expression, (Expression)ExpressionConverter.toIcebergExpression(columnHandle.getQualifiedName(), columnHandle.getType(), domain));
        }
        return expression;
    }

    private static Expression toIcebergExpression(String columnName, Type type, Domain domain) {
        if (domain.isAll()) {
            return Expressions.alwaysTrue();
        }
        if (domain.getValues().isNone()) {
            return domain.isNullAllowed() ? Expressions.isNull((String)columnName) : Expressions.alwaysFalse();
        }
        if (domain.getValues().isAll()) {
            return domain.isNullAllowed() ? Expressions.alwaysTrue() : Expressions.not((Expression)Expressions.isNull((String)columnName));
        }
        if (type instanceof ArrayType || type instanceof MapType || type instanceof RowType) {
            throw new UnsupportedOperationException("Unsupported type for expression: " + type);
        }
        if (type.isOrderable()) {
            List orderedRanges = domain.getValues().getRanges().getOrderedRanges();
            ArrayList<Object> icebergValues = new ArrayList<Object>();
            ArrayList<Expression> rangeExpressions = new ArrayList<Expression>();
            for (Range range : orderedRanges) {
                if (range.isSingleValue()) {
                    icebergValues.add(ExpressionConverter.getIcebergLiteralValue(type, range.getLowBoundedValue()));
                    continue;
                }
                rangeExpressions.add(ExpressionConverter.toIcebergExpression(columnName, range));
            }
            Expression ranges = ExpressionConverter.or(rangeExpressions);
            False values = icebergValues.isEmpty() ? Expressions.alwaysFalse() : Expressions.in((String)columnName, icebergValues);
            False nullExpression = domain.isNullAllowed() ? Expressions.isNull((String)columnName) : Expressions.alwaysFalse();
            return ExpressionConverter.or((Expression)nullExpression, ExpressionConverter.or((Expression)values, ranges));
        }
        throw new VerifyException(String.format("Unsupported type %s with domain values %s", type, domain));
    }

    private static Expression toIcebergExpression(String columnName, Range range) {
        True highBound;
        True lowBound;
        Type type = range.getType();
        if (range.isSingleValue()) {
            Object icebergValue = ExpressionConverter.getIcebergLiteralValue(type, range.getSingleValue());
            return Expressions.equal((String)columnName, (Object)icebergValue);
        }
        if (range.isLowUnbounded()) {
            lowBound = Expressions.alwaysTrue();
        } else {
            Object icebergLow = ExpressionConverter.getIcebergLiteralValue(type, range.getLowBoundedValue());
            lowBound = range.isLowInclusive() ? Expressions.greaterThanOrEqual((String)columnName, (Object)icebergLow) : Expressions.greaterThan((String)columnName, (Object)icebergLow);
        }
        if (range.isHighUnbounded()) {
            highBound = Expressions.alwaysTrue();
        } else {
            Object icebergHigh = ExpressionConverter.getIcebergLiteralValue(type, range.getHighBoundedValue());
            highBound = range.isHighInclusive() ? Expressions.lessThanOrEqual((String)columnName, (Object)icebergHigh) : Expressions.lessThan((String)columnName, (Object)icebergHigh);
        }
        return Expressions.and((Expression)lowBound, (Expression)highBound);
    }

    private static Object getIcebergLiteralValue(Type type, Object trinoNativeValue) {
        Objects.requireNonNull(trinoNativeValue, "trinoNativeValue is null");
        if (type instanceof BooleanType) {
            return (boolean)((Boolean)trinoNativeValue);
        }
        if (type instanceof IntegerType) {
            return Math.toIntExact((Long)trinoNativeValue);
        }
        if (type instanceof BigintType) {
            return (long)((Long)trinoNativeValue);
        }
        if (type instanceof RealType) {
            return Float.valueOf(Float.intBitsToFloat(Math.toIntExact((Long)trinoNativeValue)));
        }
        if (type instanceof DoubleType) {
            return (double)((Double)trinoNativeValue);
        }
        if (type instanceof DateType) {
            return Math.toIntExact((Long)trinoNativeValue);
        }
        if (type.equals(TimeType.TIME_MICROS)) {
            return (Long)trinoNativeValue / 1000000L;
        }
        if (type.equals(TimestampType.TIMESTAMP_MICROS)) {
            return (long)((Long)trinoNativeValue);
        }
        if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS)) {
            return Timestamps.timestampTzToMicros((LongTimestampWithTimeZone)trinoNativeValue);
        }
        if (type instanceof VarcharType) {
            return ((Slice)trinoNativeValue).toStringUtf8();
        }
        if (type instanceof VarbinaryType) {
            return ByteBuffer.wrap(((Slice)trinoNativeValue).getBytes());
        }
        if (type instanceof UuidType) {
            return UuidType.trinoUuidToJavaUuid((Slice)((Slice)trinoNativeValue));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (Decimals.isShortDecimal((Type)decimalType)) {
                return BigDecimal.valueOf((Long)trinoNativeValue).movePointLeft(decimalType.getScale());
            }
            return new BigDecimal(((Int128)trinoNativeValue).toBigInteger(), decimalType.getScale());
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    private static Expression or(Expression left, Expression right) {
        return Expressions.or((Expression)left, (Expression)right);
    }

    private static Expression or(List<Expression> expressions) {
        if (expressions.isEmpty()) {
            return Expressions.alwaysFalse();
        }
        if (expressions.size() == 1) {
            return (Expression)Iterables.getOnlyElement(expressions);
        }
        int mid = expressions.size() / 2;
        return ExpressionConverter.or(ExpressionConverter.or(expressions.subList(0, mid)), ExpressionConverter.or(expressions.subList(mid, expressions.size())));
    }
}

