/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.plugin.iceberg.util.PageListBuilder;
import io.trino.spi.Page;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class FilesTable
implements SystemTable {
    private final ConnectorTableMetadata tableMetadata;
    private final Table icebergTable;
    private final Optional<Long> snapshotId;

    public FilesTable(SchemaTableName tableName, TypeManager typeManager, Table icebergTable, Optional<Long> snapshotId) {
        this.icebergTable = Objects.requireNonNull(icebergTable, "icebergTable is null");
        this.tableMetadata = new ConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null"), (List)ImmutableList.builder().add((Object)new ColumnMetadata("content", (io.trino.spi.type.Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("file_path", (io.trino.spi.type.Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("file_format", (io.trino.spi.type.Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("record_count", (io.trino.spi.type.Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("file_size_in_bytes", (io.trino.spi.type.Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("column_sizes", typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature())))).add((Object)new ColumnMetadata("value_counts", typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature())))).add((Object)new ColumnMetadata("null_value_counts", typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature())))).add((Object)new ColumnMetadata("nan_value_counts", typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature())))).add((Object)new ColumnMetadata("lower_bounds", typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature())))).add((Object)new ColumnMetadata("upper_bounds", typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature())))).add((Object)new ColumnMetadata("key_metadata", (io.trino.spi.type.Type)VarbinaryType.VARBINARY)).add((Object)new ColumnMetadata("split_offsets", (io.trino.spi.type.Type)new ArrayType((io.trino.spi.type.Type)BigintType.BIGINT))).add((Object)new ColumnMetadata("equality_ids", (io.trino.spi.type.Type)new ArrayType((io.trino.spi.type.Type)IntegerType.INTEGER))).build());
        this.snapshotId = Objects.requireNonNull(snapshotId, "snapshotId is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        if (this.snapshotId.isEmpty()) {
            return new FixedPageSource((Iterable)ImmutableList.of());
        }
        return new FixedPageSource(FilesTable.buildPages(this.tableMetadata, this.icebergTable, this.snapshotId.get()));
    }

    private static List<Page> buildPages(ConnectorTableMetadata tableMetadata, Table icebergTable, long snapshotId) {
        PageListBuilder pagesBuilder = PageListBuilder.forTable(tableMetadata);
        Map<Integer, Type> idToTypeMapping = FilesTable.getIcebergIdToTypeMapping(icebergTable.schema());
        TableScan tableScan = icebergTable.newScan().useSnapshot(snapshotId).includeColumnStats();
        tableScan.planFiles().forEach(fileScanTask -> {
            DataFile dataFile = fileScanTask.file();
            pagesBuilder.beginRow();
            pagesBuilder.appendInteger(dataFile.content().id());
            pagesBuilder.appendVarchar(dataFile.path().toString());
            pagesBuilder.appendVarchar(dataFile.format().name());
            pagesBuilder.appendBigint(dataFile.recordCount());
            pagesBuilder.appendBigint(dataFile.fileSizeInBytes());
            if (FilesTable.checkNonNull(dataFile.columnSizes(), pagesBuilder)) {
                pagesBuilder.appendIntegerBigintMap(dataFile.columnSizes());
            }
            if (FilesTable.checkNonNull(dataFile.valueCounts(), pagesBuilder)) {
                pagesBuilder.appendIntegerBigintMap(dataFile.valueCounts());
            }
            if (FilesTable.checkNonNull(dataFile.nullValueCounts(), pagesBuilder)) {
                pagesBuilder.appendIntegerBigintMap(dataFile.nullValueCounts());
            }
            if (FilesTable.checkNonNull(dataFile.nanValueCounts(), pagesBuilder)) {
                pagesBuilder.appendIntegerBigintMap(dataFile.nanValueCounts());
            }
            if (FilesTable.checkNonNull(dataFile.lowerBounds(), pagesBuilder)) {
                pagesBuilder.appendIntegerVarcharMap((Map)dataFile.lowerBounds().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> Transforms.identity((Type)((Type)idToTypeMapping.get(entry.getKey()))).toHumanString(Conversions.fromByteBuffer((Type)((Type)idToTypeMapping.get(entry.getKey())), (ByteBuffer)((ByteBuffer)entry.getValue()))))));
            }
            if (FilesTable.checkNonNull(dataFile.upperBounds(), pagesBuilder)) {
                pagesBuilder.appendIntegerVarcharMap((Map)dataFile.upperBounds().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> Transforms.identity((Type)((Type)idToTypeMapping.get(entry.getKey()))).toHumanString(Conversions.fromByteBuffer((Type)((Type)idToTypeMapping.get(entry.getKey())), (ByteBuffer)((ByteBuffer)entry.getValue()))))));
            }
            if (FilesTable.checkNonNull(dataFile.keyMetadata(), pagesBuilder)) {
                pagesBuilder.appendVarbinary(Slices.wrappedBuffer((ByteBuffer)dataFile.keyMetadata()));
            }
            if (FilesTable.checkNonNull(dataFile.splitOffsets(), pagesBuilder)) {
                pagesBuilder.appendBigintArray(dataFile.splitOffsets());
            }
            if (FilesTable.checkNonNull(dataFile.equalityFieldIds(), pagesBuilder)) {
                pagesBuilder.appendIntegerArray(dataFile.equalityFieldIds());
            }
            pagesBuilder.endRow();
        });
        return pagesBuilder.build();
    }

    private static boolean checkNonNull(Object object, PageListBuilder pagesBuilder) {
        if (object == null) {
            pagesBuilder.appendNull();
            return false;
        }
        return true;
    }

    private static Map<Integer, Type> getIcebergIdToTypeMapping(Schema schema) {
        ImmutableMap.Builder icebergIdToTypeMapping = ImmutableMap.builder();
        for (Types.NestedField field : schema.columns()) {
            FilesTable.populateIcebergIdToTypeMapping(field, (ImmutableMap.Builder<Integer, Type>)icebergIdToTypeMapping);
        }
        return icebergIdToTypeMapping.buildOrThrow();
    }

    private static void populateIcebergIdToTypeMapping(Types.NestedField field, ImmutableMap.Builder<Integer, Type> icebergIdToTypeMapping) {
        Type type = field.type();
        icebergIdToTypeMapping.put((Object)field.fieldId(), (Object)type);
        if (type instanceof Type.NestedType) {
            type.asNestedType().fields().forEach(child -> FilesTable.populateIcebergIdToTypeMapping(child, icebergIdToTypeMapping));
        }
    }
}

