/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.MoreObjects;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.security.ConnectorIdentity;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.SeekableInputStream;

public class HdfsInputFile
implements InputFile {
    private final InputFile delegate;
    private final HdfsEnvironment environment;
    private final ConnectorIdentity identity;

    public HdfsInputFile(Path path, HdfsEnvironment environment, HdfsEnvironment.HdfsContext context) {
        Objects.requireNonNull(path, "path is null");
        this.environment = Objects.requireNonNull(environment, "environment is null");
        Objects.requireNonNull(context, "context is null");
        try {
            this.delegate = HadoopInputFile.fromPath((Path)path, (FileSystem)environment.getFileSystem(context, path), (Configuration)environment.getConfiguration(context, path));
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, "Failed to create input file: " + path, (Throwable)e);
        }
        this.identity = context.getIdentity();
    }

    public long getLength() {
        return (Long)this.environment.doAs(this.identity, () -> ((InputFile)this.delegate).getLength());
    }

    public SeekableInputStream newStream() {
        return new HdfsInputStream((SeekableInputStream)this.environment.doAs(this.identity, () -> ((InputFile)this.delegate).newStream()));
    }

    public String location() {
        return this.delegate.location();
    }

    public boolean exists() {
        return (Boolean)this.environment.doAs(this.identity, () -> ((InputFile)this.delegate).exists());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("delegate", (Object)this.delegate).add("identity", (Object)this.identity).toString();
    }

    private static class HdfsInputStream
    extends SeekableInputStream {
        private final SeekableInputStream delegate;

        public HdfsInputStream(SeekableInputStream delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        public int read() throws IOException {
            return this.delegate.read();
        }

        public long getPos() throws IOException {
            return this.delegate.getPos();
        }

        public void seek(long newPos) throws IOException {
            this.delegate.seek(newPos);
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

