/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.PartitionTransforms;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import java.lang.invoke.MethodHandle;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.iceberg.PartitionSpec;

public class IcebergBucketFunction
implements BucketFunction {
    private final int bucketCount;
    private final List<PartitionColumn> partitionColumns;
    private final List<MethodHandle> hashCodeInvokers;

    public IcebergBucketFunction(TypeOperators typeOperators, PartitionSpec partitionSpec, List<IcebergColumnHandle> partitioningColumns, int bucketCount) {
        Objects.requireNonNull(partitionSpec, "partitionSpec is null");
        Preconditions.checkArgument((!partitionSpec.isUnpartitioned() ? 1 : 0) != 0, (Object)"empty partitionSpec");
        Objects.requireNonNull(partitioningColumns, "partitioningColumns is null");
        Objects.requireNonNull(typeOperators, "typeOperators is null");
        Preconditions.checkArgument((bucketCount > 0 ? 1 : 0) != 0, (String)"Invalid bucketCount: %s", (int)bucketCount);
        this.bucketCount = bucketCount;
        HashMap<Integer, Integer> fieldIdToInputChannel = new HashMap<Integer, Integer>();
        for (int i = 0; i < partitioningColumns.size(); ++i) {
            Integer previous = fieldIdToInputChannel.put(partitioningColumns.get(i).getId(), i);
            Preconditions.checkState((previous == null ? 1 : 0) != 0, (String)"Duplicate id %s in %s at %s and %s", (Object)partitioningColumns.get(i).getId(), partitioningColumns, (Object)i, (Object)previous);
        }
        this.partitionColumns = (List)partitionSpec.fields().stream().map(field -> {
            Integer channel = (Integer)fieldIdToInputChannel.get(field.sourceId());
            Preconditions.checkArgument((channel != null ? 1 : 0) != 0, (String)"partition field not found: %s", (Object)field);
            Type inputType = ((IcebergColumnHandle)partitioningColumns.get(channel)).getType();
            PartitionTransforms.ColumnTransform transform = PartitionTransforms.getColumnTransform(field, inputType);
            return new PartitionColumn(channel, transform.getValueTransform(), transform.getType());
        }).collect(ImmutableList.toImmutableList());
        this.hashCodeInvokers = (List)this.partitionColumns.stream().map(PartitionColumn::getResultType).map(type -> typeOperators.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL}))).collect(ImmutableList.toImmutableList());
    }

    public int getBucket(Page page, int position) {
        long hash = 0L;
        for (int i = 0; i < this.partitionColumns.size(); ++i) {
            PartitionColumn partitionColumn = this.partitionColumns.get(i);
            Block block = page.getBlock(partitionColumn.getSourceChannel());
            Object value = partitionColumn.getValueTransform().apply(block, position);
            long valueHash = IcebergBucketFunction.hashValue(this.hashCodeInvokers.get(i), value);
            hash = 31L * hash + valueHash;
        }
        return (int)((hash & Long.MAX_VALUE) % (long)this.bucketCount);
    }

    private static long hashValue(MethodHandle method, Object value) {
        if (value == null) {
            return 0L;
        }
        try {
            return method.invoke(value);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    private static class PartitionColumn {
        private final int sourceChannel;
        private final PartitionTransforms.ValueTransform valueTransform;
        private final Type resultType;

        public PartitionColumn(int sourceChannel, PartitionTransforms.ValueTransform valueTransform, Type resultType) {
            this.sourceChannel = sourceChannel;
            this.valueTransform = Objects.requireNonNull(valueTransform, "valueTransform is null");
            this.resultType = Objects.requireNonNull(resultType, "resultType is null");
        }

        public int getSourceChannel() {
            return this.sourceChannel;
        }

        public Type getResultType() {
            return this.resultType;
        }

        public PartitionTransforms.ValueTransform getValueTransform() {
            return this.valueTransform;
        }
    }
}

