/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class IcebergColumnHandle
implements ColumnHandle {
    private final ColumnIdentity baseColumnIdentity;
    private final Type baseType;
    private final List<Integer> path;
    private final Type type;
    private final Optional<String> comment;
    private final int id;

    @JsonCreator
    public IcebergColumnHandle(@JsonProperty(value="baseColumnIdentity") ColumnIdentity baseColumnIdentity, @JsonProperty(value="baseType") Type baseType, @JsonProperty(value="path") List<Integer> path, @JsonProperty(value="type") Type type, @JsonProperty(value="comment") Optional<String> comment) {
        this.baseColumnIdentity = Objects.requireNonNull(baseColumnIdentity, "baseColumnIdentity is null");
        this.baseType = Objects.requireNonNull(baseType, "baseType is null");
        this.path = ImmutableList.copyOf((Collection)Objects.requireNonNull(path, "path is null"));
        this.type = Objects.requireNonNull(type, "type is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
        this.id = path.isEmpty() ? baseColumnIdentity.getId() : ((Integer)Iterables.getLast(path)).intValue();
    }

    @JsonIgnore
    public ColumnIdentity getColumnIdentity() {
        ColumnIdentity columnIdentity = this.baseColumnIdentity;
        for (int fieldId : this.path) {
            columnIdentity = columnIdentity.getChildByFieldId(fieldId);
        }
        return columnIdentity;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public ColumnIdentity getBaseColumnIdentity() {
        return this.baseColumnIdentity;
    }

    @JsonProperty
    public Type getBaseType() {
        return this.baseType;
    }

    @JsonIgnore
    public IcebergColumnHandle getBaseColumn() {
        return new IcebergColumnHandle(this.getBaseColumnIdentity(), this.getBaseType(), (List<Integer>)ImmutableList.of(), this.getBaseType(), Optional.empty());
    }

    @JsonProperty
    public Optional<String> getComment() {
        return this.comment;
    }

    @JsonIgnore
    public int getId() {
        return this.id;
    }

    @JsonIgnore
    public String getName() {
        return this.getColumnIdentity().getName();
    }

    @JsonProperty
    public List<Integer> getPath() {
        return this.path;
    }

    @JsonIgnore
    public String getQualifiedName() {
        ImmutableList.Builder pathNames = ImmutableList.builder();
        ColumnIdentity columnIdentity = this.baseColumnIdentity;
        pathNames.add((Object)columnIdentity.getName());
        for (int fieldId : this.path) {
            columnIdentity = columnIdentity.getChildByFieldId(fieldId);
            pathNames.add((Object)columnIdentity.getName());
        }
        return String.join((CharSequence)".", (Iterable<? extends CharSequence>)pathNames.build());
    }

    public boolean isBaseColumn() {
        return this.path.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.baseColumnIdentity, this.baseType, this.path, this.type, this.comment);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IcebergColumnHandle other = (IcebergColumnHandle)obj;
        return Objects.equals(this.baseColumnIdentity, other.baseColumnIdentity) && Objects.equals(this.baseType, other.baseType) && Objects.equals(this.path, other.path) && Objects.equals(this.type, other.type) && Objects.equals(this.comment, other.comment);
    }

    public String toString() {
        return this.getId() + ":" + this.getName() + ":" + this.type.getDisplayName();
    }
}

