/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.iceberg.CatalogType;
import io.trino.plugin.iceberg.IcebergFileFormat;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class IcebergConfig {
    private IcebergFileFormat fileFormat = IcebergFileFormat.ORC;
    private HiveCompressionCodec compressionCodec = HiveCompressionCodec.ZSTD;
    private boolean useFileSizeFromMetadata = true;
    private int maxPartitionsPerWriter = 100;
    private boolean uniqueTableLocation;
    private CatalogType catalogType = CatalogType.HIVE_METASTORE;
    private Duration dynamicFilteringWaitTimeout = new Duration(0.0, TimeUnit.SECONDS);
    private boolean tableStatisticsEnabled = true;
    private boolean projectionPushdownEnabled = true;

    public CatalogType getCatalogType() {
        return this.catalogType;
    }

    @Config(value="iceberg.catalog.type")
    public IcebergConfig setCatalogType(CatalogType catalogType) {
        this.catalogType = catalogType;
        return this;
    }

    @NotNull
    public IcebergFileFormat getFileFormat() {
        return this.fileFormat;
    }

    @Config(value="iceberg.file-format")
    public IcebergConfig setFileFormat(IcebergFileFormat fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    @NotNull
    public HiveCompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    @Config(value="iceberg.compression-codec")
    public IcebergConfig setCompressionCodec(HiveCompressionCodec compressionCodec) {
        this.compressionCodec = compressionCodec;
        return this;
    }

    @Deprecated
    public boolean isUseFileSizeFromMetadata() {
        return this.useFileSizeFromMetadata;
    }

    @Deprecated
    @Config(value="iceberg.use-file-size-from-metadata")
    public IcebergConfig setUseFileSizeFromMetadata(boolean useFileSizeFromMetadata) {
        this.useFileSizeFromMetadata = useFileSizeFromMetadata;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxPartitionsPerWriter() {
        return this.maxPartitionsPerWriter;
    }

    @Config(value="iceberg.max-partitions-per-writer")
    @ConfigDescription(value="Maximum number of partitions per writer")
    public IcebergConfig setMaxPartitionsPerWriter(int maxPartitionsPerWriter) {
        this.maxPartitionsPerWriter = maxPartitionsPerWriter;
        return this;
    }

    public boolean isUniqueTableLocation() {
        return this.uniqueTableLocation;
    }

    @Config(value="iceberg.unique-table-location")
    @ConfigDescription(value="Use randomized, unique table locations")
    public IcebergConfig setUniqueTableLocation(boolean uniqueTableLocation) {
        this.uniqueTableLocation = uniqueTableLocation;
        return this;
    }

    @NotNull
    public Duration getDynamicFilteringWaitTimeout() {
        return this.dynamicFilteringWaitTimeout;
    }

    @Config(value="iceberg.dynamic-filtering.wait-timeout")
    @ConfigDescription(value="Duration to wait for completion of dynamic filters during split generation")
    public IcebergConfig setDynamicFilteringWaitTimeout(Duration dynamicFilteringWaitTimeout) {
        this.dynamicFilteringWaitTimeout = dynamicFilteringWaitTimeout;
        return this;
    }

    @Config(value="iceberg.table-statistics-enabled")
    @ConfigDescription(value="Enable use of table statistics")
    public IcebergConfig setTableStatisticsEnabled(boolean tableStatisticsEnabled) {
        this.tableStatisticsEnabled = tableStatisticsEnabled;
        return this;
    }

    public boolean isTableStatisticsEnabled() {
        return this.tableStatisticsEnabled;
    }

    public boolean isProjectionPushdownEnabled() {
        return this.projectionPushdownEnabled;
    }

    @Config(value="iceberg.projection-pushdown-enabled")
    @ConfigDescription(value="Read only required fields from a struct")
    public IcebergConfig setProjectionPushdownEnabled(boolean projectionPushdownEnabled) {
        this.projectionPushdownEnabled = projectionPushdownEnabled;
        return this;
    }
}

