/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Splitter;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.trino.plugin.base.classloader.ClassLoaderSafeSystemTable;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.HiveApplyProjectionUtil;
import io.trino.plugin.hive.HiveWrittenPartitions;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.CommitTaskData;
import io.trino.plugin.iceberg.ExpressionConverter;
import io.trino.plugin.iceberg.FilesTable;
import io.trino.plugin.iceberg.HistoryTable;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergInputInfo;
import io.trino.plugin.iceberg.IcebergPartitioningHandle;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.IcebergTableHandle;
import io.trino.plugin.iceberg.IcebergTableName;
import io.trino.plugin.iceberg.IcebergTableProperties;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.IcebergWritableTableHandle;
import io.trino.plugin.iceberg.ManifestsTable;
import io.trino.plugin.iceberg.PartitionData;
import io.trino.plugin.iceberg.PartitionFields;
import io.trino.plugin.iceberg.PartitionTable;
import io.trino.plugin.iceberg.PropertiesTable;
import io.trino.plugin.iceberg.SnapshotsTable;
import io.trino.plugin.iceberg.TableStatisticsMaker;
import io.trino.plugin.iceberg.TableType;
import io.trino.plugin.iceberg.TrinoCatalog;
import io.trino.plugin.iceberg.TypeConverter;
import io.trino.plugin.iceberg.UnknownTableTypeException;
import io.trino.plugin.iceberg.procedure.IcebergOptimizeHandle;
import io.trino.plugin.iceberg.procedure.IcebergTableExecuteHandle;
import io.trino.plugin.iceberg.procedure.IcebergTableProcedureId;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.BeginTableExecuteResult;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.DiscretePredicates;
import io.trino.spi.connector.MaterializedViewFreshness;
import io.trino.spi.connector.MaterializedViewNotFoundException;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.types.Type;

public class IcebergMetadata
implements ConnectorMetadata {
    private static final Logger log = Logger.get(IcebergMetadata.class);
    private static final Pattern PATH_PATTERN = Pattern.compile("(.*)/[^/]+");
    private final TypeManager typeManager;
    private final JsonCodec<CommitTaskData> commitTaskCodec;
    private final TrinoCatalog catalog;
    private final HdfsEnvironment hdfsEnvironment;
    private final Map<String, Long> snapshotIds = new ConcurrentHashMap<String, Long>();
    private Transaction transaction;

    public IcebergMetadata(TypeManager typeManager, JsonCodec<CommitTaskData> commitTaskCodec, TrinoCatalog catalog, HdfsEnvironment hdfsEnvironment) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.commitTaskCodec = Objects.requireNonNull(commitTaskCodec, "commitTaskCodec is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.catalog.listNamespaces(session);
    }

    public Map<String, Object> getSchemaProperties(ConnectorSession session, CatalogSchemaName schemaName) {
        return this.catalog.loadNamespaceMetadata(session, schemaName.getSchemaName());
    }

    public Optional<TrinoPrincipal> getSchemaOwner(ConnectorSession session, CatalogSchemaName schemaName) {
        return this.catalog.getNamespacePrincipal(session, schemaName.getSchemaName());
    }

    public IcebergTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Table table;
        IcebergTableName name = IcebergTableName.from(tableName.getTableName());
        Verify.verify((name.getTableType() == TableType.DATA ? 1 : 0) != 0, (String)("Wrong table type: " + name.getTableNameWithType()), (Object[])new Object[0]);
        try {
            table = this.catalog.loadTable(session, new SchemaTableName(tableName.getSchemaName(), name.getTableName()));
        }
        catch (TableNotFoundException e) {
            return null;
        }
        Optional<Long> snapshotId = this.getSnapshotId(table, name.getSnapshotId());
        String nameMappingJson = (String)table.properties().get("schema.name-mapping.default");
        return new IcebergTableHandle(tableName.getSchemaName(), name.getTableName(), name.getTableType(), snapshotId, (TupleDomain<IcebergColumnHandle>)TupleDomain.all(), (TupleDomain<IcebergColumnHandle>)TupleDomain.all(), (Set<IcebergColumnHandle>)ImmutableSet.of(), Optional.ofNullable(nameMappingJson));
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        return this.getRawSystemTable(session, tableName).map(systemTable -> new ClassLoaderSafeSystemTable(systemTable, this.getClass().getClassLoader()));
    }

    private Optional<SystemTable> getRawSystemTable(ConnectorSession session, SchemaTableName tableName) {
        Table table;
        IcebergTableName name = IcebergTableName.from(tableName.getTableName());
        if (name.getTableType() == TableType.DATA) {
            return Optional.empty();
        }
        try {
            table = this.catalog.loadTable(session, new SchemaTableName(tableName.getSchemaName(), name.getTableName()));
        }
        catch (TableNotFoundException e) {
            return Optional.empty();
        }
        SchemaTableName systemTableName = new SchemaTableName(tableName.getSchemaName(), name.getTableNameWithType());
        switch (name.getTableType()) {
            case DATA: {
                break;
            }
            case HISTORY: {
                if (name.getSnapshotId().isPresent()) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Snapshot ID not supported for history table: " + systemTableName);
                }
                return Optional.of(new HistoryTable(systemTableName, table));
            }
            case SNAPSHOTS: {
                if (name.getSnapshotId().isPresent()) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Snapshot ID not supported for snapshots table: " + systemTableName);
                }
                return Optional.of(new SnapshotsTable(systemTableName, this.typeManager, table));
            }
            case PARTITIONS: {
                return Optional.of(new PartitionTable(systemTableName, this.typeManager, table, this.getSnapshotId(table, name.getSnapshotId())));
            }
            case MANIFESTS: {
                return Optional.of(new ManifestsTable(systemTableName, table, this.getSnapshotId(table, name.getSnapshotId())));
            }
            case FILES: {
                return Optional.of(new FilesTable(systemTableName, this.typeManager, table, this.getSnapshotId(table, name.getSnapshotId())));
            }
            case PROPERTIES: {
                return Optional.of(new PropertiesTable(systemTableName, table));
            }
        }
        return Optional.empty();
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        if (table.getSnapshotId().isEmpty()) {
            return new ConnectorTableProperties(TupleDomain.none(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of());
        }
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        Set<Integer> partitionSourceIds = IcebergMetadata.identityPartitionColumnsInAllSpecs(icebergTable);
        TupleDomain<IcebergColumnHandle> enforcedPredicate = table.getEnforcedPredicate();
        DiscretePredicates discretePredicates = null;
        if (!partitionSourceIds.isEmpty()) {
            Map columns = (Map)IcebergUtil.getColumns(icebergTable.schema(), this.typeManager).stream().filter(column -> partitionSourceIds.contains(column.getId())).collect(ImmutableMap.toImmutableMap(IcebergColumnHandle::getId, Function.identity()));
            com.google.common.base.Supplier lazyFiles = Suppliers.memoize(() -> {
                ImmutableList immutableList;
                block8: {
                    TableScan tableScan = icebergTable.newScan().useSnapshot(table.getSnapshotId().get().longValue()).filter(ExpressionConverter.toIcebergExpression(enforcedPredicate)).includeColumnStats();
                    CloseableIterable iterator = tableScan.planFiles();
                    try {
                        immutableList = ImmutableList.copyOf((Iterable)iterator);
                        if (iterator == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (iterator != null) {
                                try {
                                    iterator.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    iterator.close();
                }
                return immutableList;
            });
            Iterable files = () -> IcebergMetadata.lambda$getTableProperties$3((Supplier)lazyFiles);
            Iterable discreteTupleDomain = Iterables.transform(files, fileScan -> {
                Map<Integer, Optional<String>> partitionColumnValueStrings = IcebergUtil.getPartitionKeys(fileScan);
                Map partitionValues = (Map)partitionSourceIds.stream().filter(partitionColumnValueStrings::containsKey).collect(ImmutableMap.toImmutableMap(columns::get, columnId -> {
                    IcebergColumnHandle column = (IcebergColumnHandle)columns.get(columnId);
                    Object prestoValue = IcebergUtil.deserializePartitionValue(column.getType(), ((Optional)partitionColumnValueStrings.get(columnId)).orElse(null), column.getName());
                    return NullableValue.of((io.trino.spi.type.Type)column.getType(), (Object)prestoValue);
                }));
                return TupleDomain.fromFixedValues((Map)partitionValues);
            });
            discretePredicates = new DiscretePredicates((List)columns.values().stream().map(ColumnHandle.class::cast).collect(ImmutableList.toImmutableList()), discreteTupleDomain);
        }
        return new ConnectorTableProperties(enforcedPredicate.transformKeys(ColumnHandle.class::cast), Optional.empty(), Optional.empty(), Optional.ofNullable(discretePredicates), (List)ImmutableList.of());
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        return this.getTableMetadata(session, ((IcebergTableHandle)table).getSchemaTableName());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return this.catalog.listTables(session, schemaName);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        return (Map)IcebergUtil.getColumns(icebergTable.schema(), this.typeManager).stream().collect(ImmutableMap.toImmutableMap(IcebergColumnHandle::getName, Function.identity()));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        IcebergColumnHandle column = (IcebergColumnHandle)columnHandle;
        return ColumnMetadata.builder().setName(column.getName()).setType(column.getType()).setComment(column.getComment()).build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        List tables = prefix.getTable().map(ignored -> Collections.singletonList(prefix.toSchemaTableName())).orElseGet(() -> this.listTables(session, prefix.getSchema()));
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName table : tables) {
            try {
                columns.put((Object)table, (Object)this.getTableMetadata(session, table).getColumns());
            }
            catch (TableNotFoundException tableNotFoundException) {
            }
            catch (UnknownTableTypeException unknownTableTypeException) {
            }
            catch (RuntimeException e) {
                log.warn((Throwable)e, "Failed to access metadata of table %s during column listing for %s", new Object[]{table, prefix});
            }
        }
        return columns.buildOrThrow();
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        this.catalog.createNamespace(session, schemaName, properties, owner);
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        this.catalog.dropNamespace(session, schemaName);
    }

    public void renameSchema(ConnectorSession session, String source, String target) {
        this.catalog.renameNamespace(session, source, target);
    }

    public void setSchemaAuthorization(ConnectorSession session, String schemaName, TrinoPrincipal principal) {
        this.catalog.setNamespacePrincipal(session, schemaName, principal);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        Optional<ConnectorTableLayout> layout = this.getNewTableLayout(session, tableMetadata);
        this.finishCreateTable(session, this.beginCreateTable(session, tableMetadata, layout, RetryMode.NO_RETRIES), (Collection<Slice>)ImmutableList.of(), (Collection<ComputedStatistics>)ImmutableList.of());
    }

    public void setTableComment(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<String> comment) {
        this.catalog.updateTableComment(session, ((IcebergTableHandle)tableHandle).getSchemaTableName(), comment);
    }

    public Optional<ConnectorTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        Schema schema = IcebergUtil.toIcebergSchema(tableMetadata.getColumns());
        PartitionSpec partitionSpec = PartitionFields.parsePartitionFields(schema, IcebergTableProperties.getPartitioning(tableMetadata.getProperties()));
        return this.getWriteLayout(schema, partitionSpec, false);
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout, RetryMode retryMode) {
        Verify.verify((this.transaction == null ? 1 : 0) != 0, (String)"transaction already set", (Object[])new Object[0]);
        this.transaction = IcebergUtil.newCreateTableTransaction(this.catalog, tableMetadata, session);
        return new IcebergWritableTableHandle(tableMetadata.getTable().getSchemaName(), tableMetadata.getTable().getTableName(), SchemaParser.toJson((Schema)this.transaction.table().schema()), PartitionSpecParser.toJson((PartitionSpec)this.transaction.table().spec()), IcebergUtil.getColumns(this.transaction.table().schema(), this.typeManager), this.transaction.table().location(), IcebergUtil.getFileFormat(this.transaction.table()), this.transaction.table().properties(), retryMode);
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return this.finishInsert(session, (IcebergWritableTableHandle)tableHandle, fragments, computedStatistics);
    }

    public Optional<ConnectorTableLayout> getInsertLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        return this.getWriteLayout(icebergTable.schema(), icebergTable.spec(), false);
    }

    private Optional<ConnectorTableLayout> getWriteLayout(Schema tableSchema, PartitionSpec partitionSpec, boolean forceRepartitioning) {
        if (partitionSpec.isUnpartitioned()) {
            return Optional.empty();
        }
        Map columnById = (Map)IcebergUtil.getColumns(tableSchema, this.typeManager).stream().collect(ImmutableMap.toImmutableMap(IcebergColumnHandle::getId, Function.identity()));
        List partitioningColumns = (List)partitionSpec.fields().stream().sorted(Comparator.comparing(PartitionField::sourceId)).map(field -> Objects.requireNonNull((IcebergColumnHandle)columnById.get(field.sourceId()), () -> "Cannot find source column for partitioning field " + field)).distinct().collect(ImmutableList.toImmutableList());
        List partitioningColumnNames = (List)partitioningColumns.stream().map(IcebergColumnHandle::getName).collect(ImmutableList.toImmutableList());
        if (!forceRepartitioning && partitionSpec.fields().stream().allMatch(field -> field.transform().isIdentity())) {
            return Optional.of(new ConnectorTableLayout(partitioningColumnNames));
        }
        IcebergPartitioningHandle partitioningHandle = new IcebergPartitioningHandle(PartitionFields.toPartitionFields(partitionSpec), partitioningColumns);
        return Optional.of(new ConnectorTableLayout((ConnectorPartitioningHandle)partitioningHandle, partitioningColumnNames));
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, RetryMode retryMode) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        Verify.verify((this.transaction == null ? 1 : 0) != 0, (String)"transaction already set", (Object[])new Object[0]);
        this.transaction = icebergTable.newTransaction();
        return new IcebergWritableTableHandle(table.getSchemaName(), table.getTableName(), SchemaParser.toJson((Schema)icebergTable.schema()), PartitionSpecParser.toJson((PartitionSpec)icebergTable.spec()), IcebergUtil.getColumns(icebergTable.schema(), this.typeManager), icebergTable.location(), IcebergUtil.getFileFormat(icebergTable), icebergTable.properties(), retryMode);
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        IcebergWritableTableHandle table = (IcebergWritableTableHandle)insertHandle;
        Table icebergTable = this.transaction.table();
        List commitTasks = (List)fragments.stream().map(slice -> (CommitTaskData)this.commitTaskCodec.fromJson(slice.getBytes())).collect(ImmutableList.toImmutableList());
        Type[] partitionColumnTypes = (Type[])icebergTable.spec().fields().stream().map(field -> field.transform().getResultType(icebergTable.schema().findType(field.sourceId()))).toArray(Type[]::new);
        AppendFiles appendFiles = this.transaction.newAppend();
        ImmutableSet.Builder writtenFiles = ImmutableSet.builder();
        for (CommitTaskData task : commitTasks) {
            DataFiles.Builder builder = DataFiles.builder((PartitionSpec)icebergTable.spec()).withPath(task.getPath()).withFileSizeInBytes(task.getFileSizeInBytes()).withFormat(table.getFileFormat().toIceberg()).withMetrics(task.getMetrics().metrics());
            if (!icebergTable.spec().fields().isEmpty()) {
                String partitionDataJson = task.getPartitionDataJson().orElseThrow(() -> new VerifyException("No partition data for partitioned table"));
                builder.withPartition((StructLike)PartitionData.fromJson(partitionDataJson, partitionColumnTypes));
            }
            appendFiles.appendFile(builder.build());
            writtenFiles.add((Object)task.getPath());
        }
        if (table.getRetryMode() != RetryMode.NO_RETRIES) {
            this.cleanExtraOutputFiles(session, (Set<String>)writtenFiles.build());
        }
        appendFiles.commit();
        this.transaction.commitTransaction();
        this.transaction = null;
        return Optional.of(new HiveWrittenPartitions((List)commitTasks.stream().map(CommitTaskData::getPath).collect(ImmutableList.toImmutableList())));
    }

    private void cleanExtraOutputFiles(HdfsEnvironment.HdfsContext hdfsContext, String queryId, String location, Set<String> filesToKeep) {
        ArrayDeque<String> filesToDelete = new ArrayDeque<String>();
        try {
            log.debug("Deleting failed attempt files from %s for query %s", new Object[]{location, queryId});
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(hdfsContext, new Path(location));
            if (!fileSystem.exists(new Path(location))) {
                return;
            }
            RemoteIterator iterator = fileSystem.listFiles(new Path(location), false);
            while (iterator.hasNext()) {
                Path file = ((LocatedFileStatus)iterator.next()).getPath();
                if (!this.isFileCreatedByQuery(file.getName(), queryId) || filesToKeep.contains(location + "/" + file.getName())) continue;
                filesToDelete.add(file.getName());
            }
            if (filesToDelete.isEmpty()) {
                return;
            }
            log.info("Found %s files to delete and %s to retain in location %s for query %s", new Object[]{filesToDelete.size(), filesToKeep.size(), location, queryId});
            ImmutableList.Builder deletedFilesBuilder = ImmutableList.builder();
            Iterator filesToDeleteIterator = filesToDelete.iterator();
            while (filesToDeleteIterator.hasNext()) {
                String fileName = (String)filesToDeleteIterator.next();
                log.debug("Deleting failed attempt file %s/%s for query %s", new Object[]{location, fileName, queryId});
                fileSystem.delete(new Path(location, fileName), false);
                deletedFilesBuilder.add((Object)fileName);
                filesToDeleteIterator.remove();
            }
            ImmutableList deletedFiles = deletedFilesBuilder.build();
            if (!deletedFiles.isEmpty()) {
                log.info("Deleted failed attempt files %s from %s for query %s", new Object[]{deletedFiles, location, queryId});
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, String.format("Could not clean up extraneous output files; remaining files: %s", filesToDelete), (Throwable)e);
        }
    }

    private boolean isFileCreatedByQuery(String fileName, String queryId) {
        Verify.verify((!queryId.contains("-") ? 1 : 0) != 0, (String)"queryId(%s) should not contain hyphens", (Object)queryId);
        return fileName.startsWith(queryId + "-");
    }

    private static Set<String> getOutputFilesLocations(Set<String> writtenFiles) {
        return (Set)writtenFiles.stream().map(IcebergMetadata::getLocation).collect(ImmutableSet.toImmutableSet());
    }

    private static String getLocation(String path) {
        Matcher matcher = PATH_PATTERN.matcher(path);
        Verify.verify((boolean)matcher.matches(), (String)"path %s does not match pattern", (Object)path);
        return matcher.group(1);
    }

    public ColumnHandle getDeleteRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return new IcebergColumnHandle(ColumnIdentity.primitiveColumnIdentity(0, "$row_id"), (io.trino.spi.type.Type)BigintType.BIGINT, (List<Integer>)ImmutableList.of(), (io.trino.spi.type.Type)BigintType.BIGINT, Optional.empty());
    }

    public Optional<ConnectorTableExecuteHandle> getTableHandleForExecute(ConnectorSession session, ConnectorTableHandle connectorTableHandle, String procedureName, Map<String, Object> executeProperties, RetryMode retryMode) {
        IcebergTableProcedureId procedureId;
        IcebergTableHandle tableHandle = (IcebergTableHandle)connectorTableHandle;
        try {
            procedureId = IcebergTableProcedureId.valueOf(procedureName);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown procedure '" + procedureName + "'");
        }
        switch (procedureId) {
            case OPTIMIZE: {
                return this.getTableHandleForOptimize(session, tableHandle, executeProperties, retryMode);
            }
        }
        throw new IllegalArgumentException("Unknown procedure: " + procedureId);
    }

    private Optional<ConnectorTableExecuteHandle> getTableHandleForOptimize(ConnectorSession session, IcebergTableHandle tableHandle, Map<String, Object> executeProperties, RetryMode retryMode) {
        DataSize maxScannedFileSize = (DataSize)executeProperties.get("file_size_threshold");
        Table icebergTable = this.catalog.loadTable(session, tableHandle.getSchemaTableName());
        return Optional.of(new IcebergTableExecuteHandle(tableHandle.getSchemaTableName(), IcebergTableProcedureId.OPTIMIZE, new IcebergOptimizeHandle(SchemaParser.toJson((Schema)icebergTable.schema()), PartitionSpecParser.toJson((PartitionSpec)icebergTable.spec()), IcebergUtil.getColumns(icebergTable.schema(), this.typeManager), IcebergUtil.getFileFormat(icebergTable), icebergTable.properties(), maxScannedFileSize, retryMode != RetryMode.NO_RETRIES), icebergTable.location()));
    }

    public Optional<ConnectorTableLayout> getLayoutForTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle) {
        IcebergTableExecuteHandle executeHandle = (IcebergTableExecuteHandle)tableExecuteHandle;
        switch (executeHandle.getProcedureId()) {
            case OPTIMIZE: {
                return this.getLayoutForOptimize(session, executeHandle);
            }
        }
        throw new IllegalArgumentException("Unknown procedure '" + executeHandle.getProcedureId() + "'");
    }

    private Optional<ConnectorTableLayout> getLayoutForOptimize(ConnectorSession session, IcebergTableExecuteHandle executeHandle) {
        Table icebergTable = this.catalog.loadTable(session, executeHandle.getSchemaTableName());
        return this.getWriteLayout(icebergTable.schema(), icebergTable.spec(), true);
    }

    public BeginTableExecuteResult<ConnectorTableExecuteHandle, ConnectorTableHandle> beginTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, ConnectorTableHandle updatedSourceTableHandle) {
        IcebergTableExecuteHandle executeHandle = (IcebergTableExecuteHandle)tableExecuteHandle;
        IcebergTableHandle table = (IcebergTableHandle)updatedSourceTableHandle;
        switch (executeHandle.getProcedureId()) {
            case OPTIMIZE: {
                return this.beginOptimize(session, executeHandle, table);
            }
        }
        throw new IllegalArgumentException("Unknown procedure '" + executeHandle.getProcedureId() + "'");
    }

    private BeginTableExecuteResult<ConnectorTableExecuteHandle, ConnectorTableHandle> beginOptimize(ConnectorSession session, IcebergTableExecuteHandle executeHandle, IcebergTableHandle table) {
        IcebergOptimizeHandle optimizeHandle = (IcebergOptimizeHandle)executeHandle.getProcedureHandle();
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        Verify.verify((this.transaction == null ? 1 : 0) != 0, (String)"transaction already set", (Object[])new Object[0]);
        this.transaction = icebergTable.newTransaction();
        return new BeginTableExecuteResult((Object)executeHandle, (Object)table.forOptimize(true, optimizeHandle.getMaxScannedFileSize()));
    }

    public void finishTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, Collection<Slice> fragments, List<Object> splitSourceInfo) {
        IcebergTableExecuteHandle executeHandle = (IcebergTableExecuteHandle)tableExecuteHandle;
        switch (executeHandle.getProcedureId()) {
            case OPTIMIZE: {
                this.finishOptimize(session, executeHandle, fragments, splitSourceInfo);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown procedure '" + executeHandle.getProcedureId() + "'");
    }

    private void finishOptimize(ConnectorSession session, IcebergTableExecuteHandle executeHandle, Collection<Slice> fragments, List<Object> splitSourceInfo) {
        IcebergOptimizeHandle optimizeHandle = (IcebergOptimizeHandle)executeHandle.getProcedureHandle();
        Table icebergTable = this.transaction.table();
        Set scannedFiles = (Set)splitSourceInfo.stream().map(DataFile.class::cast).collect(ImmutableSet.toImmutableSet());
        List commitTasks = (List)fragments.stream().map(slice -> (CommitTaskData)this.commitTaskCodec.fromJson(slice.getBytes())).collect(ImmutableList.toImmutableList());
        Type[] partitionColumnTypes = (Type[])icebergTable.spec().fields().stream().map(field -> field.transform().getResultType(icebergTable.schema().findType(field.sourceId()))).toArray(Type[]::new);
        HashSet<DataFile> newFiles = new HashSet<DataFile>();
        for (CommitTaskData task : commitTasks) {
            DataFiles.Builder builder = DataFiles.builder((PartitionSpec)icebergTable.spec()).withPath(task.getPath()).withFileSizeInBytes(task.getFileSizeInBytes()).withFormat(optimizeHandle.getFileFormat().toIceberg()).withMetrics(task.getMetrics().metrics());
            if (!icebergTable.spec().fields().isEmpty()) {
                String partitionDataJson = task.getPartitionDataJson().orElseThrow(() -> new VerifyException("No partition data for partitioned table"));
                builder.withPartition((StructLike)PartitionData.fromJson(partitionDataJson, partitionColumnTypes));
            }
            newFiles.add(builder.build());
        }
        if (scannedFiles.isEmpty() && newFiles.isEmpty()) {
            this.transaction = null;
            return;
        }
        if (optimizeHandle.isRetriesEnabled()) {
            this.cleanExtraOutputFiles(session, (Set)newFiles.stream().map(dataFile -> dataFile.path().toString()).collect(ImmutableSet.toImmutableSet()));
        }
        RewriteFiles rewriteFiles = this.transaction.newRewrite();
        rewriteFiles.rewriteFiles(scannedFiles, newFiles);
        rewriteFiles.commit();
        this.transaction.commitTransaction();
        this.transaction = null;
    }

    public Optional<Object> getInfo(ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        return Optional.of(new IcebergInputInfo(table.getSnapshotId()));
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        this.catalog.dropTable(session, ((IcebergTableHandle)tableHandle).getSchemaTableName());
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTable) {
        this.catalog.renameTable(session, ((IcebergTableHandle)tableHandle).getSchemaTableName(), newTable);
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        Table icebergTable = this.catalog.loadTable(session, ((IcebergTableHandle)tableHandle).getSchemaTableName());
        icebergTable.updateSchema().addColumn(column.getName(), TypeConverter.toIcebergType(column.getType()), column.getComment()).commit();
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        IcebergColumnHandle handle = (IcebergColumnHandle)column;
        Table icebergTable = this.catalog.loadTable(session, ((IcebergTableHandle)tableHandle).getSchemaTableName());
        icebergTable.updateSchema().deleteColumn(handle.getName()).commit();
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        IcebergColumnHandle columnHandle = (IcebergColumnHandle)source;
        Table icebergTable = this.catalog.loadTable(session, ((IcebergTableHandle)tableHandle).getSchemaTableName());
        icebergTable.updateSchema().renameColumn(columnHandle.getName(), target).commit();
    }

    private ConnectorTableMetadata getTableMetadata(ConnectorSession session, SchemaTableName table) {
        Table icebergTable = this.catalog.loadTable(session, table);
        List<ColumnMetadata> columns = this.getColumnMetadatas(icebergTable);
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.put((Object)"format", (Object)IcebergUtil.getFileFormat(icebergTable));
        if (!icebergTable.spec().fields().isEmpty()) {
            properties.put((Object)"partitioning", PartitionFields.toPartitionFields(icebergTable.spec()));
        }
        if (!icebergTable.location().isEmpty()) {
            properties.put((Object)"location", (Object)icebergTable.location());
        }
        return new ConnectorTableMetadata(table, columns, (Map)properties.buildOrThrow(), IcebergUtil.getTableComment(icebergTable));
    }

    private List<ColumnMetadata> getColumnMetadatas(Table table) {
        return (List)table.schema().columns().stream().map(column -> ColumnMetadata.builder().setName(column.name()).setType(TypeConverter.toTrinoType(column.type(), this.typeManager)).setNullable(column.isOptional()).setComment(Optional.ofNullable(column.doc())).build()).collect(ImmutableList.toImmutableList());
    }

    public Optional<ConnectorTableHandle> applyDelete(ConnectorSession session, ConnectorTableHandle handle) {
        return Optional.of(handle);
    }

    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector only supports delete where one or more identity-transformed partitions are deleted entirely");
    }

    public void createView(ConnectorSession session, SchemaTableName viewName, ConnectorViewDefinition definition, boolean replace) {
        this.catalog.createView(session, viewName, definition, replace);
    }

    public void renameView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        this.catalog.renameView(session, source, target);
    }

    public void setViewAuthorization(ConnectorSession session, SchemaTableName viewName, TrinoPrincipal principal) {
        this.catalog.setViewPrincipal(session, viewName, principal);
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        this.catalog.dropView(session, viewName);
    }

    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> schemaName) {
        return this.catalog.listViews(session, schemaName);
    }

    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> schemaName) {
        return this.catalog.getViews(session, schemaName);
    }

    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        return this.catalog.getView(session, viewName);
    }

    public OptionalLong executeDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.catalog.loadTable(session, handle.getSchemaTableName());
        icebergTable.newDelete().deleteFromRowFilter(ExpressionConverter.toIcebergExpression(handle.getEnforcedPredicate())).commit();
        return OptionalLong.empty();
    }

    public void rollback() {
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle handle, Constraint constraint) {
        IcebergTableHandle table = (IcebergTableHandle)handle;
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        Set<Integer> partitionSourceIds = IcebergMetadata.identityPartitionColumnsInAllSpecs(icebergTable);
        BiPredicate<IcebergColumnHandle, Domain> isIdentityPartition = (column, domain) -> partitionSourceIds.contains(column.getId());
        TupleDomain newEnforcedConstraint = constraint.getSummary().transformKeys(IcebergColumnHandle.class::cast).filter(isIdentityPartition).intersect(table.getEnforcedPredicate());
        TupleDomain remainingConstraint = constraint.getSummary().transformKeys(IcebergColumnHandle.class::cast).filter(isIdentityPartition.negate());
        TupleDomain newUnenforcedConstraint = remainingConstraint.filter((columnHandle, predicate) -> !HiveUtil.isStructuralType((io.trino.spi.type.Type)columnHandle.getType())).intersect(table.getUnenforcedPredicate());
        if (newEnforcedConstraint.equals(table.getEnforcedPredicate()) && newUnenforcedConstraint.equals(table.getUnenforcedPredicate())) {
            return Optional.empty();
        }
        return Optional.of(new ConstraintApplicationResult((Object)new IcebergTableHandle(table.getSchemaName(), table.getTableName(), table.getTableType(), table.getSnapshotId(), (TupleDomain<IcebergColumnHandle>)newUnenforcedConstraint, (TupleDomain<IcebergColumnHandle>)newEnforcedConstraint, table.getProjectedColumns(), table.getNameMappingJson()), remainingConstraint.transformKeys(ColumnHandle.class::cast), false));
    }

    private static Set<Integer> identityPartitionColumnsInAllSpecs(Table table) {
        return (Set)table.spec().fields().stream().filter(field -> field.transform().isIdentity()).filter(field -> table.specs().values().stream().allMatch(spec -> spec.fields().contains(field))).map(PartitionField::sourceId).collect(ImmutableSet.toImmutableSet());
    }

    public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle handle, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        if (!IcebergSessionProperties.isProjectionPushdownEnabled(session)) {
            return Optional.empty();
        }
        Set projectedExpressions = (Set)projections.stream().flatMap(expression -> HiveApplyProjectionUtil.extractSupportedProjectedColumns((ConnectorExpression)expression).stream()).collect(ImmutableSet.toImmutableSet());
        Map columnProjections = (Map)projectedExpressions.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), HiveApplyProjectionUtil::createProjectedColumnRepresentation));
        IcebergTableHandle icebergTableHandle = (IcebergTableHandle)handle;
        if (columnProjections.values().stream().allMatch(HiveApplyProjectionUtil.ProjectedColumnRepresentation::isVariable)) {
            Set projectedColumns = (Set)assignments.values().stream().map(IcebergColumnHandle.class::cast).collect(ImmutableSet.toImmutableSet());
            if (icebergTableHandle.getProjectedColumns().equals(projectedColumns)) {
                return Optional.empty();
            }
            List assignmentsList = (List)assignments.entrySet().stream().map(assignment -> new Assignment((String)assignment.getKey(), (ColumnHandle)assignment.getValue(), ((IcebergColumnHandle)assignment.getValue()).getType())).collect(ImmutableList.toImmutableList());
            return Optional.of(new ProjectionApplicationResult((Object)icebergTableHandle.withProjectedColumns(projectedColumns), projections, assignmentsList, false));
        }
        HashMap<String, Assignment> newAssignments = new HashMap<String, Assignment>();
        ImmutableMap.Builder newVariablesBuilder = ImmutableMap.builder();
        ImmutableSet.Builder projectedColumnsBuilder = ImmutableSet.builder();
        for (Map.Entry entry : columnProjections.entrySet()) {
            ConnectorExpression expression2 = (ConnectorExpression)entry.getKey();
            HiveApplyProjectionUtil.ProjectedColumnRepresentation projectedColumn = (HiveApplyProjectionUtil.ProjectedColumnRepresentation)entry.getValue();
            IcebergColumnHandle baseColumnHandle = (IcebergColumnHandle)assignments.get(projectedColumn.getVariable().getName());
            IcebergColumnHandle projectedColumnHandle = IcebergMetadata.createProjectedColumnHandle(baseColumnHandle, projectedColumn.getDereferenceIndices(), expression2.getType());
            String projectedColumnName = projectedColumnHandle.getQualifiedName();
            Variable projectedColumnVariable = new Variable(projectedColumnName, expression2.getType());
            Assignment newAssignment = new Assignment(projectedColumnName, (ColumnHandle)projectedColumnHandle, expression2.getType());
            newAssignments.putIfAbsent(projectedColumnName, newAssignment);
            newVariablesBuilder.put((Object)expression2, (Object)projectedColumnVariable);
            projectedColumnsBuilder.add((Object)projectedColumnHandle);
        }
        ImmutableMap newVariables = newVariablesBuilder.buildOrThrow();
        List newProjections = (List)projections.stream().map(arg_0 -> IcebergMetadata.lambda$applyProjection$28((Map)newVariables, arg_0)).collect(ImmutableList.toImmutableList());
        List outputAssignments = (List)newAssignments.values().stream().collect(ImmutableList.toImmutableList());
        return Optional.of(new ProjectionApplicationResult((Object)icebergTableHandle.withProjectedColumns((Set<IcebergColumnHandle>)projectedColumnsBuilder.build()), newProjections, outputAssignments, false));
    }

    private static IcebergColumnHandle createProjectedColumnHandle(IcebergColumnHandle column, List<Integer> indices, io.trino.spi.type.Type projectedColumnType) {
        if (indices.isEmpty()) {
            return column;
        }
        ImmutableList.Builder fullPath = ImmutableList.builder();
        fullPath.addAll(column.getPath());
        ColumnIdentity projectedColumnIdentity = column.getColumnIdentity();
        for (int index : indices) {
            projectedColumnIdentity = projectedColumnIdentity.getChildren().get(index);
            fullPath.add((Object)projectedColumnIdentity.getId());
        }
        return new IcebergColumnHandle(column.getBaseColumnIdentity(), column.getBaseType(), (List<Integer>)fullPath.build(), projectedColumnType, Optional.empty());
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint constraint) {
        if (!IcebergSessionProperties.isStatisticsEnabled(session)) {
            return TableStatistics.empty();
        }
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.catalog.loadTable(session, handle.getSchemaTableName());
        return TableStatisticsMaker.getTableStatistics(this.typeManager, constraint, handle, icebergTable);
    }

    public void setTableAuthorization(ConnectorSession session, SchemaTableName tableName, TrinoPrincipal principal) {
        this.catalog.setTablePrincipal(session, tableName, principal);
    }

    private Optional<Long> getSnapshotId(Table table, Optional<Long> snapshotId) {
        return snapshotId.map(id -> this.snapshotIds.computeIfAbsent(table.name() + "@" + id, ignored -> IcebergUtil.resolveSnapshotId(table, id))).or(() -> Optional.ofNullable(table.currentSnapshot()).map(Snapshot::snapshotId));
    }

    Table getIcebergTable(ConnectorSession session, SchemaTableName schemaTableName) {
        return this.catalog.loadTable(session, schemaTableName);
    }

    public void createMaterializedView(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, boolean replace, boolean ignoreExisting) {
        this.catalog.createMaterializedView(session, viewName, definition, replace, ignoreExisting);
    }

    public void dropMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        this.catalog.dropMaterializedView(session, viewName);
    }

    public boolean delegateMaterializedViewRefreshToConnector(ConnectorSession session, SchemaTableName viewName) {
        return false;
    }

    public ConnectorInsertTableHandle beginRefreshMaterializedView(ConnectorSession session, ConnectorTableHandle tableHandle, List<ConnectorTableHandle> sourceTableHandles, RetryMode retryMode) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        Verify.verify((this.transaction == null ? 1 : 0) != 0, (String)"transaction already set", (Object[])new Object[0]);
        this.transaction = icebergTable.newTransaction();
        return new IcebergWritableTableHandle(table.getSchemaName(), table.getTableName(), SchemaParser.toJson((Schema)icebergTable.schema()), PartitionSpecParser.toJson((PartitionSpec)icebergTable.spec()), IcebergUtil.getColumns(icebergTable.schema(), this.typeManager), icebergTable.location(), IcebergUtil.getFileFormat(icebergTable), icebergTable.properties(), retryMode);
    }

    public Optional<ConnectorOutputMetadata> finishRefreshMaterializedView(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics, List<ConnectorTableHandle> sourceTableHandles) {
        this.executeDelete(session, tableHandle);
        IcebergWritableTableHandle table = (IcebergWritableTableHandle)insertHandle;
        Table icebergTable = this.transaction.table();
        List commitTasks = (List)fragments.stream().map(slice -> (CommitTaskData)this.commitTaskCodec.fromJson(slice.getBytes())).collect(ImmutableList.toImmutableList());
        Type[] partitionColumnTypes = (Type[])icebergTable.spec().fields().stream().map(field -> field.transform().getResultType(icebergTable.schema().findType(field.sourceId()))).toArray(Type[]::new);
        AppendFiles appendFiles = this.transaction.newFastAppend();
        ImmutableSet.Builder writtenFiles = ImmutableSet.builder();
        for (CommitTaskData task : commitTasks) {
            DataFiles.Builder builder = DataFiles.builder((PartitionSpec)icebergTable.spec()).withPath(task.getPath()).withFileSizeInBytes(task.getFileSizeInBytes()).withFormat(table.getFileFormat().toIceberg()).withMetrics(task.getMetrics().metrics());
            if (!icebergTable.spec().fields().isEmpty()) {
                String partitionDataJson = task.getPartitionDataJson().orElseThrow(() -> new VerifyException("No partition data for partitioned table"));
                builder.withPartition((StructLike)PartitionData.fromJson(partitionDataJson, partitionColumnTypes));
            }
            appendFiles.appendFile(builder.build());
            writtenFiles.add((Object)task.getPath());
        }
        String dependencies = sourceTableHandles.stream().map(handle -> (IcebergTableHandle)handle).filter(handle -> handle.getSnapshotId().isPresent()).map(handle -> handle.getSchemaTableName() + "=" + handle.getSnapshotId().get()).distinct().collect(Collectors.joining(","));
        if (table.getRetryMode() != RetryMode.NO_RETRIES) {
            this.cleanExtraOutputFiles(session, (Set<String>)writtenFiles.build());
        }
        appendFiles.set("dependsOnTables", dependencies);
        appendFiles.commit();
        this.transaction.commitTransaction();
        this.transaction = null;
        return Optional.of(new HiveWrittenPartitions((List)commitTasks.stream().map(CommitTaskData::getPath).collect(ImmutableList.toImmutableList())));
    }

    private void cleanExtraOutputFiles(ConnectorSession session, Set<String> writtenFiles) {
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session);
        Set<String> locations = IcebergMetadata.getOutputFilesLocations(writtenFiles);
        for (String location : locations) {
            this.cleanExtraOutputFiles(hdfsContext, session.getQueryId(), location, writtenFiles);
        }
    }

    public List<SchemaTableName> listMaterializedViews(ConnectorSession session, Optional<String> schemaName) {
        return this.catalog.listMaterializedViews(session, schemaName);
    }

    public Map<SchemaTableName, ConnectorMaterializedViewDefinition> getMaterializedViews(ConnectorSession session, Optional<String> schemaName) {
        HashMap<SchemaTableName, ConnectorMaterializedViewDefinition> materializedViews = new HashMap<SchemaTableName, ConnectorMaterializedViewDefinition>();
        for (SchemaTableName name : this.listMaterializedViews(session, schemaName)) {
            try {
                this.getMaterializedView(session, name).ifPresent(view -> materializedViews.put(name, (ConnectorMaterializedViewDefinition)view));
            }
            catch (RuntimeException e) {
                log.warn((Throwable)e, "Failed to access metadata of materialized view %s during listing", new Object[]{name});
            }
        }
        return materializedViews;
    }

    public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        return this.catalog.getMaterializedView(session, viewName);
    }

    public void renameMaterializedView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        if (!source.getSchemaName().equals(target.getSchemaName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Materialized View rename across schemas is not supported");
        }
        this.catalog.renameMaterializedView(session, source, target);
    }

    public Optional<TableToken> getTableToken(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        return Optional.ofNullable(icebergTable.currentSnapshot()).map(snapshot -> new TableToken(snapshot.snapshotId()));
    }

    public boolean isTableCurrent(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<TableToken> tableToken) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        Optional<TableToken> currentToken = this.getTableToken(session, handle);
        if (tableToken.isEmpty() || currentToken.isEmpty()) {
            return false;
        }
        return tableToken.get().getSnapshotId() == currentToken.get().getSnapshotId();
    }

    public MaterializedViewFreshness getMaterializedViewFreshness(ConnectorSession session, SchemaTableName materializedViewName) {
        Map<String, Optional<TableToken>> refreshStateMap = this.getMaterializedViewToken(session, materializedViewName);
        if (refreshStateMap.isEmpty()) {
            return new MaterializedViewFreshness(false);
        }
        for (Map.Entry<String, Optional<TableToken>> entry : refreshStateMap.entrySet()) {
            List strings = Splitter.on((String)".").splitToList((CharSequence)entry.getKey());
            if (strings.size() == 3) {
                strings = strings.subList(1, 3);
            } else if (strings.size() != 2) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("Invalid table name in '%s' property: %s'", "dependsOnTables", strings));
            }
            String schema = (String)strings.get(0);
            String name = (String)strings.get(1);
            SchemaTableName schemaTableName = new SchemaTableName(schema, name);
            IcebergTableHandle tableHandle = this.getTableHandle(session, schemaTableName);
            if (tableHandle == null) {
                throw new MaterializedViewNotFoundException(materializedViewName);
            }
            if (this.isTableCurrent(session, tableHandle, entry.getValue())) continue;
            return new MaterializedViewFreshness(false);
        }
        return new MaterializedViewFreshness(true);
    }

    public void setColumnComment(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column, Optional<String> comment) {
        this.catalog.updateColumnComment(session, ((IcebergTableHandle)tableHandle).getSchemaTableName(), ((IcebergColumnHandle)column).getColumnIdentity(), comment);
    }

    private Map<String, Optional<TableToken>> getMaterializedViewToken(ConnectorSession session, SchemaTableName name) {
        HashMap<String, Optional<TableToken>> viewToken = new HashMap<String, Optional<TableToken>>();
        Optional<ConnectorMaterializedViewDefinition> materializedViewDefinition = this.getMaterializedView(session, name);
        if (materializedViewDefinition.isEmpty()) {
            return viewToken;
        }
        SchemaTableName storageTableName = materializedViewDefinition.get().getStorageTable().map(CatalogSchemaTableName::getSchemaTableName).orElseThrow(() -> new IllegalStateException("Storage table missing in definition of materialized view " + name));
        Table icebergTable = this.catalog.loadTable(session, storageTableName);
        String dependsOnTables = icebergTable.currentSnapshot().summary().getOrDefault("dependsOnTables", "");
        if (!dependsOnTables.isEmpty()) {
            Map tableToSnapshotIdMap = Splitter.on((char)',').withKeyValueSeparator('=').split((CharSequence)dependsOnTables);
            for (Map.Entry entry : tableToSnapshotIdMap.entrySet()) {
                viewToken.put((String)entry.getKey(), Optional.of(new TableToken(Long.parseLong((String)entry.getValue()))));
            }
        }
        return viewToken;
    }

    private static /* synthetic */ ConnectorExpression lambda$applyProjection$28(Map newVariables, ConnectorExpression expression) {
        return HiveApplyProjectionUtil.replaceWithNewVariables((ConnectorExpression)expression, (Map)newVariables);
    }

    private static /* synthetic */ Iterator lambda$getTableProperties$3(Supplier lazyFiles) {
        return ((List)lazyFiles.get()).iterator();
    }

    private static class TableToken {
        private long snapshotId;

        public TableToken(long snapshotId) {
            this.snapshotId = snapshotId;
        }

        public long getSnapshotId() {
            return this.snapshotId;
        }
    }
}

