/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.airlift.json.JsonCodec;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.iceberg.CommitTaskData;
import io.trino.plugin.iceberg.IcebergMetadata;
import io.trino.plugin.iceberg.TrinoCatalogFactory;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.TypeManager;
import java.util.Objects;
import javax.inject.Inject;

public class IcebergMetadataFactory {
    private final TypeManager typeManager;
    private final JsonCodec<CommitTaskData> commitTaskCodec;
    private final TrinoCatalogFactory catalogFactory;
    private final HdfsEnvironment hdfsEnvironment;

    @Inject
    public IcebergMetadataFactory(TypeManager typeManager, JsonCodec<CommitTaskData> commitTaskCodec, TrinoCatalogFactory catalogFactory, HdfsEnvironment hdfsEnvironment) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.commitTaskCodec = Objects.requireNonNull(commitTaskCodec, "commitTaskCodec is null");
        this.catalogFactory = Objects.requireNonNull(catalogFactory, "catalogFactory is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
    }

    public IcebergMetadata create(ConnectorIdentity identity) {
        return new IcebergMetadata(this.typeManager, this.commitTaskCodec, this.catalogFactory.create(identity), this.hdfsEnvironment);
    }
}

