/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.iceberg.IcebergBucketFunction;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergPartitioningHandle;
import io.trino.plugin.iceberg.PartitionFields;
import io.trino.plugin.iceberg.TypeConverter;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.connector.ConnectorBucketNodeMap;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import javax.inject.Inject;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class IcebergNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final TypeOperators typeOperators;
    private final NodeManager nodeManager;

    @Inject
    public IcebergNodePartitioningProvider(TypeManager typeManager, NodeManager nodeManager) {
        this.typeOperators = Objects.requireNonNull(typeManager, "typeManager is null").getTypeOperators();
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
    }

    public ConnectorBucketNodeMap getBucketNodeMap(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return ConnectorBucketNodeMap.createBucketNodeMap((int)this.nodeManager.getRequiredWorkerNodes().size());
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return split -> {
            throw new UnsupportedOperationException();
        };
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<io.trino.spi.type.Type> partitionChannelTypes, int bucketCount) {
        IcebergPartitioningHandle handle = (IcebergPartitioningHandle)partitioningHandle;
        Schema schema = IcebergNodePartitioningProvider.toIcebergSchema(handle.getPartitioningColumns());
        return new IcebergBucketFunction(this.typeOperators, PartitionFields.parsePartitionFields(schema, handle.getPartitioning()), handle.getPartitioningColumns(), bucketCount);
    }

    private static Schema toIcebergSchema(List<IcebergColumnHandle> columns) {
        List icebergColumns = (List)columns.stream().map(column -> {
            Type type = TypeConverter.toIcebergType(column.getType());
            return Types.NestedField.of((int)column.getId(), (boolean)true, (String)column.getName(), (Type)type);
        }).collect(ImmutableList.toImmutableList());
        Types.StructType icebergSchema = Types.StructType.of((List)icebergColumns);
        return new Schema(icebergSchema.asStructType().fields());
    }
}

