/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.airlift.json.JsonCodec;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.iceberg.CommitTaskData;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergFileWriterFactory;
import io.trino.plugin.iceberg.IcebergPageSink;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.IcebergWritableTableHandle;
import io.trino.plugin.iceberg.procedure.IcebergOptimizeHandle;
import io.trino.plugin.iceberg.procedure.IcebergTableExecuteHandle;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SchemaTableName;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.io.LocationProvider;

public class IcebergPageSinkProvider
implements ConnectorPageSinkProvider {
    private final HdfsEnvironment hdfsEnvironment;
    private final JsonCodec<CommitTaskData> jsonCodec;
    private final IcebergFileWriterFactory fileWriterFactory;
    private final PageIndexerFactory pageIndexerFactory;
    private final int maxOpenPartitions;

    @Inject
    public IcebergPageSinkProvider(HdfsEnvironment hdfsEnvironment, JsonCodec<CommitTaskData> jsonCodec, IcebergFileWriterFactory fileWriterFactory, PageIndexerFactory pageIndexerFactory, IcebergConfig config) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.jsonCodec = Objects.requireNonNull(jsonCodec, "jsonCodec is null");
        this.fileWriterFactory = Objects.requireNonNull(fileWriterFactory, "fileWriterFactory is null");
        this.pageIndexerFactory = Objects.requireNonNull(pageIndexerFactory, "pageIndexerFactory is null");
        Objects.requireNonNull(config, "config is null");
        this.maxOpenPartitions = config.getMaxPartitionsPerWriter();
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle) {
        return this.createPageSink(session, (IcebergWritableTableHandle)outputTableHandle);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle) {
        return this.createPageSink(session, (IcebergWritableTableHandle)insertTableHandle);
    }

    private ConnectorPageSink createPageSink(ConnectorSession session, IcebergWritableTableHandle tableHandle) {
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session);
        Schema schema = SchemaParser.fromJson((String)tableHandle.getSchemaAsJson());
        PartitionSpec partitionSpec = PartitionSpecParser.fromJson((Schema)schema, (String)tableHandle.getPartitionSpecAsJson());
        LocationProvider locationProvider = IcebergUtil.getLocationProvider(new SchemaTableName(tableHandle.getSchemaName(), tableHandle.getTableName()), tableHandle.getOutputPath(), tableHandle.getStorageProperties());
        return new IcebergPageSink(schema, partitionSpec, locationProvider, this.fileWriterFactory, this.pageIndexerFactory, this.hdfsEnvironment, hdfsContext, tableHandle.getInputColumns(), this.jsonCodec, session, tableHandle.getFileFormat(), tableHandle.getStorageProperties(), this.maxOpenPartitions);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle) {
        IcebergTableExecuteHandle executeHandle = (IcebergTableExecuteHandle)tableExecuteHandle;
        switch (executeHandle.getProcedureId()) {
            case OPTIMIZE: {
                HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session);
                IcebergOptimizeHandle optimizeHandle = (IcebergOptimizeHandle)executeHandle.getProcedureHandle();
                Schema schema = SchemaParser.fromJson((String)optimizeHandle.getSchemaAsJson());
                PartitionSpec partitionSpec = PartitionSpecParser.fromJson((Schema)schema, (String)optimizeHandle.getPartitionSpecAsJson());
                LocationProvider locationProvider = IcebergUtil.getLocationProvider(executeHandle.getSchemaTableName(), executeHandle.getTableLocation(), optimizeHandle.getTableStorageProperties());
                return new IcebergPageSink(schema, partitionSpec, locationProvider, this.fileWriterFactory, this.pageIndexerFactory, this.hdfsEnvironment, hdfsContext, optimizeHandle.getTableColumns(), this.jsonCodec, session, optimizeHandle.getFileFormat(), optimizeHandle.getTableStorageProperties(), this.maxOpenPartitions);
            }
        }
        throw new IllegalArgumentException("Unknown procedure: " + executeHandle.getProcedureId());
    }
}

