/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Throwables;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.hive.ReaderProjectionsAdapter;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class IcebergPageSource
implements ConnectorPageSource {
    private final Block[] prefilledBlocks;
    private final int[] delegateIndexes;
    private final ConnectorPageSource delegate;
    private final Optional<ReaderProjectionsAdapter> projectionsAdapter;

    public IcebergPageSource(List<IcebergColumnHandle> columns, Map<Integer, Optional<String>> partitionKeys, ConnectorPageSource delegate, Optional<ReaderProjectionsAdapter> projectionsAdapter) {
        int size = Objects.requireNonNull(columns, "columns is null").size();
        Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.prefilledBlocks = new Block[size];
        this.delegateIndexes = new int[size];
        this.projectionsAdapter = Objects.requireNonNull(projectionsAdapter, "projectionsAdapter is null");
        int outputIndex = 0;
        int delegateIndex = 0;
        for (IcebergColumnHandle column : columns) {
            if (partitionKeys.containsKey(column.getId())) {
                String partitionValue = partitionKeys.get(column.getId()).orElse(null);
                Type type = column.getType();
                Object prefilledValue = IcebergUtil.deserializePartitionValue(type, partitionValue, column.getName());
                this.prefilledBlocks[outputIndex] = Utils.nativeValueToBlock((Type)type, (Object)prefilledValue);
                this.delegateIndexes[outputIndex] = -1;
            } else {
                this.delegateIndexes[outputIndex] = delegateIndex++;
            }
            ++outputIndex;
        }
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public OptionalLong getCompletedPositions() {
        return this.delegate.getCompletedPositions();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.delegate.isFinished();
    }

    public Page getNextPage() {
        try {
            Page dataPage = this.delegate.getNextPage();
            if (this.projectionsAdapter.isPresent()) {
                dataPage = this.projectionsAdapter.get().adaptPage(dataPage);
            }
            if (dataPage == null) {
                return null;
            }
            int batchSize = dataPage.getPositionCount();
            Block[] blocks = new Block[this.prefilledBlocks.length];
            for (int i = 0; i < this.prefilledBlocks.length; ++i) {
                blocks[i] = this.prefilledBlocks[i] != null ? new RunLengthEncodedBlock(this.prefilledBlocks[i], batchSize) : dataPage.getBlock(this.delegateIndexes[i]);
            }
            return new Page(batchSize, blocks);
        }
        catch (RuntimeException e) {
            this.closeWithSuppression(e);
            Throwables.throwIfInstanceOf((Throwable)e, TrinoException.class);
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, (Throwable)e);
        }
    }

    public void close() {
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public long getMemoryUsage() {
        return this.delegate.getMemoryUsage();
    }

    protected void closeWithSuppression(Throwable throwable) {
        Closables.closeAllSuppress((Throwable)throwable, (AutoCloseable[])new AutoCloseable[]{this});
    }
}

