/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.graph.Traverser;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.orc.OrcColumn;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.OrcDataSource;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.OrcPredicate;
import io.trino.orc.OrcReader;
import io.trino.orc.OrcReaderOptions;
import io.trino.orc.OrcRecordReader;
import io.trino.orc.TupleDomainOrcPredicate;
import io.trino.orc.metadata.OrcType;
import io.trino.parquet.ParquetCorruptionException;
import io.trino.parquet.ParquetDataSource;
import io.trino.parquet.ParquetDataSourceId;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.RichColumnDescriptor;
import io.trino.parquet.predicate.Predicate;
import io.trino.parquet.predicate.PredicateUtils;
import io.trino.parquet.reader.MetadataReader;
import io.trino.parquet.reader.ParquetReader;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.ReaderColumns;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.ReaderProjectionsAdapter;
import io.trino.plugin.hive.orc.HdfsOrcDataSource;
import io.trino.plugin.hive.orc.OrcPageSource;
import io.trino.plugin.hive.orc.OrcReaderConfig;
import io.trino.plugin.hive.parquet.HdfsParquetDataSource;
import io.trino.plugin.hive.parquet.ParquetPageSource;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergPageSource;
import io.trino.plugin.iceberg.IcebergParquetColumnIOConverter;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.IcebergSplit;
import io.trino.plugin.iceberg.IcebergTableHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.iceberg.mapping.MappedField;
import org.apache.iceberg.mapping.MappedFields;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.joda.time.DateTimeZone;

public class IcebergPageSourceProvider
implements ConnectorPageSourceProvider {
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats fileFormatDataSourceStats;
    private final OrcReaderOptions orcReaderOptions;
    private final ParquetReaderOptions parquetReaderOptions;
    private final TypeManager typeManager;

    @Inject
    public IcebergPageSourceProvider(HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats fileFormatDataSourceStats, OrcReaderConfig orcReaderConfig, ParquetReaderConfig parquetReaderConfig, TypeManager typeManager) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.fileFormatDataSourceStats = Objects.requireNonNull(fileFormatDataSourceStats, "fileFormatDataSourceStats is null");
        this.orcReaderOptions = Objects.requireNonNull(orcReaderConfig, "orcReaderConfig is null").toOrcReaderOptions();
        this.parquetReaderOptions = Objects.requireNonNull(parquetReaderConfig, "parquetReaderConfig is null").toParquetReaderOptions();
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit connectorSplit, ConnectorTableHandle connectorTable, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        IcebergSplit split = (IcebergSplit)connectorSplit;
        IcebergTableHandle table = (IcebergTableHandle)connectorTable;
        List icebergColumns = (List)columns.stream().map(IcebergColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        Map<Integer, Optional<String>> partitionKeys = split.getPartitionKeys();
        List regularColumns = (List)columns.stream().map(IcebergColumnHandle.class::cast).filter(column -> !partitionKeys.containsKey(column.getId())).collect(ImmutableList.toImmutableList());
        TupleDomain effectivePredicate = table.getUnenforcedPredicate().intersect(dynamicFilter.getCurrentPredicate().transformKeys(IcebergColumnHandle.class::cast)).simplify(1000);
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session);
        ReaderPageSource dataPageSource = this.createDataPageSource(session, hdfsContext, new Path(split.getPath()), split.getStart(), split.getLength(), split.getFileSize(), split.getFileFormat(), regularColumns, (TupleDomain<IcebergColumnHandle>)effectivePredicate, table.getNameMappingJson().map(NameMappingParser::fromJson));
        Optional<ReaderProjectionsAdapter> projectionsAdapter = dataPageSource.getReaderColumns().map(readerColumns -> new ReaderProjectionsAdapter(regularColumns, readerColumns, column -> ((IcebergColumnHandle)column).getType(), IcebergPageSourceProvider::applyProjection));
        return new IcebergPageSource(icebergColumns, partitionKeys, dataPageSource.get(), projectionsAdapter);
    }

    private ReaderPageSource createDataPageSource(ConnectorSession session, HdfsEnvironment.HdfsContext hdfsContext, Path path, long start, long length, long fileSize, IcebergFileFormat fileFormat, List<IcebergColumnHandle> dataColumns, TupleDomain<IcebergColumnHandle> predicate, Optional<NameMapping> nameMapping) {
        if (!IcebergSessionProperties.isUseFileSizeFromMetadata(session)) {
            try {
                FileStatus fileStatus = (FileStatus)this.hdfsEnvironment.doAs(session.getIdentity(), () -> this.hdfsEnvironment.getFileSystem(hdfsContext, path).getFileStatus(path));
                fileSize = fileStatus.getLen();
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, (Throwable)e);
            }
        }
        switch (fileFormat) {
            case ORC: {
                return IcebergPageSourceProvider.createOrcPageSource(this.hdfsEnvironment, session.getIdentity(), this.hdfsEnvironment.getConfiguration(hdfsContext, path), path, start, length, fileSize, dataColumns, predicate, this.orcReaderOptions.withMaxMergeDistance(IcebergSessionProperties.getOrcMaxMergeDistance(session)).withMaxBufferSize(IcebergSessionProperties.getOrcMaxBufferSize(session)).withStreamBufferSize(IcebergSessionProperties.getOrcStreamBufferSize(session)).withTinyStripeThreshold(IcebergSessionProperties.getOrcTinyStripeThreshold(session)).withMaxReadBlockSize(IcebergSessionProperties.getOrcMaxReadBlockSize(session)).withLazyReadSmallRanges(IcebergSessionProperties.getOrcLazyReadSmallRanges(session)).withNestedLazy(IcebergSessionProperties.isOrcNestedLazy(session)).withBloomFiltersEnabled(IcebergSessionProperties.isOrcBloomFiltersEnabled(session)), this.fileFormatDataSourceStats, this.typeManager, nameMapping);
            }
            case PARQUET: {
                return IcebergPageSourceProvider.createParquetPageSource(this.hdfsEnvironment, session.getIdentity(), this.hdfsEnvironment.getConfiguration(hdfsContext, path), path, start, length, fileSize, dataColumns, this.parquetReaderOptions.withMaxReadBlockSize(IcebergSessionProperties.getParquetMaxReadBlockSize(session)), predicate, this.fileFormatDataSourceStats, nameMapping);
            }
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "File format not supported for Iceberg: " + fileFormat);
    }

    private static ReaderPageSource createOrcPageSource(HdfsEnvironment hdfsEnvironment, ConnectorIdentity identity, Configuration configuration, Path path, long start, long length, long fileSize, List<IcebergColumnHandle> columns, TupleDomain<IcebergColumnHandle> effectivePredicate, OrcReaderOptions options, FileFormatDataSourceStats stats, TypeManager typeManager, Optional<NameMapping> nameMapping) {
        HdfsOrcDataSource orcDataSource = null;
        try {
            FileSystem fileSystem = hdfsEnvironment.getFileSystem(identity, path, configuration);
            FSDataInputStream inputStream = (FSDataInputStream)hdfsEnvironment.doAs(identity, () -> fileSystem.open(path));
            orcDataSource = new HdfsOrcDataSource(new OrcDataSourceId(path.toString()), fileSize, options, inputStream, stats);
            OrcReader reader = (OrcReader)OrcReader.createOrcReader((OrcDataSource)orcDataSource, (OrcReaderOptions)options).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, "ORC file is zero length"));
            List fileColumns = reader.getRootColumn().getNestedColumns();
            if (nameMapping.isPresent() && !IcebergPageSourceProvider.hasIds(reader.getRootColumn())) {
                fileColumns = (List)fileColumns.stream().map(orcColumn -> IcebergPageSourceProvider.setMissingFieldIds(orcColumn, (NameMapping)nameMapping.get(), (List<String>)ImmutableList.of((Object)orcColumn.getColumnName()))).collect(ImmutableList.toImmutableList());
            }
            Map<Integer, OrcColumn> fileColumnsByIcebergId = IcebergPageSourceProvider.mapIdsToOrcFileColumns(fileColumns);
            TupleDomainOrcPredicate.TupleDomainOrcPredicateBuilder predicateBuilder = TupleDomainOrcPredicate.builder().setBloomFiltersEnabled(options.isBloomFiltersEnabled());
            Map effectivePredicateDomains = (Map)effectivePredicate.getDomains().orElseThrow(() -> new IllegalArgumentException("Effective predicate is none"));
            Optional<ReaderColumns> columnProjections = IcebergPageSourceProvider.projectColumns(columns);
            Map projectionsByFieldId = columns.stream().collect(Collectors.groupingBy(column -> column.getBaseColumnIdentity().getId(), Collectors.mapping(IcebergColumnHandle::getPath, Collectors.toUnmodifiableList())));
            List<IcebergColumnHandle> readColumns = columnProjections.map(readerColumns -> (List)readerColumns.get().stream().map(IcebergColumnHandle.class::cast).collect(ImmutableList.toImmutableList())).orElse(columns);
            ArrayList<OrcColumn> fileReadColumns = new ArrayList<OrcColumn>(readColumns.size());
            ArrayList<io.trino.spi.type.Type> fileReadTypes = new ArrayList<io.trino.spi.type.Type>(readColumns.size());
            ArrayList<OrcReader.ProjectedLayout> projectedLayouts = new ArrayList<OrcReader.ProjectedLayout>(readColumns.size());
            ArrayList<OrcPageSource.ColumnAdaptation> columnAdaptations = new ArrayList<OrcPageSource.ColumnAdaptation>(readColumns.size());
            for (IcebergColumnHandle column2 : readColumns) {
                Verify.verify((boolean)column2.isBaseColumn(), (String)"Column projections must be based from a root column", (Object[])new Object[0]);
                OrcColumn orcColumn2 = fileColumnsByIcebergId.get(column2.getId());
                if (orcColumn2 != null) {
                    io.trino.spi.type.Type readType = IcebergPageSourceProvider.getOrcReadType(column2.getType(), typeManager);
                    if (column2.getType() == UuidType.UUID && !"UUID".equals(orcColumn2.getAttributes().get("iceberg.binary-type"))) {
                        throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, String.format("Expected ORC column for UUID data to be annotated with %s=UUID: %s", "iceberg.binary-type", orcColumn2));
                    }
                    List<List<Integer>> fieldIdProjections = projectionsByFieldId.get(column2.getId());
                    OrcReader.ProjectedLayout projectedLayout = IcebergOrcProjectedLayout.createProjectedLayout(orcColumn2, fieldIdProjections);
                    int sourceIndex = fileReadColumns.size();
                    columnAdaptations.add(OrcPageSource.ColumnAdaptation.sourceColumn((int)sourceIndex));
                    fileReadColumns.add(orcColumn2);
                    fileReadTypes.add(readType);
                    projectedLayouts.add(projectedLayout);
                    for (Map.Entry domainEntry : effectivePredicateDomains.entrySet()) {
                        IcebergColumnHandle predicateColumn = (IcebergColumnHandle)domainEntry.getKey();
                        OrcColumn predicateOrcColumn = fileColumnsByIcebergId.get(predicateColumn.getId());
                        if (predicateOrcColumn == null || !column2.getColumnIdentity().equals(predicateColumn.getBaseColumnIdentity())) continue;
                        predicateBuilder.addColumn(predicateOrcColumn.getColumnId(), (Domain)domainEntry.getValue());
                    }
                    continue;
                }
                columnAdaptations.add(OrcPageSource.ColumnAdaptation.nullColumn((io.trino.spi.type.Type)column2.getType()));
            }
            AggregatedMemoryContext memoryUsage = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
            OrcDataSourceId orcDataSourceId = orcDataSource.getId();
            OrcRecordReader recordReader = reader.createRecordReader(fileReadColumns, fileReadTypes, projectedLayouts, (OrcPredicate)predicateBuilder.build(), start, length, DateTimeZone.UTC, memoryUsage, 1, exception -> IcebergPageSourceProvider.handleException(orcDataSourceId, exception), (OrcReader.FieldMapperFactory)new IdBasedFieldMapperFactory(readColumns));
            return new ReaderPageSource((ConnectorPageSource)new OrcPageSource(recordReader, columnAdaptations, (OrcDataSource)orcDataSource, Optional.empty(), Optional.empty(), memoryUsage, stats), columnProjections);
        }
        catch (Exception e) {
            if (orcDataSource != null) {
                try {
                    orcDataSource.close();
                }
                catch (IOException inputStream) {
                    // empty catch block
                }
            }
            if (e instanceof TrinoException) {
                throw (TrinoException)e;
            }
            String message = String.format("Error opening Iceberg split %s (offset=%s, length=%s): %s", path, start, length, e.getMessage());
            if (e instanceof BlockMissingException) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_MISSING_DATA, message, (Throwable)e);
            }
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    private static boolean hasIds(OrcColumn column) {
        if (column.getAttributes().containsKey("iceberg.id")) {
            return true;
        }
        return column.getNestedColumns().stream().anyMatch(IcebergPageSourceProvider::hasIds);
    }

    private static OrcColumn setMissingFieldIds(OrcColumn column, NameMapping nameMapping, List<String> qualifiedPath) {
        MappedField mappedField = nameMapping.find(qualifiedPath);
        ImmutableMap.Builder attributes = ImmutableMap.builder().putAll(column.getAttributes());
        if (mappedField != null && mappedField.id() != null) {
            attributes.put((Object)"iceberg.id", (Object)String.valueOf(mappedField.id()));
        }
        return new OrcColumn(column.getPath(), column.getColumnId(), column.getColumnName(), column.getColumnType(), column.getOrcDataSourceId(), (List)column.getNestedColumns().stream().map(nestedColumn -> {
            ImmutableList.Builder nextQualifiedPath = ImmutableList.builder().addAll((Iterable)qualifiedPath);
            if (column.getColumnType().equals((Object)OrcType.OrcTypeKind.LIST)) {
                nextQualifiedPath.add((Object)"element");
            } else {
                nextQualifiedPath.add((Object)nestedColumn.getColumnName());
            }
            return IcebergPageSourceProvider.setMissingFieldIds(nestedColumn, nameMapping, (List<String>)nextQualifiedPath.build());
        }).collect(ImmutableList.toImmutableList()), (Map)attributes.buildOrThrow());
    }

    private static List<Integer> applyProjection(ColumnHandle expectedColumnHandle, ColumnHandle readColumnHandle) {
        IcebergColumnHandle expectedColumn = (IcebergColumnHandle)expectedColumnHandle;
        IcebergColumnHandle readColumn = (IcebergColumnHandle)readColumnHandle;
        Preconditions.checkState((boolean)readColumn.isBaseColumn(), (Object)"Read column path must be a base column");
        ImmutableList.Builder dereferenceChain = ImmutableList.builder();
        ColumnIdentity columnIdentity = readColumn.getColumnIdentity();
        for (Integer fieldId : expectedColumn.getPath()) {
            ColumnIdentity nextChild = columnIdentity.getChildByFieldId(fieldId);
            dereferenceChain.add((Object)columnIdentity.getChildIndexByFieldId(fieldId));
            columnIdentity = nextChild;
        }
        return dereferenceChain.build();
    }

    private static Map<Integer, OrcColumn> mapIdsToOrcFileColumns(List<OrcColumn> columns) {
        ImmutableMap.Builder columnsById = ImmutableMap.builder();
        Traverser.forTree(OrcColumn::getNestedColumns).depthFirstPreOrder(columns).forEach(column -> {
            String fieldId = (String)column.getAttributes().get("iceberg.id");
            if (fieldId != null) {
                columnsById.put((Object)Integer.parseInt(fieldId), column);
            }
        });
        return columnsById.buildOrThrow();
    }

    private static Integer getIcebergFieldId(OrcColumn column) {
        String icebergId = (String)column.getAttributes().get("iceberg.id");
        Verify.verify((icebergId != null ? 1 : 0) != 0, (String)String.format("column %s does not have %s property", column, "iceberg.id"), (Object[])new Object[0]);
        return Integer.valueOf(icebergId);
    }

    private static io.trino.spi.type.Type getOrcReadType(io.trino.spi.type.Type columnType, TypeManager typeManager) {
        if (columnType == UuidType.UUID) {
            return VarbinaryType.VARBINARY;
        }
        if (columnType instanceof ArrayType) {
            return new ArrayType(IcebergPageSourceProvider.getOrcReadType(((ArrayType)columnType).getElementType(), typeManager));
        }
        if (columnType instanceof MapType) {
            MapType mapType = (MapType)columnType;
            io.trino.spi.type.Type keyType = IcebergPageSourceProvider.getOrcReadType(mapType.getKeyType(), typeManager);
            io.trino.spi.type.Type valueType = IcebergPageSourceProvider.getOrcReadType(mapType.getValueType(), typeManager);
            return new MapType(keyType, valueType, typeManager.getTypeOperators());
        }
        if (columnType instanceof RowType) {
            return RowType.from((List)((List)((RowType)columnType).getFields().stream().map(field -> new RowType.Field(field.getName(), IcebergPageSourceProvider.getOrcReadType(field.getType(), typeManager))).collect(ImmutableList.toImmutableList())));
        }
        return columnType;
    }

    private static ReaderPageSource createParquetPageSource(HdfsEnvironment hdfsEnvironment, ConnectorIdentity identity, Configuration configuration, Path path, long start, long length, long fileSize, List<IcebergColumnHandle> regularColumns, ParquetReaderOptions options, TupleDomain<IcebergColumnHandle> effectivePredicate, FileFormatDataSourceStats fileFormatDataSourceStats, Optional<NameMapping> nameMapping) {
        AggregatedMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        HdfsParquetDataSource dataSource = null;
        try {
            FileSystem fileSystem = hdfsEnvironment.getFileSystem(identity, path, configuration);
            FSDataInputStream inputStream = (FSDataInputStream)hdfsEnvironment.doAs(identity, () -> fileSystem.open(path));
            HdfsParquetDataSource theDataSource = dataSource = new HdfsParquetDataSource(new ParquetDataSourceId(path.toString()), fileSize, inputStream, fileFormatDataSourceStats, options);
            ParquetMetadata parquetMetadata = (ParquetMetadata)hdfsEnvironment.doAs(identity, () -> IcebergPageSourceProvider.lambda$createParquetPageSource$15((ParquetDataSource)theDataSource));
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            MessageType fileSchema = fileMetaData.getSchema();
            if (nameMapping.isPresent() && !ParquetSchemaUtil.hasIds((MessageType)fileSchema)) {
                fileSchema = ParquetSchemaUtil.applyNameMapping((MessageType)fileSchema, (NameMapping)IcebergPageSourceProvider.convertToLowercase(nameMapping.get()));
            }
            Map parquetIdToField = (Map)fileSchema.getFields().stream().filter(field -> field.getId() != null).collect(ImmutableMap.toImmutableMap(field -> field.getId().intValue(), Function.identity()));
            Optional<ReaderColumns> columnProjections = IcebergPageSourceProvider.projectColumns(regularColumns);
            List<IcebergColumnHandle> readColumns = columnProjections.map(readerColumns -> (List)readerColumns.get().stream().map(IcebergColumnHandle.class::cast).collect(ImmutableList.toImmutableList())).orElse(regularColumns);
            List parquetFields = readColumns.stream().map(column -> (Type)parquetIdToField.get(column.getId())).collect(Collectors.toList());
            MessageType requestedSchema = new MessageType(fileSchema.getName(), (List)parquetFields.stream().filter(Objects::nonNull).collect(ImmutableList.toImmutableList()));
            Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)requestedSchema);
            TupleDomain<ColumnDescriptor> parquetTupleDomain = IcebergPageSourceProvider.getParquetTupleDomain(descriptorsByPath, effectivePredicate);
            Predicate parquetPredicate = PredicateUtils.buildPredicate((MessageType)requestedSchema, parquetTupleDomain, (Map)descriptorsByPath, (DateTimeZone)DateTimeZone.UTC);
            ArrayList<BlockMetaData> blocks = new ArrayList<BlockMetaData>();
            for (BlockMetaData block : parquetMetadata.getBlocks()) {
                long firstDataPage = ((ColumnChunkMetaData)block.getColumns().get(0)).getFirstDataPageOffset();
                if (start > firstDataPage || firstDataPage >= start + length || !PredicateUtils.predicateMatches((Predicate)parquetPredicate, (BlockMetaData)block, (ParquetDataSource)dataSource, (Map)descriptorsByPath, parquetTupleDomain)) continue;
                blocks.add(block);
            }
            MessageColumnIO messageColumnIO = ParquetTypeUtils.getColumnIO((MessageType)fileSchema, (MessageType)requestedSchema);
            ParquetReader parquetReader = new ParquetReader(Optional.ofNullable(fileMetaData.getCreatedBy()), messageColumnIO, blocks, Optional.empty(), (ParquetDataSource)dataSource, DateTimeZone.UTC, memoryContext, options);
            ImmutableList.Builder trinoTypes = ImmutableList.builder();
            ImmutableList.Builder internalFields = ImmutableList.builder();
            for (int columnIndex = 0; columnIndex < readColumns.size(); ++columnIndex) {
                IcebergColumnHandle column2 = readColumns.get(columnIndex);
                Type parquetField = (Type)parquetFields.get(columnIndex);
                io.trino.spi.type.Type trinoType = column2.getBaseType();
                trinoTypes.add((Object)trinoType);
                if (parquetField == null) {
                    internalFields.add(Optional.empty());
                    continue;
                }
                ColumnIO columnIO = messageColumnIO.getChild(parquetField.getName());
                internalFields.add(IcebergParquetColumnIOConverter.constructField(new IcebergParquetColumnIOConverter.FieldContext(trinoType, column2.getColumnIdentity()), columnIO));
            }
            return new ReaderPageSource((ConnectorPageSource)new ParquetPageSource(parquetReader, (List)trinoTypes.build(), (List)internalFields.build()), columnProjections);
        }
        catch (IOException | RuntimeException e) {
            try {
                if (dataSource != null) {
                    dataSource.close();
                }
            }
            catch (IOException inputStream) {
                // empty catch block
            }
            if (e instanceof TrinoException) {
                throw (TrinoException)e;
            }
            String message = String.format("Error opening Iceberg split %s (offset=%s, length=%s): %s", path, start, length, e.getMessage());
            if (e instanceof ParquetCorruptionException) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, message, (Throwable)e);
            }
            if (e instanceof BlockMissingException) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_MISSING_DATA, message, (Throwable)e);
            }
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    private static NameMapping convertToLowercase(NameMapping nameMapping) {
        return NameMapping.of(IcebergPageSourceProvider.convertToLowercase(nameMapping.asMappedFields().fields()));
    }

    private static MappedFields convertToLowercase(MappedFields mappedFields) {
        if (mappedFields == null) {
            return null;
        }
        return MappedFields.of(IcebergPageSourceProvider.convertToLowercase(mappedFields.fields()));
    }

    private static List<MappedField> convertToLowercase(List<MappedField> fields) {
        return (List)fields.stream().map(mappedField -> {
            Set lowercaseNames = (Set)mappedField.names().stream().map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
            return MappedField.of((Integer)mappedField.id(), (Iterable)lowercaseNames, (MappedFields)IcebergPageSourceProvider.convertToLowercase(mappedField.nestedMapping()));
        }).collect(ImmutableList.toImmutableList());
    }

    public static Optional<ReaderColumns> projectColumns(List<IcebergColumnHandle> columns) {
        Objects.requireNonNull(columns, "columns is null");
        if (columns.stream().allMatch(IcebergColumnHandle::isBaseColumn)) {
            return Optional.empty();
        }
        ImmutableList.Builder projectedColumns = ImmutableList.builder();
        ImmutableList.Builder outputColumnMapping = ImmutableList.builder();
        HashMap<Integer, Integer> mappedFieldIds = new HashMap<Integer, Integer>();
        int projectedColumnCount = 0;
        for (IcebergColumnHandle column : columns) {
            int baseColumnId = column.getBaseColumnIdentity().getId();
            Integer mapped = (Integer)mappedFieldIds.get(baseColumnId);
            if (mapped == null) {
                projectedColumns.add((Object)column.getBaseColumn());
                mappedFieldIds.put(baseColumnId, projectedColumnCount);
                outputColumnMapping.add((Object)projectedColumnCount);
                ++projectedColumnCount;
                continue;
            }
            outputColumnMapping.add((Object)mapped);
        }
        return Optional.of(new ReaderColumns((List)projectedColumns.build(), (List)outputColumnMapping.build()));
    }

    private static TupleDomain<ColumnDescriptor> getParquetTupleDomain(Map<List<String>, RichColumnDescriptor> descriptorsByPath, TupleDomain<IcebergColumnHandle> effectivePredicate) {
        if (effectivePredicate.isNone()) {
            return TupleDomain.none();
        }
        ImmutableMap.Builder predicate = ImmutableMap.builder();
        ((Map)effectivePredicate.getDomains().get()).forEach((columnHandle, domain) -> {
            RichColumnDescriptor descriptor;
            String baseType = columnHandle.getType().getTypeSignature().getBase();
            if (!(baseType.equals("map") || baseType.equals("array") || baseType.equals("row") || (descriptor = (RichColumnDescriptor)descriptorsByPath.get(ImmutableList.of((Object)columnHandle.getName()))) == null)) {
                predicate.put((Object)descriptor, domain);
            }
        });
        return TupleDomain.withColumnDomains((Map)predicate.buildOrThrow());
    }

    private static TrinoException handleException(OrcDataSourceId dataSourceId, Exception exception) {
        if (exception instanceof TrinoException) {
            return (TrinoException)exception;
        }
        if (exception instanceof OrcCorruptionException) {
            return new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, (Throwable)exception);
        }
        return new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CURSOR_ERROR, String.format("Failed to read ORC file: %s", dataSourceId), (Throwable)exception);
    }

    private static /* synthetic */ ParquetMetadata lambda$createParquetPageSource$15(ParquetDataSource theDataSource) throws IOException {
        return MetadataReader.readFooter((ParquetDataSource)theDataSource);
    }

    private static class IcebergOrcProjectedLayout
    implements OrcReader.ProjectedLayout {
        private final Map<Integer, OrcReader.ProjectedLayout> projectedLayoutForFieldId;

        private IcebergOrcProjectedLayout(Map<Integer, OrcReader.ProjectedLayout> projectedLayoutForFieldId) {
            this.projectedLayoutForFieldId = ImmutableMap.copyOf(Objects.requireNonNull(projectedLayoutForFieldId, "projectedLayoutForFieldId is null"));
        }

        public static OrcReader.ProjectedLayout createProjectedLayout(OrcColumn root, List<List<Integer>> fieldIdDereferences) {
            if (fieldIdDereferences.stream().anyMatch(List::isEmpty)) {
                return OrcReader.fullyProjectedLayout();
            }
            Map dereferencesByField = fieldIdDereferences.stream().collect(Collectors.groupingBy(sequence -> (Integer)sequence.get(0), Collectors.mapping(sequence -> sequence.subList(1, sequence.size()), Collectors.toUnmodifiableList())));
            ImmutableMap.Builder fieldLayouts = ImmutableMap.builder();
            for (OrcColumn nestedColumn : root.getNestedColumns()) {
                Integer fieldId = IcebergPageSourceProvider.getIcebergFieldId(nestedColumn);
                if (!dereferencesByField.containsKey(fieldId)) continue;
                fieldLayouts.put((Object)fieldId, (Object)IcebergOrcProjectedLayout.createProjectedLayout(nestedColumn, dereferencesByField.get(fieldId)));
            }
            return new IcebergOrcProjectedLayout((Map<Integer, OrcReader.ProjectedLayout>)fieldLayouts.buildOrThrow());
        }

        public OrcReader.ProjectedLayout getFieldLayout(OrcColumn orcColumn) {
            int fieldId = IcebergPageSourceProvider.getIcebergFieldId(orcColumn);
            return this.projectedLayoutForFieldId.getOrDefault(fieldId, OrcReader.fullyProjectedLayout());
        }
    }

    private static class IdBasedFieldMapper
    implements OrcReader.FieldMapper {
        private final Map<Integer, OrcColumn> idToColumnMappingForFile;
        private final Map<String, Integer> nameToIdMappingForTableColumns;

        public IdBasedFieldMapper(Map<Integer, OrcColumn> idToColumnMappingForFile, Map<String, Integer> nameToIdMappingForTableColumns) {
            this.idToColumnMappingForFile = Objects.requireNonNull(idToColumnMappingForFile, "idToColumnMappingForFile is null");
            this.nameToIdMappingForTableColumns = Objects.requireNonNull(nameToIdMappingForTableColumns, "nameToIdMappingForTableColumns is null");
        }

        public OrcColumn get(String fieldName) {
            int fieldId = Objects.requireNonNull(this.nameToIdMappingForTableColumns.get(fieldName), () -> String.format("Id mapping for field %s not found", fieldName));
            return this.idToColumnMappingForFile.get(fieldId);
        }
    }

    private static class IdBasedFieldMapperFactory
    implements OrcReader.FieldMapperFactory {
        private final Map<Integer, Map<String, Integer>> fieldNameToIdMappingForTableColumns;

        public IdBasedFieldMapperFactory(List<IcebergColumnHandle> columns) {
            Objects.requireNonNull(columns, "columns is null");
            ImmutableMap.Builder mapping = ImmutableMap.builder();
            for (IcebergColumnHandle column : columns) {
                IdBasedFieldMapperFactory.populateMapping(column.getColumnIdentity(), (ImmutableMap.Builder<Integer, Map<String, Integer>>)mapping);
            }
            this.fieldNameToIdMappingForTableColumns = mapping.buildOrThrow();
        }

        public OrcReader.FieldMapper create(OrcColumn column) {
            ImmutableMap nestedColumns = Maps.uniqueIndex((Iterable)column.getNestedColumns(), x$0 -> IcebergPageSourceProvider.getIcebergFieldId(x$0));
            int icebergId = IcebergPageSourceProvider.getIcebergFieldId(column);
            return new IdBasedFieldMapper((Map<Integer, OrcColumn>)nestedColumns, this.fieldNameToIdMappingForTableColumns.get(icebergId));
        }

        private static void populateMapping(ColumnIdentity identity, ImmutableMap.Builder<Integer, Map<String, Integer>> fieldNameToIdMappingForTableColumns) {
            List<ColumnIdentity> children = identity.getChildren();
            fieldNameToIdMappingForTableColumns.put((Object)identity.getId(), (Object)((Map)children.stream().collect(ImmutableMap.toImmutableMap(child -> child.getName().toLowerCase(Locale.ENGLISH), ColumnIdentity::getId))));
            for (ColumnIdentity child2 : children) {
                IdBasedFieldMapperFactory.populateMapping(child2, fieldNameToIdMappingForTableColumns);
            }
        }
    }
}

