/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.trino.parquet.writer.ParquetWriterOptions;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.parquet.ParquetFileWriter;
import io.trino.plugin.iceberg.HdfsInputFile;
import io.trino.plugin.iceberg.IcebergFileWriter;
import io.trino.spi.type.Type;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;

public class IcebergParquetFileWriter
extends ParquetFileWriter
implements IcebergFileWriter {
    private final Path outputPath;
    private final HdfsEnvironment hdfsEnvironment;
    private final HdfsEnvironment.HdfsContext hdfsContext;

    public IcebergParquetFileWriter(OutputStream outputStream, Callable<Void> rollbackAction, List<Type> fileColumnTypes, MessageType messageType, Map<List<String>, Type> primitiveTypes, ParquetWriterOptions parquetWriterOptions, int[] fileInputColumnIndexes, CompressionCodecName compressionCodecName, String trinoVersion, Path outputPath, HdfsEnvironment hdfsEnvironment, HdfsEnvironment.HdfsContext hdfsContext) {
        super(outputStream, rollbackAction, fileColumnTypes, messageType, primitiveTypes, parquetWriterOptions, fileInputColumnIndexes, compressionCodecName, trinoVersion);
        this.outputPath = Objects.requireNonNull(outputPath, "outputPath is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.hdfsContext = Objects.requireNonNull(hdfsContext, "hdfsContext is null");
    }

    @Override
    public Metrics getMetrics() {
        return (Metrics)this.hdfsEnvironment.doAs(this.hdfsContext.getIdentity(), () -> ParquetUtil.fileMetrics((InputFile)new HdfsInputFile(this.outputPath, this.hdfsEnvironment, this.hdfsContext), (MetricsConfig)MetricsConfig.getDefault()));
    }
}

