/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class IcebergPartitioningHandle
implements ConnectorPartitioningHandle {
    private final List<String> partitioning;
    private final List<IcebergColumnHandle> partitioningColumns;

    @JsonCreator
    public IcebergPartitioningHandle(@JsonProperty(value="partitioning") List<String> partitioning, @JsonProperty(value="partitioningColumns") List<IcebergColumnHandle> partitioningColumns) {
        this.partitioning = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitioning, "partitioning is null"));
        this.partitioningColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitioningColumns, "partitioningColumns is null"));
    }

    @JsonProperty
    public List<String> getPartitioning() {
        return this.partitioning;
    }

    @JsonProperty
    public List<IcebergColumnHandle> getPartitioningColumns() {
        return this.partitioningColumns;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitioning", this.partitioning).toString();
    }
}

