/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.trino.plugin.base.security.ConnectorAccessControlModule;
import io.trino.plugin.base.security.FileBasedAccessControlModule;
import io.trino.plugin.base.security.ReadOnlySecurityModule;
import io.trino.plugin.iceberg.AllowAllSecurityModule;
import io.trino.plugin.iceberg.IcebergSecurityConfig;

public class IcebergSecurityModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.install((Module)new ConnectorAccessControlModule());
        this.bindSecurityModule(IcebergSecurityConfig.IcebergSecurity.ALLOW_ALL, new AllowAllSecurityModule());
        this.bindSecurityModule(IcebergSecurityConfig.IcebergSecurity.READ_ONLY, (Module)new ReadOnlySecurityModule());
        this.bindSecurityModule(IcebergSecurityConfig.IcebergSecurity.FILE, (Module)new FileBasedAccessControlModule());
    }

    private void bindSecurityModule(IcebergSecurityConfig.IcebergSecurity icebergSecurity, Module module) {
        this.install(ConditionalModule.conditionalModule(IcebergSecurityConfig.class, security -> icebergSecurity == security.getSecuritySystem(), (Module)module));
    }
}

