/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class IcebergSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(IcebergSplit.class).instanceSize();
    private final String path;
    private final long start;
    private final long length;
    private final long fileSize;
    private final IcebergFileFormat fileFormat;
    private final List<HostAddress> addresses;
    private final Map<Integer, Optional<String>> partitionKeys;

    @JsonCreator
    public IcebergSplit(@JsonProperty(value="path") String path, @JsonProperty(value="start") long start, @JsonProperty(value="length") long length, @JsonProperty(value="fileSize") long fileSize, @JsonProperty(value="fileFormat") IcebergFileFormat fileFormat, @JsonProperty(value="addresses") List<HostAddress> addresses, @JsonProperty(value="partitionKeys") Map<Integer, Optional<String>> partitionKeys) {
        this.path = Objects.requireNonNull(path, "path is null");
        this.start = start;
        this.length = length;
        this.fileSize = fileSize;
        this.fileFormat = Objects.requireNonNull(fileFormat, "fileFormat is null");
        this.addresses = ImmutableList.copyOf((Collection)Objects.requireNonNull(addresses, "addresses is null"));
        this.partitionKeys = ImmutableMap.copyOf(Objects.requireNonNull(partitionKeys, "partitionKeys is null"));
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    @JsonProperty
    public long getStart() {
        return this.start;
    }

    @JsonProperty
    public long getLength() {
        return this.length;
    }

    @JsonProperty
    public long getFileSize() {
        return this.fileSize;
    }

    @JsonProperty
    public IcebergFileFormat getFileFormat() {
        return this.fileFormat;
    }

    @JsonProperty
    public Map<Integer, Optional<String>> getPartitionKeys() {
        return this.partitionKeys;
    }

    public Object getInfo() {
        return ImmutableMap.builder().put((Object)"path", (Object)this.path).put((Object)"start", (Object)this.start).put((Object)"length", (Object)this.length).buildOrThrow();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.path) + SizeOf.estimatedSizeOf(this.addresses, HostAddress::getRetainedSizeInBytes) + SizeOf.estimatedSizeOf(this.partitionKeys, SizeOf::sizeOf, valueOptional -> SizeOf.sizeOf((Optional)valueOptional, SizeOf::estimatedSizeOf));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.path).addValue(this.start).addValue(this.length).toString();
    }
}

