/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.TableType;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class IcebergTableHandle
implements ConnectorTableHandle {
    private final String schemaName;
    private final String tableName;
    private final TableType tableType;
    private final Optional<Long> snapshotId;
    private final TupleDomain<IcebergColumnHandle> unenforcedPredicate;
    private final TupleDomain<IcebergColumnHandle> enforcedPredicate;
    private final Set<IcebergColumnHandle> projectedColumns;
    private final Optional<String> nameMappingJson;
    private final boolean recordScannedFiles;
    private final Optional<DataSize> maxScannedFileSize;

    @JsonCreator
    public IcebergTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="tableType") TableType tableType, @JsonProperty(value="snapshotId") Optional<Long> snapshotId, @JsonProperty(value="unenforcedPredicate") TupleDomain<IcebergColumnHandle> unenforcedPredicate, @JsonProperty(value="enforcedPredicate") TupleDomain<IcebergColumnHandle> enforcedPredicate, @JsonProperty(value="projectedColumns") Set<IcebergColumnHandle> projectedColumns, @JsonProperty(value="nameMappingJson") Optional<String> nameMappingJson) {
        this(schemaName, tableName, tableType, snapshotId, unenforcedPredicate, enforcedPredicate, projectedColumns, nameMappingJson, false, Optional.empty());
    }

    public IcebergTableHandle(String schemaName, String tableName, TableType tableType, Optional<Long> snapshotId, TupleDomain<IcebergColumnHandle> unenforcedPredicate, TupleDomain<IcebergColumnHandle> enforcedPredicate, Set<IcebergColumnHandle> projectedColumns, Optional<String> nameMappingJson, boolean recordScannedFiles, Optional<DataSize> maxScannedFileSize) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.tableType = Objects.requireNonNull(tableType, "tableType is null");
        this.snapshotId = Objects.requireNonNull(snapshotId, "snapshotId is null");
        this.unenforcedPredicate = Objects.requireNonNull(unenforcedPredicate, "unenforcedPredicate is null");
        this.enforcedPredicate = Objects.requireNonNull(enforcedPredicate, "enforcedPredicate is null");
        this.projectedColumns = ImmutableSet.copyOf((Collection)Objects.requireNonNull(projectedColumns, "projectedColumns is null"));
        this.nameMappingJson = Objects.requireNonNull(nameMappingJson, "nameMappingJson is null");
        this.recordScannedFiles = recordScannedFiles;
        this.maxScannedFileSize = Objects.requireNonNull(maxScannedFileSize, "maxScannedFileSize is null");
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public TableType getTableType() {
        return this.tableType;
    }

    @JsonProperty
    public Optional<Long> getSnapshotId() {
        return this.snapshotId;
    }

    @JsonProperty
    public TupleDomain<IcebergColumnHandle> getUnenforcedPredicate() {
        return this.unenforcedPredicate;
    }

    @JsonProperty
    public TupleDomain<IcebergColumnHandle> getEnforcedPredicate() {
        return this.enforcedPredicate;
    }

    @JsonProperty
    public Set<IcebergColumnHandle> getProjectedColumns() {
        return this.projectedColumns;
    }

    @JsonProperty
    public Optional<String> getNameMappingJson() {
        return this.nameMappingJson;
    }

    @JsonIgnore
    public boolean isRecordScannedFiles() {
        return this.recordScannedFiles;
    }

    @JsonIgnore
    public Optional<DataSize> getMaxScannedFileSize() {
        return this.maxScannedFileSize;
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public SchemaTableName getSchemaTableNameWithType() {
        return new SchemaTableName(this.schemaName, this.tableName + "$" + this.tableType.name().toLowerCase(Locale.ROOT));
    }

    public IcebergTableHandle withProjectedColumns(Set<IcebergColumnHandle> projectedColumns) {
        return new IcebergTableHandle(this.schemaName, this.tableName, this.tableType, this.snapshotId, this.unenforcedPredicate, this.enforcedPredicate, projectedColumns, this.nameMappingJson, this.recordScannedFiles, this.maxScannedFileSize);
    }

    public IcebergTableHandle forOptimize(boolean recordScannedFiles, DataSize maxScannedFileSize) {
        return new IcebergTableHandle(this.schemaName, this.tableName, this.tableType, this.snapshotId, this.unenforcedPredicate, this.enforcedPredicate, this.projectedColumns, this.nameMappingJson, recordScannedFiles, Optional.of(maxScannedFileSize));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcebergTableHandle that = (IcebergTableHandle)o;
        return this.recordScannedFiles == that.recordScannedFiles && Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName) && this.tableType == that.tableType && Objects.equals(this.snapshotId, that.snapshotId) && Objects.equals(this.unenforcedPredicate, that.unenforcedPredicate) && Objects.equals(this.enforcedPredicate, that.enforcedPredicate) && Objects.equals(this.projectedColumns, that.projectedColumns) && Objects.equals(this.nameMappingJson, that.nameMappingJson) && Objects.equals(this.maxScannedFileSize, that.maxScannedFileSize);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.schemaName, this.tableName, this.tableType, this.snapshotId, this.unenforcedPredicate, this.enforcedPredicate, this.projectedColumns, this.nameMappingJson, this.recordScannedFiles, this.maxScannedFileSize});
    }

    public String toString() {
        return this.getSchemaTableNameWithType() + this.snapshotId.map(v -> "@" + v).orElse("");
    }
}

