/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import io.trino.plugin.iceberg.IcebergMetadata;
import io.trino.plugin.iceberg.IcebergMetadataFactory;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;

public class IcebergTransactionManager {
    private final IcebergMetadataFactory metadataFactory;
    private final ClassLoader classLoader;
    private final ConcurrentMap<ConnectorTransactionHandle, MemoizedMetadata> transactions = new ConcurrentHashMap<ConnectorTransactionHandle, MemoizedMetadata>();

    @Inject
    public IcebergTransactionManager(IcebergMetadataFactory metadataFactory) {
        this(metadataFactory, Thread.currentThread().getContextClassLoader());
    }

    public IcebergTransactionManager(IcebergMetadataFactory metadataFactory, ClassLoader classLoader) {
        this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadataFactory is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public void begin(ConnectorTransactionHandle transactionHandle) {
        MemoizedMetadata previousValue = this.transactions.putIfAbsent(transactionHandle, new MemoizedMetadata());
        Preconditions.checkState((previousValue == null ? 1 : 0) != 0);
    }

    public IcebergMetadata get(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity) {
        return ((MemoizedMetadata)this.transactions.get(transactionHandle)).get(identity);
    }

    public void commit(ConnectorTransactionHandle transaction) {
        MemoizedMetadata transactionalMetadata = (MemoizedMetadata)this.transactions.remove(transaction);
        Preconditions.checkArgument((transactionalMetadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
    }

    public void rollback(ConnectorTransactionHandle transaction) {
        MemoizedMetadata transactionalMetadata = (MemoizedMetadata)this.transactions.remove(transaction);
        Preconditions.checkArgument((transactionalMetadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        transactionalMetadata.optionalGet().ifPresent(metadata -> {
            try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
                metadata.rollback();
            }
        });
    }

    private class MemoizedMetadata {
        @GuardedBy(value="this")
        private IcebergMetadata metadata;

        private MemoizedMetadata() {
        }

        public synchronized Optional<IcebergMetadata> optionalGet() {
            return Optional.ofNullable(this.metadata);
        }

        public synchronized IcebergMetadata get(ConnectorIdentity identity) {
            if (this.metadata == null) {
                try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(IcebergTransactionManager.this.classLoader);){
                    this.metadata = IcebergTransactionManager.this.metadataFactory.create(identity);
                }
            }
            return this.metadata;
        }
    }
}

