/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.airlift.slice.Slices;
import io.trino.plugin.iceberg.util.Timestamps;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.UuidType;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.UUID;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public final class IcebergTypes {
    private IcebergTypes() {
    }

    public static Object convertIcebergValueToTrino(Type icebergType, Object value) {
        if (value == null) {
            return null;
        }
        if (icebergType instanceof Types.BooleanType) {
            return (Boolean)value;
        }
        if (icebergType instanceof Types.IntegerType) {
            return ((Integer)value).longValue();
        }
        if (icebergType instanceof Types.LongType) {
            return (Long)value;
        }
        if (icebergType instanceof Types.FloatType) {
            return (long)Float.floatToIntBits(((Float)value).floatValue());
        }
        if (icebergType instanceof Types.DoubleType) {
            return (Double)value;
        }
        if (icebergType instanceof Types.DecimalType) {
            Types.DecimalType icebergDecimalType = (Types.DecimalType)icebergType;
            DecimalType trinoDecimalType = DecimalType.createDecimalType((int)icebergDecimalType.precision(), (int)icebergDecimalType.scale());
            if (Decimals.isShortDecimal((io.trino.spi.type.Type)trinoDecimalType)) {
                return Decimals.encodeShortScaledValue((BigDecimal)((BigDecimal)value), (int)trinoDecimalType.getScale());
            }
            return Decimals.encodeScaledValue((BigDecimal)((BigDecimal)value), (int)trinoDecimalType.getScale());
        }
        if (icebergType instanceof Types.StringType) {
            if (value instanceof CharBuffer) {
                value = new String(((CharBuffer)value).array());
            }
            return Slices.utf8Slice((String)((String)value));
        }
        if (icebergType instanceof Types.BinaryType) {
            return Slices.wrappedBuffer((byte[])((byte[])((ByteBuffer)value).array().clone()));
        }
        if (icebergType instanceof Types.DateType) {
            return ((Integer)value).longValue();
        }
        if (icebergType instanceof Types.TimeType) {
            return Math.multiplyExact((long)((Long)value), 1000000);
        }
        if (icebergType instanceof Types.TimestampType) {
            long epochMicros = (Long)value;
            if (((Types.TimestampType)icebergType).shouldAdjustToUTC()) {
                return Timestamps.timestampTzFromMicros(epochMicros);
            }
            return epochMicros;
        }
        if (icebergType instanceof Types.UUIDType) {
            return UuidType.javaUuidToTrinoUuid((UUID)((UUID)value));
        }
        throw new UnsupportedOperationException("Unsupported iceberg type: " + icebergType);
    }
}

