/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.util.PageListBuilder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.VarcharType;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class ManifestsTable
implements SystemTable {
    private final ConnectorTableMetadata tableMetadata;
    private final Table icebergTable;
    private final Optional<Long> snapshotId;

    public ManifestsTable(SchemaTableName tableName, Table icebergTable, Optional<Long> snapshotId) {
        this.icebergTable = Objects.requireNonNull(icebergTable, "icebergTable is null");
        this.tableMetadata = new ConnectorTableMetadata(tableName, (List)ImmutableList.builder().add((Object)new ColumnMetadata("path", (io.trino.spi.type.Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("length", (io.trino.spi.type.Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("partition_spec_id", (io.trino.spi.type.Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("added_snapshot_id", (io.trino.spi.type.Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("added_data_files_count", (io.trino.spi.type.Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("existing_data_files_count", (io.trino.spi.type.Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("deleted_data_files_count", (io.trino.spi.type.Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("partitions", (io.trino.spi.type.Type)new ArrayType((io.trino.spi.type.Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"contains_null", (io.trino.spi.type.Type)BooleanType.BOOLEAN), RowType.field((String)"contains_nan", (io.trino.spi.type.Type)BooleanType.BOOLEAN), RowType.field((String)"lower_bound", (io.trino.spi.type.Type)VarcharType.VARCHAR), RowType.field((String)"upper_bound", (io.trino.spi.type.Type)VarcharType.VARCHAR)})))).build());
        this.snapshotId = Objects.requireNonNull(snapshotId, "snapshotId is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        if (this.snapshotId.isEmpty()) {
            return new FixedPageSource((Iterable)ImmutableList.of());
        }
        return new FixedPageSource(ManifestsTable.buildPages(this.tableMetadata, this.icebergTable, this.snapshotId.get()));
    }

    private static List<Page> buildPages(ConnectorTableMetadata tableMetadata, Table icebergTable, long snapshotId) {
        PageListBuilder pagesBuilder = PageListBuilder.forTable(tableMetadata);
        Snapshot snapshot = icebergTable.snapshot(snapshotId);
        if (snapshot == null) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("Snapshot ID [%s] does not exist for table: %s", snapshotId, icebergTable));
        }
        Map partitionSpecsById = icebergTable.specs();
        snapshot.allManifests().forEach(file -> {
            pagesBuilder.beginRow();
            pagesBuilder.appendVarchar(file.path());
            pagesBuilder.appendBigint(file.length());
            pagesBuilder.appendInteger(file.partitionSpecId());
            pagesBuilder.appendBigint(file.snapshotId());
            pagesBuilder.appendInteger(file.addedFilesCount());
            pagesBuilder.appendInteger(file.existingFilesCount());
            pagesBuilder.appendInteger(file.deletedFilesCount());
            ManifestsTable.writePartitionSummaries(pagesBuilder.nextColumn(), file.partitions(), (PartitionSpec)partitionSpecsById.get(file.partitionSpecId()));
            pagesBuilder.endRow();
        });
        return pagesBuilder.build();
    }

    private static void writePartitionSummaries(BlockBuilder arrayBlockBuilder, List<ManifestFile.PartitionFieldSummary> summaries, PartitionSpec partitionSpec) {
        BlockBuilder singleArrayWriter = arrayBlockBuilder.beginBlockEntry();
        for (int i = 0; i < summaries.size(); ++i) {
            ManifestFile.PartitionFieldSummary summary = summaries.get(i);
            PartitionField field = (PartitionField)partitionSpec.fields().get(i);
            Type nestedType = ((Types.NestedField)partitionSpec.partitionType().fields().get(i)).type();
            BlockBuilder rowBuilder = singleArrayWriter.beginBlockEntry();
            BooleanType.BOOLEAN.writeBoolean(rowBuilder, summary.containsNull());
            BooleanType.BOOLEAN.writeBoolean(rowBuilder, summary.containsNaN().booleanValue());
            VarcharType.VARCHAR.writeString(rowBuilder, field.transform().toHumanString(Conversions.fromByteBuffer((Type)nestedType, (ByteBuffer)summary.lowerBound())));
            VarcharType.VARCHAR.writeString(rowBuilder, field.transform().toHumanString(Conversions.fromByteBuffer((Type)nestedType, (ByteBuffer)summary.upperBound())));
            singleArrayWriter.closeEntry();
        }
        arrayBlockBuilder.closeEntry();
    }
}

