/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class PartitionData
implements StructLike {
    private static final String PARTITION_VALUES_FIELD = "partitionValues";
    private static final JsonFactory FACTORY = new JsonFactory();
    private static final ObjectMapper MAPPER = new ObjectMapper(FACTORY).configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    private final Object[] partitionValues;

    public PartitionData(Object[] partitionValues) {
        this.partitionValues = Objects.requireNonNull(partitionValues, "partitionValues is null");
    }

    public int size() {
        return this.partitionValues.length;
    }

    public <T> T get(int pos, Class<T> javaClass) {
        Object value = this.partitionValues[pos];
        if (javaClass == ByteBuffer.class && value instanceof byte[]) {
            value = ByteBuffer.wrap((byte[])value);
        }
        if (value == null || javaClass.isInstance(value)) {
            return javaClass.cast(value);
        }
        throw new IllegalArgumentException(String.format("Wrong class [%s] for object class [%s]", javaClass.getName(), value.getClass().getName()));
    }

    public <T> void set(int pos, T value) {
        this.partitionValues[pos] = value;
    }

    public String toJson() {
        try {
            StringWriter writer = new StringWriter();
            JsonGenerator generator = FACTORY.createGenerator((Writer)writer);
            generator.writeStartObject();
            generator.writeArrayFieldStart(PARTITION_VALUES_FIELD);
            for (Object value : this.partitionValues) {
                generator.writeObject(value);
            }
            generator.writeEndArray();
            generator.writeEndObject();
            generator.flush();
            return writer.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException("JSON conversion failed for PartitionData: " + Arrays.toString(this.partitionValues), e);
        }
    }

    public static PartitionData fromJson(String partitionDataAsJson, Type[] types) {
        JsonNode jsonNode;
        if (partitionDataAsJson == null) {
            return null;
        }
        try {
            jsonNode = MAPPER.readTree(partitionDataAsJson);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Conversion from JSON failed for PartitionData: " + partitionDataAsJson, e);
        }
        if (jsonNode.isNull()) {
            return null;
        }
        JsonNode partitionValues = jsonNode.get(PARTITION_VALUES_FIELD);
        Object[] objects = new Object[types.length];
        int index = 0;
        for (JsonNode partitionValue : partitionValues) {
            objects[index] = PartitionData.getValue(partitionValue, types[index]);
            ++index;
        }
        return new PartitionData(objects);
    }

    public static Object getValue(JsonNode partitionValue, Type type) {
        if (partitionValue.isNull()) {
            return null;
        }
        switch (type.typeId()) {
            case BOOLEAN: {
                return partitionValue.asBoolean();
            }
            case INTEGER: 
            case DATE: {
                return partitionValue.asInt();
            }
            case LONG: 
            case TIMESTAMP: 
            case TIME: {
                return partitionValue.asLong();
            }
            case FLOAT: {
                return Float.valueOf(partitionValue.floatValue());
            }
            case DOUBLE: {
                return partitionValue.doubleValue();
            }
            case STRING: {
                return partitionValue.asText();
            }
            case UUID: {
                return UUID.fromString(partitionValue.asText());
            }
            case FIXED: 
            case BINARY: {
                try {
                    return partitionValue.binaryValue();
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed during JSON conversion of " + partitionValue, e);
                }
            }
            case DECIMAL: {
                Types.DecimalType decimalType = (Types.DecimalType)type;
                return Decimals.rescale((BigDecimal)partitionValue.decimalValue(), (DecimalType)DecimalType.createDecimalType((int)decimalType.precision(), (int)decimalType.scale()));
            }
        }
        throw new UnsupportedOperationException("Type not supported as partition column: " + type);
    }
}

