/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.iceberg.IcebergStatistics;
import io.trino.plugin.iceberg.IcebergTypes;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.TypeConverter;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeWrapper;

public class PartitionTable
implements SystemTable {
    private final TypeManager typeManager;
    private final Table icebergTable;
    private final Optional<Long> snapshotId;
    private final Map<Integer, Type.PrimitiveType> idToTypeMapping;
    private final List<Types.NestedField> nonPartitionPrimitiveColumns;
    private final Optional<RowType> partitionColumnType;
    private final List<io.trino.spi.type.Type> partitionColumnTypes;
    private final Optional<RowType> dataColumnType;
    private final List<RowType> columnMetricTypes;
    private final List<io.trino.spi.type.Type> resultTypes;
    private final ConnectorTableMetadata connectorTableMetadata;

    public PartitionTable(SchemaTableName tableName, TypeManager typeManager, Table icebergTable, Optional<Long> snapshotId) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.icebergTable = Objects.requireNonNull(icebergTable, "icebergTable is null");
        this.snapshotId = Objects.requireNonNull(snapshotId, "snapshotId is null");
        this.idToTypeMapping = IcebergUtil.primitiveFieldTypes(icebergTable.schema());
        List columns = icebergTable.schema().columns();
        List partitionFields = icebergTable.spec().fields();
        ImmutableList.Builder columnMetadataBuilder = ImmutableList.builder();
        this.partitionColumnType = this.getPartitionColumnType(partitionFields, icebergTable.schema());
        if (this.partitionColumnType.isPresent()) {
            columnMetadataBuilder.add((Object)new ColumnMetadata("partition", (io.trino.spi.type.Type)this.partitionColumnType.get()));
            this.partitionColumnTypes = (List)this.partitionColumnType.get().getFields().stream().map(RowType.Field::getType).collect(ImmutableList.toImmutableList());
        } else {
            this.partitionColumnTypes = ImmutableList.of();
        }
        Stream.of("record_count", "file_count", "total_size").forEach(metric -> columnMetadataBuilder.add((Object)new ColumnMetadata(metric, (io.trino.spi.type.Type)BigintType.BIGINT)));
        Set identityPartitionIds = IcebergUtil.getIdentityPartitions(icebergTable.spec()).keySet().stream().map(PartitionField::sourceId).collect(Collectors.toSet());
        this.nonPartitionPrimitiveColumns = (List)columns.stream().filter(column -> !identityPartitionIds.contains(column.fieldId()) && column.type().isPrimitiveType()).collect(ImmutableList.toImmutableList());
        this.dataColumnType = this.getMetricsColumnType(this.nonPartitionPrimitiveColumns);
        if (this.dataColumnType.isPresent()) {
            columnMetadataBuilder.add((Object)new ColumnMetadata("data", (io.trino.spi.type.Type)this.dataColumnType.get()));
            this.columnMetricTypes = (List)this.dataColumnType.get().getFields().stream().map(RowType.Field::getType).map(RowType.class::cast).collect(ImmutableList.toImmutableList());
        } else {
            this.columnMetricTypes = ImmutableList.of();
        }
        ImmutableList columnMetadata = columnMetadataBuilder.build();
        this.resultTypes = (List)columnMetadata.stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
        this.connectorTableMetadata = new ConnectorTableMetadata(tableName, (List)columnMetadata);
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.connectorTableMetadata;
    }

    private Optional<RowType> getPartitionColumnType(List<PartitionField> fields, Schema schema) {
        List partitionFields = (List)fields.stream().map(field -> RowType.field((String)field.name(), (io.trino.spi.type.Type)TypeConverter.toTrinoType(field.transform().getResultType(schema.findType(field.sourceId())), this.typeManager))).collect(ImmutableList.toImmutableList());
        if (partitionFields.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(RowType.from((List)partitionFields));
    }

    private Optional<RowType> getMetricsColumnType(List<Types.NestedField> columns) {
        List metricColumns = (List)columns.stream().map(column -> RowType.field((String)column.name(), (io.trino.spi.type.Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("min"), TypeConverter.toTrinoType(column.type(), this.typeManager)), (Object)new RowType.Field(Optional.of("max"), TypeConverter.toTrinoType(column.type(), this.typeManager)), (Object)new RowType.Field(Optional.of("null_count"), (io.trino.spi.type.Type)BigintType.BIGINT))))).collect(ImmutableList.toImmutableList());
        if (metricColumns.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(RowType.from((List)metricColumns));
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        if (this.snapshotId.isEmpty()) {
            return new InMemoryRecordSet(this.resultTypes, (Iterable)ImmutableList.of()).cursor();
        }
        TableScan tableScan = this.icebergTable.newScan().useSnapshot(this.snapshotId.get().longValue()).includeColumnStats();
        return this.buildRecordCursor(this.getStatisticsByPartition(tableScan), this.icebergTable.spec().fields());
    }

    private Map<StructLikeWrapper, IcebergStatistics> getStatisticsByPartition(TableScan tableScan) {
        Object object;
        block9: {
            CloseableIterable fileScanTasks = tableScan.planFiles();
            try {
                HashMap<StructLikeWrapper, IcebergStatistics.Builder> partitions = new HashMap<StructLikeWrapper, IcebergStatistics.Builder>();
                for (FileScanTask fileScanTask : fileScanTasks) {
                    DataFile dataFile = fileScanTask.file();
                    Types.StructType structType = fileScanTask.spec().partitionType();
                    StructLike partitionStruct = dataFile.partition();
                    StructLikeWrapper partitionWrapper = StructLikeWrapper.forType((Types.StructType)structType).set(partitionStruct);
                    partitions.computeIfAbsent(partitionWrapper, ignored -> new IcebergStatistics.Builder(this.icebergTable.schema().columns(), this.typeManager)).acceptDataFile(dataFile, fileScanTask.spec());
                }
                object = (Map)partitions.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((IcebergStatistics.Builder)entry.getValue()).build()));
                if (fileScanTasks == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fileScanTasks != null) {
                        try {
                            fileScanTasks.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            fileScanTasks.close();
        }
        return object;
    }

    private RecordCursor buildRecordCursor(Map<StructLikeWrapper, IcebergStatistics> partitionStatistics, List<PartitionField> partitionFields) {
        List<Type> partitionTypes = this.partitionTypes(partitionFields);
        List partitionColumnClass = (List)partitionTypes.stream().map(type -> type.typeId().javaClass()).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder records = ImmutableList.builder();
        for (Map.Entry<StructLikeWrapper, IcebergStatistics> partitionEntry : partitionStatistics.entrySet()) {
            StructLikeWrapper partitionStruct = partitionEntry.getKey();
            IcebergStatistics icebergStatistics = partitionEntry.getValue();
            ArrayList<Long> row = new ArrayList<Long>();
            this.partitionColumnType.ifPresent(partitionColumnType -> {
                BlockBuilder partitionRowBlockBuilder = partitionColumnType.createBlockBuilder(null, 1);
                BlockBuilder partitionBlockBuilder = partitionRowBlockBuilder.beginBlockEntry();
                for (int i = 0; i < this.partitionColumnTypes.size(); ++i) {
                    io.trino.spi.type.Type trinoType = ((RowType.Field)partitionColumnType.getFields().get(i)).getType();
                    Object value = IcebergTypes.convertIcebergValueToTrino((Type)partitionTypes.get(i), partitionStruct.get().get(i, (Class)partitionColumnClass.get(i)));
                    TypeUtils.writeNativeValue((io.trino.spi.type.Type)trinoType, (BlockBuilder)partitionBlockBuilder, (Object)value);
                }
                partitionRowBlockBuilder.closeEntry();
                row.add((Long)partitionColumnType.getObject((Block)partitionRowBlockBuilder, 0));
            });
            row.add(icebergStatistics.getRecordCount());
            row.add(icebergStatistics.getFileCount());
            row.add(icebergStatistics.getSize());
            this.dataColumnType.ifPresent(dataColumnType -> {
                BlockBuilder dataRowBlockBuilder = dataColumnType.createBlockBuilder(null, 1);
                BlockBuilder dataBlockBuilder = dataRowBlockBuilder.beginBlockEntry();
                for (int i = 0; i < this.columnMetricTypes.size(); ++i) {
                    Integer fieldId = this.nonPartitionPrimitiveColumns.get(i).fieldId();
                    Object min = icebergStatistics.getMinValues().get(fieldId);
                    Object max = icebergStatistics.getMaxValues().get(fieldId);
                    Long nullCount = icebergStatistics.getNullCounts().get(fieldId);
                    if (min == null && max == null && nullCount == null) {
                        row.add(null);
                        return;
                    }
                    RowType columnMetricType = this.columnMetricTypes.get(i);
                    columnMetricType.writeObject(dataBlockBuilder, (Object)PartitionTable.getColumnMetricBlock(columnMetricType, min, max, nullCount));
                }
                dataRowBlockBuilder.closeEntry();
                row.add((Long)dataColumnType.getObject((Block)dataRowBlockBuilder, 0));
            });
            records.add(row);
        }
        return new InMemoryRecordSet(this.resultTypes, (Iterable)records.build()).cursor();
    }

    private List<Type> partitionTypes(List<PartitionField> partitionFields) {
        ImmutableList.Builder partitionTypeBuilder = ImmutableList.builder();
        for (PartitionField partitionField : partitionFields) {
            Type.PrimitiveType sourceType = this.idToTypeMapping.get(partitionField.sourceId());
            Type type = partitionField.transform().getResultType((Type)sourceType);
            partitionTypeBuilder.add((Object)type);
        }
        return partitionTypeBuilder.build();
    }

    private static Block getColumnMetricBlock(RowType columnMetricType, Object min, Object max, Long nullCount) {
        BlockBuilder rowBlockBuilder = columnMetricType.createBlockBuilder(null, 1);
        BlockBuilder builder = rowBlockBuilder.beginBlockEntry();
        List fields = columnMetricType.getFields();
        TypeUtils.writeNativeValue((io.trino.spi.type.Type)((RowType.Field)fields.get(0)).getType(), (BlockBuilder)builder, (Object)min);
        TypeUtils.writeNativeValue((io.trino.spi.type.Type)((RowType.Field)fields.get(1)).getType(), (BlockBuilder)builder, (Object)max);
        TypeUtils.writeNativeValue((io.trino.spi.type.Type)((RowType.Field)fields.get(2)).getType(), (BlockBuilder)builder, (Object)nullCount);
        rowBlockBuilder.closeEntry();
        return columnMetricType.getObject((Block)rowBlockBuilder, 0);
    }
}

