/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveSchemaProperties;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.HiveViewNotSupportedException;
import io.trino.plugin.hive.TableAlreadyExistsException;
import io.trino.plugin.hive.ViewAlreadyExistsException;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergMaterializedViewDefinition;
import io.trino.plugin.iceberg.IcebergSchemaProperties;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.PartitionFields;
import io.trino.plugin.iceberg.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.IcebergTableOperations;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.MaterializedViewNotFoundException;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.connector.ViewNotFoundException;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.Transactions;
import org.apache.iceberg.io.FileIO;

class TrinoHiveCatalog
implements TrinoCatalog {
    private static final Logger log = Logger.get(TrinoHiveCatalog.class);
    private static final String ICEBERG_MATERIALIZED_VIEW_COMMENT = "Presto Materialized View";
    public static final String DEPENDS_ON_TABLES = "dependsOnTables";
    private static final String TRINO_CREATED_BY = "trino_created_by";
    private static final String TRINO_CREATED_BY_VALUE = "Trino Iceberg connector";
    private static final String PRESTO_VIEW_COMMENT = "Presto View";
    private static final String PRESTO_VERSION_NAME = "presto_version";
    private static final String PRESTO_QUERY_ID_NAME = "presto_query_id";
    private static final String PRESTO_VIEW_EXPANDED_TEXT_MARKER = "/* Presto View */";
    private final CatalogName catalogName;
    private final CachingHiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final TypeManager typeManager;
    private final IcebergTableOperationsProvider tableOperationsProvider;
    private final String trinoVersion;
    private final boolean useUniqueTableLocation;
    private final boolean isUsingSystemSecurity;
    private final boolean deleteSchemaLocationsFallback;
    private final Map<SchemaTableName, TableMetadata> tableMetadataCache = new ConcurrentHashMap<SchemaTableName, TableMetadata>();
    private final ViewReaderUtil.PrestoViewReader viewReader = new ViewReaderUtil.PrestoViewReader();

    public TrinoHiveCatalog(CatalogName catalogName, CachingHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, TypeManager typeManager, IcebergTableOperationsProvider tableOperationsProvider, String trinoVersion, boolean useUniqueTableLocation, boolean isUsingSystemSecurity, boolean deleteSchemaLocationsFallback) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.tableOperationsProvider = Objects.requireNonNull(tableOperationsProvider, "tableOperationsProvider is null");
        this.trinoVersion = Objects.requireNonNull(trinoVersion, "trinoVersion is null");
        this.useUniqueTableLocation = useUniqueTableLocation;
        this.isUsingSystemSecurity = isUsingSystemSecurity;
        this.deleteSchemaLocationsFallback = deleteSchemaLocationsFallback;
    }

    @Override
    public List<String> listNamespaces(ConnectorSession session) {
        return this.metastore.getAllDatabases().stream().filter(schemaName -> !HiveUtil.isHiveSystemSchema((String)schemaName)).collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> loadNamespaceMetadata(ConnectorSession session, String namespace) {
        Optional db = this.metastore.getDatabase(namespace);
        if (db.isPresent()) {
            return HiveSchemaProperties.fromDatabase((Database)((Database)db.get()));
        }
        throw new SchemaNotFoundException(namespace);
    }

    @Override
    public Optional<TrinoPrincipal> getNamespacePrincipal(ConnectorSession session, String namespace) {
        Optional database = this.metastore.getDatabase(namespace);
        if (database.isPresent()) {
            return database.flatMap(db -> db.getOwnerName().map(ownerName -> new TrinoPrincipal((PrincipalType)db.getOwnerType().orElseThrow(), ownerName)));
        }
        throw new SchemaNotFoundException(namespace);
    }

    @Override
    public void createNamespace(ConnectorSession session, String namespace, Map<String, Object> properties, TrinoPrincipal owner) {
        Optional<String> location = IcebergSchemaProperties.getSchemaLocation(properties).map(uri -> {
            try {
                this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session), new Path(uri));
            }
            catch (IOException | IllegalArgumentException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SCHEMA_PROPERTY, "Invalid location URI: " + uri, (Throwable)e);
            }
            return uri;
        });
        Database database = Database.builder().setDatabaseName(namespace).setLocation(location).setOwnerType(this.isUsingSystemSecurity ? Optional.empty() : Optional.of(owner.getType())).setOwnerName(this.isUsingSystemSecurity ? Optional.empty() : Optional.of(owner.getName())).build();
        this.metastore.createDatabase(database);
    }

    @Override
    public void dropNamespace(ConnectorSession session, String namespace) {
        if (!this.listTables(session, Optional.of(namespace)).isEmpty() || !this.listViews(session, Optional.of(namespace)).isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_EMPTY, "Schema not empty: " + namespace);
        }
        Optional<Path> location = ((Database)this.metastore.getDatabase(namespace).orElseThrow(() -> new SchemaNotFoundException(namespace))).getLocation().map(Path::new);
        boolean deleteData = location.map(path -> {
            Boolean bl;
            block8: {
                HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session);
                FileSystem fs = this.hdfsEnvironment.getFileSystem(context, path);
                try {
                    bl = !fs.listLocatedStatus(path).hasNext();
                    if (fs == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (fs != null) {
                            try {
                                fs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        log.warn((Throwable)e, "Could not check schema directory '%s'", new Object[]{path});
                        return this.deleteSchemaLocationsFallback;
                    }
                }
                fs.close();
            }
            return bl;
        }).orElse(this.deleteSchemaLocationsFallback);
        this.metastore.dropDatabase(namespace, deleteData);
    }

    @Override
    public void renameNamespace(ConnectorSession session, String source, String target) {
        this.metastore.renameDatabase(source, target);
    }

    @Override
    public void setNamespacePrincipal(ConnectorSession session, String namespace, TrinoPrincipal principal) {
        this.metastore.setDatabaseOwner(namespace, HivePrincipal.from((TrinoPrincipal)principal));
    }

    @Override
    public Transaction newCreateTableTransaction(ConnectorSession session, SchemaTableName schemaTableName, Schema schema, PartitionSpec partitionSpec, String location, Map<String, String> properties) {
        TableMetadata metadata = TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)partitionSpec, (String)location, properties);
        IcebergTableOperations ops = this.tableOperationsProvider.createTableOperations((HiveMetastore)this.metastore, session, schemaTableName.getSchemaName(), schemaTableName.getTableName(), this.isUsingSystemSecurity ? Optional.empty() : Optional.of(session.getUser()), Optional.of(location));
        return Transactions.createTableTransaction((String)schemaTableName.toString(), (TableOperations)ops, (TableMetadata)metadata);
    }

    @Override
    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> namespace) {
        ImmutableSet.Builder tablesListBuilder = ImmutableSet.builder();
        this.listNamespaces(session, namespace).stream().flatMap(schema -> Stream.concat(this.metastore.getTablesWithParameter(schema, "table_type", "iceberg".toLowerCase(Locale.ENGLISH)).stream().map(table -> new SchemaTableName(schema, table)), this.metastore.getTablesWithParameter(schema, "table_type", "iceberg".toUpperCase(Locale.ENGLISH)).stream().map(table -> new SchemaTableName(schema, table))).distinct()).forEach(arg_0 -> ((ImmutableSet.Builder)tablesListBuilder).add(arg_0));
        tablesListBuilder.addAll(this.listViews(session, namespace));
        tablesListBuilder.addAll(this.listMaterializedViews(session, namespace));
        return tablesListBuilder.build().asList();
    }

    @Override
    public void dropTable(ConnectorSession session, SchemaTableName schemaTableName) {
        BaseTable table = (BaseTable)this.loadTable(session, schemaTableName);
        TableMetadata metadata = table.operations().current();
        if (table.properties().containsKey("write.object-storage.path") || table.properties().containsKey("write.folder-storage.path") || table.properties().containsKey("write.metadata.path") || table.properties().containsKey("write.data.path")) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table " + schemaTableName + " contains Iceberg path override properties and cannot be dropped from Trino");
        }
        Table metastoreTable = (Table)this.metastore.getTable(schemaTableName.getSchemaName(), schemaTableName.getTableName()).orElseThrow(() -> new TableNotFoundException(schemaTableName));
        this.metastore.dropTable(schemaTableName.getSchemaName(), schemaTableName.getTableName(), false);
        CatalogUtil.dropTableData((FileIO)table.io(), (TableMetadata)metadata);
        this.deleteTableDirectory(session, metastoreTable);
    }

    private void deleteTableDirectory(ConnectorSession session, Table metastoreTable) {
        Path tablePath = new Path(metastoreTable.getStorage().getLocation());
        try {
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session), tablePath);
            fileSystem.delete(tablePath, true);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, String.format("Failed to delete directory %s of the table %s.%s", tablePath, metastoreTable.getDatabaseName(), metastoreTable.getTableName()), (Throwable)e);
        }
    }

    @Override
    public void renameTable(ConnectorSession session, SchemaTableName from, SchemaTableName to) {
        this.metastore.renameTable(from.getSchemaName(), from.getTableName(), to.getSchemaName(), to.getTableName());
    }

    @Override
    public org.apache.iceberg.Table loadTable(ConnectorSession session, SchemaTableName schemaTableName) {
        TableMetadata metadata = this.tableMetadataCache.computeIfAbsent(schemaTableName, ignore -> ((BaseTable)IcebergUtil.loadIcebergTable((HiveMetastore)this.metastore, this.tableOperationsProvider, session, schemaTableName)).operations().current());
        return IcebergUtil.getIcebergTableWithMetadata((HiveMetastore)this.metastore, this.tableOperationsProvider, session, schemaTableName, metadata);
    }

    @Override
    public void updateTableComment(ConnectorSession session, SchemaTableName schemaTableName, Optional<String> comment) {
        this.metastore.commentTable(schemaTableName.getSchemaName(), schemaTableName.getTableName(), comment);
        org.apache.iceberg.Table icebergTable = this.loadTable(session, schemaTableName);
        if (comment.isEmpty()) {
            icebergTable.updateProperties().remove("comment").commit();
        } else {
            icebergTable.updateProperties().set("comment", comment.get()).commit();
        }
    }

    @Override
    public void updateColumnComment(ConnectorSession session, SchemaTableName schemaTableName, ColumnIdentity columnIdentity, Optional<String> comment) {
        this.metastore.commentColumn(schemaTableName.getSchemaName(), schemaTableName.getTableName(), columnIdentity.getName(), comment);
        org.apache.iceberg.Table icebergTable = this.loadTable(session, schemaTableName);
        icebergTable.updateSchema().updateColumnDoc(columnIdentity.getName(), (String)comment.orElse(null)).commit();
    }

    @Override
    public String defaultTableLocation(ConnectorSession session, SchemaTableName schemaTableName) {
        Database database = (Database)this.metastore.getDatabase(schemaTableName.getSchemaName()).orElseThrow(() -> new SchemaNotFoundException(schemaTableName.getSchemaName()));
        Object tableNameForLocation = schemaTableName.getTableName();
        if (this.useUniqueTableLocation) {
            tableNameForLocation = (String)tableNameForLocation + "-" + UUID.randomUUID().toString().replace("-", "");
        }
        return HiveWriteUtils.getTableDefaultLocation((Database)database, (HdfsEnvironment.HdfsContext)new HdfsEnvironment.HdfsContext(session), (HdfsEnvironment)this.hdfsEnvironment, (String)schemaTableName.getSchemaName(), (String)tableNameForLocation).toString();
    }

    @Override
    public void setTablePrincipal(ConnectorSession session, SchemaTableName schemaTableName, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support setting an owner on a table");
    }

    @Override
    public void createView(ConnectorSession session, SchemaTableName schemaViewName, ConnectorViewDefinition definition, boolean replace) {
        if (this.isUsingSystemSecurity) {
            definition = definition.withoutOwner();
        }
        ImmutableMap properties = ImmutableMap.builder().put((Object)"presto_view", (Object)"true").put((Object)TRINO_CREATED_BY, (Object)TRINO_CREATED_BY_VALUE).put((Object)PRESTO_VERSION_NAME, (Object)this.trinoVersion).put((Object)PRESTO_QUERY_ID_NAME, (Object)session.getQueryId()).put((Object)"comment", (Object)PRESTO_VIEW_COMMENT).buildOrThrow();
        Table.Builder tableBuilder = Table.builder().setDatabaseName(schemaViewName.getSchemaName()).setTableName(schemaViewName.getTableName()).setOwner(this.isUsingSystemSecurity ? Optional.empty() : Optional.of(session.getUser())).setTableType(TableType.VIRTUAL_VIEW.name()).setDataColumns((List)ImmutableList.of((Object)new Column("dummy", HiveType.HIVE_STRING, Optional.empty()))).setPartitionColumns((List)ImmutableList.of()).setParameters((Map)properties).setViewOriginalText(Optional.of(ViewReaderUtil.encodeViewData((ConnectorViewDefinition)definition))).setViewExpandedText(Optional.of(PRESTO_VIEW_EXPANDED_TEXT_MARKER));
        tableBuilder.getStorageBuilder().setStorageFormat(StorageFormat.VIEW_STORAGE_FORMAT).setLocation("");
        Table table = tableBuilder.build();
        PrincipalPrivileges principalPrivileges = this.isUsingSystemSecurity ? PrincipalPrivileges.NO_PRIVILEGES : MetastoreUtil.buildInitialPrivilegeSet((String)session.getUser());
        Optional existing = this.metastore.getTable(schemaViewName.getSchemaName(), schemaViewName.getTableName());
        if (existing.isPresent()) {
            if (!replace || !ViewReaderUtil.isPrestoView((Table)((Table)existing.get()))) {
                throw new ViewAlreadyExistsException(schemaViewName);
            }
            this.metastore.replaceTable(schemaViewName.getSchemaName(), schemaViewName.getTableName(), table, principalPrivileges);
            return;
        }
        try {
            this.metastore.createTable(table, principalPrivileges);
        }
        catch (TableAlreadyExistsException e) {
            throw new ViewAlreadyExistsException(e.getTableName());
        }
    }

    @Override
    public void renameView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        this.metastore.renameTable(source.getSchemaName(), source.getTableName(), target.getSchemaName(), target.getTableName());
    }

    @Override
    public void setViewPrincipal(ConnectorSession session, SchemaTableName schemaViewName, TrinoPrincipal principal) {
        this.setTablePrincipal(session, schemaViewName, principal);
    }

    @Override
    public void dropView(ConnectorSession session, SchemaTableName schemaViewName) {
        if (this.getView(session, schemaViewName).isEmpty()) {
            throw new ViewNotFoundException(schemaViewName);
        }
        try {
            this.metastore.dropTable(schemaViewName.getSchemaName(), schemaViewName.getTableName(), true);
        }
        catch (TableNotFoundException e) {
            throw new ViewNotFoundException(e.getTableName());
        }
    }

    @Override
    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> namespace) {
        return (List)this.listNamespaces(session, namespace).stream().flatMap(this::listViews).collect(ImmutableList.toImmutableList());
    }

    private Stream<SchemaTableName> listViews(String schema) {
        return this.metastore.getTablesWithParameter(schema, "comment", PRESTO_VIEW_COMMENT).stream().map(table -> new SchemaTableName(schema, table));
    }

    @Override
    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> namespace) {
        ImmutableMap.Builder views = ImmutableMap.builder();
        for (SchemaTableName name : this.listViews(session, namespace)) {
            try {
                this.getView(session, name).ifPresent(view -> views.put((Object)name, view));
            }
            catch (TrinoException e) {
                if (e.getErrorCode().equals((Object)StandardErrorCode.TABLE_NOT_FOUND.toErrorCode())) continue;
                throw e;
            }
        }
        return views.buildOrThrow();
    }

    @Override
    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewIdentifier) {
        if (HiveUtil.isHiveSystemSchema((String)viewIdentifier.getSchemaName())) {
            return Optional.empty();
        }
        return this.metastore.getTable(viewIdentifier.getSchemaName(), viewIdentifier.getTableName()).filter(table -> PRESTO_VIEW_COMMENT.equals(table.getParameters().get("comment"))).filter(ViewReaderUtil::canDecodeView).map(view -> {
            if (!ViewReaderUtil.isPrestoView((Table)view)) {
                throw new HiveViewNotSupportedException(viewIdentifier);
            }
            ConnectorViewDefinition definition = this.viewReader.decodeViewData((String)view.getViewOriginalText().get(), view, this.catalogName);
            if (view.getOwner().isPresent() && !definition.isRunAsInvoker()) {
                definition = new ConnectorViewDefinition(definition.getOriginalSql(), definition.getCatalog(), definition.getSchema(), definition.getColumns(), definition.getComment(), view.getOwner(), false);
            }
            return definition;
        });
    }

    @Override
    public List<SchemaTableName> listMaterializedViews(ConnectorSession session, Optional<String> namespace) {
        return (List)this.listNamespaces(session, namespace).stream().flatMap(schema -> this.metastore.getTablesWithParameter(schema, "comment", ICEBERG_MATERIALIZED_VIEW_COMMENT).stream().map(table -> new SchemaTableName(schema, table))).collect(ImmutableList.toImmutableList());
    }

    @Override
    public void createMaterializedView(ConnectorSession session, SchemaTableName schemaViewName, ConnectorMaterializedViewDefinition definition, boolean replace, boolean ignoreExisting) {
        PrincipalPrivileges principalPrivileges;
        Optional existing = this.metastore.getTable(schemaViewName.getSchemaName(), schemaViewName.getTableName());
        if (!replace && existing.isPresent()) {
            if (ignoreExisting) {
                return;
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Materialized view already exists: " + schemaViewName);
        }
        String storageTableName = "st_" + UUID.randomUUID().toString().replace("-", "");
        HashMap<String, String> storageTableProperties = new HashMap<String, String>(definition.getProperties());
        storageTableProperties.putIfAbsent("format", "parquet");
        SchemaTableName storageTable = new SchemaTableName(schemaViewName.getSchemaName(), storageTableName);
        List columns = (List)definition.getColumns().stream().map(column -> new ColumnMetadata(column.getName(), this.typeManager.getType(column.getType()))).collect(ImmutableList.toImmutableList());
        ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(storageTable, columns, storageTableProperties, Optional.empty());
        Transaction transaction = IcebergUtil.newCreateTableTransaction(this, tableMetadata, session);
        transaction.newAppend().commit();
        transaction.commitTransaction();
        ImmutableMap viewProperties = ImmutableMap.builder().put((Object)PRESTO_QUERY_ID_NAME, (Object)session.getQueryId()).put((Object)"storage_table", (Object)storageTableName).put((Object)"presto_view", (Object)"true").put((Object)TRINO_CREATED_BY, (Object)TRINO_CREATED_BY_VALUE).put((Object)"comment", (Object)ICEBERG_MATERIALIZED_VIEW_COMMENT).buildOrThrow();
        Column dummyColumn = new Column("dummy", HiveType.HIVE_STRING, Optional.empty());
        Table.Builder tableBuilder = Table.builder().setDatabaseName(schemaViewName.getSchemaName()).setTableName(schemaViewName.getTableName()).setOwner(this.isUsingSystemSecurity ? Optional.empty() : Optional.of(session.getUser())).setTableType(TableType.VIRTUAL_VIEW.name()).setDataColumns((List)ImmutableList.of((Object)dummyColumn)).setPartitionColumns((List)ImmutableList.of()).setParameters((Map)viewProperties).withStorage(storage -> storage.setStorageFormat(StorageFormat.VIEW_STORAGE_FORMAT)).withStorage(storage -> storage.setLocation("")).setViewOriginalText(Optional.of(IcebergMaterializedViewDefinition.encodeMaterializedViewData(IcebergMaterializedViewDefinition.fromConnectorMaterializedViewDefinition(definition)))).setViewExpandedText(Optional.of("/* Presto Materialized View */"));
        Table table = tableBuilder.build();
        PrincipalPrivileges principalPrivileges2 = principalPrivileges = this.isUsingSystemSecurity ? PrincipalPrivileges.NO_PRIVILEGES : MetastoreUtil.buildInitialPrivilegeSet((String)session.getUser());
        if (existing.isPresent() && replace) {
            String oldStorageTable = (String)((Table)existing.get()).getParameters().get("storage_table");
            if (oldStorageTable != null) {
                this.metastore.dropTable(schemaViewName.getSchemaName(), oldStorageTable, true);
            }
            this.metastore.replaceTable(schemaViewName.getSchemaName(), schemaViewName.getTableName(), table, principalPrivileges);
            return;
        }
        this.metastore.createTable(table, principalPrivileges);
    }

    @Override
    public void dropMaterializedView(ConnectorSession session, SchemaTableName schemaViewName) {
        Table view = (Table)this.metastore.getTable(schemaViewName.getSchemaName(), schemaViewName.getTableName()).orElseThrow(() -> new MaterializedViewNotFoundException(schemaViewName));
        String storageTableName = (String)view.getParameters().get("storage_table");
        if (storageTableName != null) {
            try {
                this.metastore.dropTable(schemaViewName.getSchemaName(), storageTableName, true);
            }
            catch (TrinoException e) {
                log.warn((Throwable)e, "Failed to drop storage table '%s' for materialized view '%s'", new Object[]{storageTableName, schemaViewName});
            }
        }
        this.metastore.dropTable(schemaViewName.getSchemaName(), schemaViewName.getTableName(), true);
    }

    @Override
    public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(ConnectorSession session, SchemaTableName schemaViewName) {
        try {
            return (Optional)Failsafe.with((Policy[])new RetryPolicy[]{new RetryPolicy().withMaxAttempts(10).withBackoff(1L, 5000L, ChronoUnit.MILLIS, 4.0).withMaxDuration(Duration.ofSeconds(30L)).abortOn(failure -> !(failure instanceof MaterializedViewMayBeBeingRemovedException))}).get(() -> this.doGetMaterializedView(session, schemaViewName));
        }
        catch (MaterializedViewMayBeBeingRemovedException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }

    private Optional<ConnectorMaterializedViewDefinition> doGetMaterializedView(ConnectorSession session, SchemaTableName schemaViewName) {
        org.apache.iceberg.Table icebergTable;
        Optional tableOptional = this.metastore.getTable(schemaViewName.getSchemaName(), schemaViewName.getTableName());
        if (tableOptional.isEmpty()) {
            return Optional.empty();
        }
        Table table = (Table)tableOptional.get();
        if (!(ViewReaderUtil.isPrestoView((Table)table) && ViewReaderUtil.isHiveOrPrestoView((Table)table) && table.getParameters().containsKey("storage_table"))) {
            return Optional.empty();
        }
        Table materializedView = (Table)tableOptional.get();
        String storageTable = (String)materializedView.getParameters().get("storage_table");
        Preconditions.checkState((storageTable != null ? 1 : 0) != 0, (Object)("Storage table missing in definition of materialized view " + schemaViewName));
        IcebergMaterializedViewDefinition definition = IcebergMaterializedViewDefinition.decodeMaterializedViewData((String)materializedView.getViewOriginalText().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "No view original text: " + schemaViewName)));
        try {
            icebergTable = this.loadTable(session, new SchemaTableName(schemaViewName.getSchemaName(), storageTable));
        }
        catch (RuntimeException e) {
            this.metastore.invalidateTable(schemaViewName.getSchemaName(), schemaViewName.getTableName());
            this.metastore.invalidateTable(schemaViewName.getSchemaName(), storageTable);
            throw new MaterializedViewMayBeBeingRemovedException(e);
        }
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.put((Object)"format", (Object)IcebergUtil.getFileFormat(icebergTable));
        if (!icebergTable.spec().fields().isEmpty()) {
            properties.put((Object)"partitioning", PartitionFields.toPartitionFields(icebergTable.spec()));
        }
        return Optional.of(new ConnectorMaterializedViewDefinition(definition.getOriginalSql(), Optional.of(new CatalogSchemaTableName(this.catalogName.toString(), new SchemaTableName(schemaViewName.getSchemaName(), storageTable))), definition.getCatalog(), definition.getSchema(), (List)definition.getColumns().stream().map(column -> new ConnectorMaterializedViewDefinition.Column(column.getName(), column.getType())).collect(ImmutableList.toImmutableList()), definition.getComment(), materializedView.getOwner(), (Map)properties.buildOrThrow()));
    }

    @Override
    public void renameMaterializedView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        this.metastore.renameTable(source.getSchemaName(), source.getTableName(), target.getSchemaName(), target.getTableName());
    }

    private List<String> listNamespaces(ConnectorSession session, Optional<String> namespace) {
        if (namespace.isPresent()) {
            if (HiveUtil.isHiveSystemSchema((String)namespace.get())) {
                return ImmutableList.of();
            }
            return ImmutableList.of((Object)namespace.get());
        }
        return this.listNamespaces(session);
    }

    private static class MaterializedViewMayBeBeingRemovedException
    extends RuntimeException {
        public MaterializedViewMayBeBeingRemovedException(Throwable cause) {
            super(Objects.requireNonNull(cause, "cause is null"));
        }
    }
}

