/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.UnknownTableTypeException;
import io.trino.plugin.iceberg.catalog.IcebergTableOperations;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.hive.HiveSchemaUtil;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Tasks;

@NotThreadSafe
public abstract class AbstractMetastoreTableOperations
implements IcebergTableOperations {
    private static final Logger log = Logger.get(AbstractMetastoreTableOperations.class);
    protected static final String METADATA_FOLDER_NAME = "metadata";
    protected static final StorageFormat STORAGE_FORMAT = StorageFormat.create((String)LazySimpleSerDe.class.getName(), (String)FileInputFormat.class.getName(), (String)FileOutputFormat.class.getName());
    protected final HiveMetastore metastore;
    protected final ConnectorSession session;
    protected final String database;
    protected final String tableName;
    protected final Optional<String> owner;
    protected final Optional<String> location;
    protected final FileIO fileIo;
    protected TableMetadata currentMetadata;
    protected String currentMetadataLocation;
    protected boolean shouldRefresh = true;
    protected int version = -1;

    protected AbstractMetastoreTableOperations(FileIO fileIo, HiveMetastore metastore, ConnectorSession session, String database, String table, Optional<String> owner, Optional<String> location) {
        this.fileIo = Objects.requireNonNull(fileIo, "fileIo is null");
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.database = Objects.requireNonNull(database, "database is null");
        this.tableName = Objects.requireNonNull(table, "table is null");
        this.owner = Objects.requireNonNull(owner, "owner is null");
        this.location = Objects.requireNonNull(location, "location is null");
    }

    @Override
    public void initializeFromMetadata(TableMetadata tableMetadata) {
        Preconditions.checkState((this.currentMetadata == null ? 1 : 0) != 0, (Object)"already initialized");
        this.currentMetadata = tableMetadata;
        this.currentMetadataLocation = tableMetadata.metadataFileLocation();
        this.shouldRefresh = false;
        this.version = AbstractMetastoreTableOperations.parseVersion(this.currentMetadataLocation);
    }

    public TableMetadata current() {
        if (this.shouldRefresh) {
            return this.refresh();
        }
        return this.currentMetadata;
    }

    public TableMetadata refresh() {
        if (this.location.isPresent()) {
            this.refreshFromMetadataLocation(null);
            return this.currentMetadata;
        }
        Table table = this.getTable();
        if (ViewReaderUtil.isPrestoView((Table)table) && ViewReaderUtil.isHiveOrPrestoView((Table)table)) {
            throw new TableNotFoundException(this.getSchemaTableName());
        }
        if (!IcebergUtil.isIcebergTable(table)) {
            throw new UnknownTableTypeException(this.getSchemaTableName());
        }
        String metadataLocation = (String)table.getParameters().get("metadata_location");
        if (metadataLocation == null) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("Table is missing [%s] property: %s", "metadata_location", this.getSchemaTableName()));
        }
        this.refreshFromMetadataLocation(metadataLocation);
        return this.currentMetadata;
    }

    public void commit(@Nullable TableMetadata base, TableMetadata metadata) {
        Objects.requireNonNull(metadata, "metadata is null");
        if (!Objects.equals(base, this.current())) {
            throw new CommitFailedException("Cannot commit: stale table metadata for %s", new Object[]{this.getSchemaTableName()});
        }
        if (Objects.equals(base, metadata)) {
            return;
        }
        if (base == null) {
            this.commitNewTable(metadata);
        } else {
            this.commitToExistingTable(base, metadata);
        }
        this.shouldRefresh = true;
    }

    protected void commitNewTable(TableMetadata metadata) {
        String newMetadataLocation = this.writeNewMetadata(metadata, this.version + 1);
        Table.Builder builder = Table.builder().setDatabaseName(this.database).setTableName(this.tableName).setOwner(this.owner).setTableType(TableType.EXTERNAL_TABLE.name()).setDataColumns(AbstractMetastoreTableOperations.toHiveColumns(metadata.schema().columns())).withStorage(storage -> storage.setLocation(metadata.location())).withStorage(storage -> storage.setStorageFormat(STORAGE_FORMAT)).setParameter("EXTERNAL", "TRUE").setParameter("table_type", "iceberg").setParameter("metadata_location", newMetadataLocation);
        String tableComment = (String)metadata.properties().get("comment");
        if (tableComment != null) {
            builder.setParameter("comment", tableComment);
        }
        Table table = builder.build();
        PrincipalPrivileges privileges = this.owner.map(MetastoreUtil::buildInitialPrivilegeSet).orElse(PrincipalPrivileges.NO_PRIVILEGES);
        this.metastore.createTable(table, privileges);
    }

    protected abstract void commitToExistingTable(TableMetadata var1, TableMetadata var2);

    public FileIO io() {
        return this.fileIo;
    }

    public String metadataFileLocation(String filename) {
        String location;
        TableMetadata metadata = this.current();
        if (metadata != null) {
            String writeLocation = (String)metadata.properties().get("write.metadata.path");
            if (writeLocation != null) {
                return String.format("%s/%s", writeLocation, filename);
            }
            location = metadata.location();
        } else {
            location = this.location.orElseThrow(() -> new IllegalStateException("Location not set"));
        }
        return String.format("%s/%s/%s", location, METADATA_FOLDER_NAME, filename);
    }

    public LocationProvider locationProvider() {
        TableMetadata metadata = this.current();
        return IcebergUtil.getLocationProvider(this.getSchemaTableName(), metadata.location(), metadata.properties());
    }

    protected Table getTable() {
        return (Table)this.metastore.getTable(this.database, this.tableName).orElseThrow(() -> new TableNotFoundException(this.getSchemaTableName()));
    }

    protected SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.database, this.tableName);
    }

    protected String writeNewMetadata(TableMetadata metadata, int newVersion) {
        String newTableMetadataFilePath = AbstractMetastoreTableOperations.newTableMetadataFilePath(metadata, newVersion);
        OutputFile newMetadataLocation = this.fileIo.newOutputFile(newTableMetadataFilePath);
        TableMetadataParser.write((TableMetadata)metadata, (OutputFile)newMetadataLocation);
        return newTableMetadataFilePath;
    }

    protected void refreshFromMetadataLocation(String newLocation) {
        if (Objects.equals(this.currentMetadataLocation, newLocation)) {
            this.shouldRefresh = false;
            return;
        }
        AtomicReference newMetadata = new AtomicReference();
        Tasks.foreach((Object[])new String[]{newLocation}).retry(20).exponentialBackoff(100L, 5000L, 600000L, 4.0).stopRetryOn(new Class[]{NotFoundException.class}).run(metadataLocation -> newMetadata.set(TableMetadataParser.read((FileIO)this.fileIo, (InputFile)this.io().newInputFile(metadataLocation))));
        String newUUID = ((TableMetadata)newMetadata.get()).uuid();
        if (this.currentMetadata != null) {
            Preconditions.checkState((newUUID == null || newUUID.equals(this.currentMetadata.uuid()) ? 1 : 0) != 0, (String)"Table UUID does not match: current=%s != refreshed=%s", (Object)this.currentMetadata.uuid(), (Object)newUUID);
        }
        this.currentMetadata = (TableMetadata)newMetadata.get();
        this.currentMetadataLocation = newLocation;
        this.version = AbstractMetastoreTableOperations.parseVersion(newLocation);
        this.shouldRefresh = false;
    }

    protected static String newTableMetadataFilePath(TableMetadata meta, int newVersion) {
        String codec = meta.property("write.metadata.compression-codec", "none");
        return AbstractMetastoreTableOperations.metadataFileLocation(meta, String.format("%05d-%s%s", newVersion, UUID.randomUUID(), TableMetadataParser.getFileExtension((String)codec)));
    }

    protected static String metadataFileLocation(TableMetadata metadata, String filename) {
        String location = (String)metadata.properties().get("write.metadata.path");
        if (location != null) {
            return String.format("%s/%s", location, filename);
        }
        return String.format("%s/%s/%s", metadata.location(), METADATA_FOLDER_NAME, filename);
    }

    protected static int parseVersion(String metadataLocation) {
        int versionStart = metadataLocation.lastIndexOf(47) + 1;
        int versionEnd = metadataLocation.indexOf(45, versionStart);
        try {
            return Integer.parseInt(metadataLocation.substring(versionStart, versionEnd));
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            log.warn((Throwable)e, "Unable to parse version from metadata location: %s", new Object[]{metadataLocation});
            return -1;
        }
    }

    protected static List<Column> toHiveColumns(List<Types.NestedField> columns) {
        return (List)columns.stream().map(column -> new Column(column.name(), HiveType.toHiveType((TypeInfo)HiveSchemaUtil.convert((Type)column.type())), Optional.empty())).collect(ImmutableList.toImmutableList());
    }
}

