/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.hms;

import com.google.common.base.Preconditions;
import io.trino.plugin.hive.authentication.HiveIdentity;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.plugin.iceberg.catalog.AbstractMetastoreTableOperations;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.TableNotFoundException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.io.FileIO;

@NotThreadSafe
public class HiveMetastoreTableOperations
extends AbstractMetastoreTableOperations {
    private final ThriftMetastore thriftMetastore;

    public HiveMetastoreTableOperations(FileIO fileIo, HiveMetastore metastore, ThriftMetastore thriftMetastore, ConnectorSession session, String database, String table, Optional<String> owner, Optional<String> location) {
        super(fileIo, metastore, session, database, table, owner, location);
        this.thriftMetastore = Objects.requireNonNull(thriftMetastore, "thriftMetastore is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void commitToExistingTable(TableMetadata base, TableMetadata metadata) {
        String newMetadataLocation = this.writeNewMetadata(metadata, this.version + 1);
        HiveIdentity identity = new HiveIdentity(this.session.getIdentity());
        long lockId = this.thriftMetastore.acquireTableExclusiveLock(identity, this.session.getQueryId(), this.database, this.tableName);
        try {
            Table table;
            try {
                Table currentTable = ThriftMetastoreUtil.fromMetastoreApiTable((org.apache.hadoop.hive.metastore.api.Table)((org.apache.hadoop.hive.metastore.api.Table)this.thriftMetastore.getTable(identity, this.database, this.tableName).orElseThrow(() -> new TableNotFoundException(this.getSchemaTableName()))));
                Preconditions.checkState((this.currentMetadataLocation != null ? 1 : 0) != 0, (Object)"No current metadata location for existing table");
                String metadataLocation = (String)currentTable.getParameters().get("metadata_location");
                if (!this.currentMetadataLocation.equals(metadataLocation)) {
                    throw new CommitFailedException("Metadata location [%s] is not same as table metadata location [%s] for %s", new Object[]{this.currentMetadataLocation, metadataLocation, this.getSchemaTableName()});
                }
                table = Table.builder((Table)currentTable).setDataColumns(HiveMetastoreTableOperations.toHiveColumns(metadata.schema().columns())).withStorage(storage -> storage.setLocation(metadata.location())).setParameter("metadata_location", newMetadataLocation).setParameter("previous_metadata_location", this.currentMetadataLocation).build();
            }
            catch (RuntimeException e) {
                try {
                    this.io().deleteFile(newMetadataLocation);
                }
                catch (RuntimeException ex) {
                    e.addSuppressed(ex);
                }
                throw e;
            }
            PrincipalPrivileges privileges = table.getOwner().map(MetastoreUtil::buildInitialPrivilegeSet).orElse(PrincipalPrivileges.NO_PRIVILEGES);
            this.metastore.replaceTable(this.database, this.tableName, table, privileges);
        }
        finally {
            this.thriftMetastore.releaseTableLock(identity, lockId);
        }
        this.shouldRefresh = true;
    }
}

