/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.hms;

import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastore;
import io.trino.plugin.iceberg.FileIoProvider;
import io.trino.plugin.iceberg.catalog.IcebergTableOperations;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.hms.HiveMetastoreTableOperations;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class HiveMetastoreTableOperationsProvider
implements IcebergTableOperationsProvider {
    private final FileIoProvider fileIoProvider;
    private final ThriftMetastore thriftMetastore;

    @Inject
    public HiveMetastoreTableOperationsProvider(FileIoProvider fileIoProvider, ThriftMetastore thriftMetastore) {
        this.fileIoProvider = Objects.requireNonNull(fileIoProvider, "fileIoProvider is null");
        this.thriftMetastore = Objects.requireNonNull(thriftMetastore, "thriftMetastore is null");
    }

    @Override
    public IcebergTableOperations createTableOperations(HiveMetastore hiveMetastore, ConnectorSession session, String database, String table, Optional<String> owner, Optional<String> location) {
        return new HiveMetastoreTableOperations(this.fileIoProvider.createFileIo(new HdfsEnvironment.HdfsContext(session), session.getQueryId()), hiveMetastore, this.thriftMetastore, session, database, table, owner, location);
    }
}

