/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.util;

import io.trino.spi.block.Block;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;

public final class Timestamps {
    private Timestamps() {
    }

    public static long timestampTzToMicros(LongTimestampWithTimeZone timestamp) {
        return timestamp.getEpochMillis() * 1000L + (long)io.trino.spi.type.Timestamps.roundDiv((int)timestamp.getPicosOfMilli(), (long)1000000L);
    }

    public static LongTimestampWithTimeZone timestampTzFromMicros(long epochMicros) {
        long epochMillis = Math.floorDiv(epochMicros, 1000);
        int picosOfMillis = Math.floorMod(epochMicros, 1000) * 1000000;
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)epochMillis, (int)picosOfMillis, (TimeZoneKey)TimeZoneKey.UTC_KEY);
    }

    public static LongTimestampWithTimeZone getTimestampTz(Block block, int position) {
        return (LongTimestampWithTimeZone)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS.getObject(block, position);
    }
}

