/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.services;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.MethodOverride;
import com.google.api.client.googleapis.batch.BatchCallback;
import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.googleapis.media.MediaHttpDownloader;
import com.google.api.client.googleapis.media.MediaHttpUploader;
import com.google.api.client.googleapis.services.AbstractGoogleClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.EmptyContent;
import com.google.api.client.http.GZipEncoding;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpEncoding;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.UriTemplate;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.Preconditions;
import com.google.common.base.StandardSystemProperty;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractGoogleClientRequest<T>
extends GenericData {
    public static final String USER_AGENT_SUFFIX = "Google-API-Java-Client";
    private static final String API_VERSION_HEADER = "X-Goog-Api-Client";
    private final AbstractGoogleClient abstractGoogleClient;
    private final String requestMethod;
    private final String uriTemplate;
    private final HttpContent httpContent;
    private HttpHeaders requestHeaders = new HttpHeaders();
    private HttpHeaders lastResponseHeaders;
    private int lastStatusCode = -1;
    private String lastStatusMessage;
    private boolean disableGZipContent;
    private boolean returnRawInputStream;
    private Class<T> responseClass;
    private MediaHttpUploader uploader;
    private MediaHttpDownloader downloader;

    protected AbstractGoogleClientRequest(AbstractGoogleClient abstractGoogleClient, String requestMethod, String uriTemplate, HttpContent httpContent, Class<T> responseClass) {
        this.responseClass = (Class)Preconditions.checkNotNull(responseClass);
        this.abstractGoogleClient = (AbstractGoogleClient)Preconditions.checkNotNull((Object)abstractGoogleClient);
        this.requestMethod = (String)Preconditions.checkNotNull((Object)requestMethod);
        this.uriTemplate = (String)Preconditions.checkNotNull((Object)uriTemplate);
        this.httpContent = httpContent;
        String applicationName = abstractGoogleClient.getApplicationName();
        if (applicationName != null) {
            this.requestHeaders.setUserAgent(applicationName + " " + USER_AGENT_SUFFIX);
        } else {
            this.requestHeaders.setUserAgent(USER_AGENT_SUFFIX);
        }
        this.requestHeaders.set(API_VERSION_HEADER, (Object)ApiClientVersion.getDefault().build(abstractGoogleClient.getClass().getSimpleName()));
    }

    public final boolean getDisableGZipContent() {
        return this.disableGZipContent;
    }

    public final boolean getReturnRawInputSteam() {
        return this.returnRawInputStream;
    }

    public AbstractGoogleClientRequest<T> setDisableGZipContent(boolean disableGZipContent) {
        this.disableGZipContent = disableGZipContent;
        return this;
    }

    public AbstractGoogleClientRequest<T> setReturnRawInputStream(boolean returnRawInputStream) {
        this.returnRawInputStream = returnRawInputStream;
        return this;
    }

    public final String getRequestMethod() {
        return this.requestMethod;
    }

    public final String getUriTemplate() {
        return this.uriTemplate;
    }

    public final HttpContent getHttpContent() {
        return this.httpContent;
    }

    public AbstractGoogleClient getAbstractGoogleClient() {
        return this.abstractGoogleClient;
    }

    public final HttpHeaders getRequestHeaders() {
        return this.requestHeaders;
    }

    public AbstractGoogleClientRequest<T> setRequestHeaders(HttpHeaders headers) {
        this.requestHeaders = headers;
        return this;
    }

    public final HttpHeaders getLastResponseHeaders() {
        return this.lastResponseHeaders;
    }

    public final int getLastStatusCode() {
        return this.lastStatusCode;
    }

    public final String getLastStatusMessage() {
        return this.lastStatusMessage;
    }

    public final Class<T> getResponseClass() {
        return this.responseClass;
    }

    public final MediaHttpUploader getMediaHttpUploader() {
        return this.uploader;
    }

    protected final void initializeMediaUpload(AbstractInputStreamContent mediaContent) {
        HttpRequestFactory requestFactory = this.abstractGoogleClient.getRequestFactory();
        this.uploader = new MediaHttpUploader(mediaContent, requestFactory.getTransport(), requestFactory.getInitializer());
        this.uploader.setInitiationRequestMethod(this.requestMethod);
        if (this.httpContent != null) {
            this.uploader.setMetadata(this.httpContent);
        }
    }

    public final MediaHttpDownloader getMediaHttpDownloader() {
        return this.downloader;
    }

    protected final void initializeMediaDownload() {
        HttpRequestFactory requestFactory = this.abstractGoogleClient.getRequestFactory();
        this.downloader = new MediaHttpDownloader(requestFactory.getTransport(), requestFactory.getInitializer());
    }

    public GenericUrl buildHttpRequestUrl() {
        return new GenericUrl(UriTemplate.expand((String)this.abstractGoogleClient.getBaseUrl(), (String)this.uriTemplate, (Object)((Object)this), (boolean)true));
    }

    public HttpRequest buildHttpRequest() throws IOException {
        return this.buildHttpRequest(false);
    }

    protected HttpRequest buildHttpRequestUsingHead() throws IOException {
        return this.buildHttpRequest(true);
    }

    private HttpRequest buildHttpRequest(boolean usingHead) throws IOException {
        Preconditions.checkArgument((this.uploader == null ? 1 : 0) != 0);
        Preconditions.checkArgument((!usingHead || this.requestMethod.equals("GET") ? 1 : 0) != 0);
        String requestMethodToUse = usingHead ? "HEAD" : this.requestMethod;
        final HttpRequest httpRequest = this.getAbstractGoogleClient().getRequestFactory().buildRequest(requestMethodToUse, this.buildHttpRequestUrl(), this.httpContent);
        new MethodOverride().intercept(httpRequest);
        httpRequest.setParser(this.getAbstractGoogleClient().getObjectParser());
        if (this.httpContent == null && (this.requestMethod.equals("POST") || this.requestMethod.equals("PUT") || this.requestMethod.equals("PATCH"))) {
            httpRequest.setContent((HttpContent)new EmptyContent());
        }
        httpRequest.getHeaders().putAll((Map)this.requestHeaders);
        if (!this.disableGZipContent) {
            httpRequest.setEncoding((HttpEncoding)new GZipEncoding());
        }
        httpRequest.setResponseReturnRawInputStream(this.returnRawInputStream);
        final HttpResponseInterceptor responseInterceptor = httpRequest.getResponseInterceptor();
        httpRequest.setResponseInterceptor(new HttpResponseInterceptor(){

            public void interceptResponse(HttpResponse response) throws IOException {
                if (responseInterceptor != null) {
                    responseInterceptor.interceptResponse(response);
                }
                if (!response.isSuccessStatusCode() && httpRequest.getThrowExceptionOnExecuteError()) {
                    throw AbstractGoogleClientRequest.this.newExceptionOnError(response);
                }
            }
        });
        return httpRequest;
    }

    public HttpResponse executeUnparsed() throws IOException {
        return this.executeUnparsed(false);
    }

    protected HttpResponse executeMedia() throws IOException {
        this.set("alt", "media");
        return this.executeUnparsed();
    }

    protected HttpResponse executeUsingHead() throws IOException {
        Preconditions.checkArgument((this.uploader == null ? 1 : 0) != 0);
        HttpResponse response = this.executeUnparsed(true);
        response.ignore();
        return response;
    }

    private HttpResponse executeUnparsed(boolean usingHead) throws IOException {
        HttpResponse response;
        if (this.uploader == null) {
            response = this.buildHttpRequest(usingHead).execute();
        } else {
            GenericUrl httpRequestUrl = this.buildHttpRequestUrl();
            HttpRequest httpRequest = this.getAbstractGoogleClient().getRequestFactory().buildRequest(this.requestMethod, httpRequestUrl, this.httpContent);
            boolean throwExceptionOnExecuteError = httpRequest.getThrowExceptionOnExecuteError();
            response = this.uploader.setInitiationHeaders(this.requestHeaders).setDisableGZipContent(this.disableGZipContent).upload(httpRequestUrl);
            response.getRequest().setParser(this.getAbstractGoogleClient().getObjectParser());
            if (throwExceptionOnExecuteError && !response.isSuccessStatusCode()) {
                throw this.newExceptionOnError(response);
            }
        }
        this.lastResponseHeaders = response.getHeaders();
        this.lastStatusCode = response.getStatusCode();
        this.lastStatusMessage = response.getStatusMessage();
        return response;
    }

    protected IOException newExceptionOnError(HttpResponse response) {
        return new HttpResponseException(response);
    }

    public T execute() throws IOException {
        return (T)this.executeUnparsed().parseAs(this.responseClass);
    }

    public InputStream executeAsInputStream() throws IOException {
        return this.executeUnparsed().getContent();
    }

    protected InputStream executeMediaAsInputStream() throws IOException {
        return this.executeMedia().getContent();
    }

    public void executeAndDownloadTo(OutputStream outputStream) throws IOException {
        this.executeUnparsed().download(outputStream);
    }

    protected void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
        if (this.downloader == null) {
            this.executeMedia().download(outputStream);
        } else {
            this.downloader.download(this.buildHttpRequestUrl(), this.requestHeaders, outputStream);
        }
    }

    public final <E> void queue(BatchRequest batchRequest, Class<E> errorClass, BatchCallback<T, E> callback) throws IOException {
        Preconditions.checkArgument((this.uploader == null ? 1 : 0) != 0, (Object)"Batching media requests is not supported");
        batchRequest.queue(this.buildHttpRequest(), this.getResponseClass(), errorClass, callback);
    }

    public AbstractGoogleClientRequest<T> set(String fieldName, Object value) {
        return (AbstractGoogleClientRequest)super.set(fieldName, value);
    }

    protected final void checkRequiredParameter(Object value, String name) {
        Preconditions.checkArgument((this.abstractGoogleClient.getSuppressRequiredParameterChecks() || value != null ? 1 : 0) != 0, (String)"Required parameter %s must be specified", (Object[])new Object[]{name});
    }

    static class ApiClientVersion {
        private static final ApiClientVersion DEFAULT_VERSION = new ApiClientVersion();
        private final String headerTemplate;

        ApiClientVersion() {
            this(ApiClientVersion.getJavaVersion(), StandardSystemProperty.OS_NAME.value(), StandardSystemProperty.OS_VERSION.value(), GoogleUtils.VERSION);
        }

        ApiClientVersion(String javaVersion, String osName, String osVersion, String clientVersion) {
            StringBuilder sb = new StringBuilder("java/");
            sb.append(ApiClientVersion.formatSemver(javaVersion));
            sb.append(" http-google-%s/");
            sb.append(ApiClientVersion.formatSemver(clientVersion));
            if (osName != null && osVersion != null) {
                sb.append(" ");
                sb.append(ApiClientVersion.formatName(osName));
                sb.append("/");
                sb.append(ApiClientVersion.formatSemver(osVersion));
            }
            this.headerTemplate = sb.toString();
        }

        String build(String clientName) {
            return String.format(this.headerTemplate, ApiClientVersion.formatName(clientName));
        }

        private static ApiClientVersion getDefault() {
            return DEFAULT_VERSION;
        }

        private static String getJavaVersion() {
            String version = System.getProperty("java.version");
            if (version == null) {
                return null;
            }
            String formatted = ApiClientVersion.formatSemver(version, null);
            if (formatted != null) {
                return formatted;
            }
            Matcher m = Pattern.compile("^(\\d+)[^\\d]?").matcher(version);
            if (m.find()) {
                return m.group(1) + ".0.0";
            }
            return null;
        }

        private static String formatName(String name) {
            return name.toLowerCase().replaceAll("[^\\w\\d\\-]", "-");
        }

        private static String formatSemver(String version) {
            return ApiClientVersion.formatSemver(version, version);
        }

        private static String formatSemver(String version, String defaultValue) {
            if (version == null) {
                return null;
            }
            Matcher m = Pattern.compile("(\\d+\\.\\d+\\.\\d+).*").matcher(version);
            if (m.find()) {
                return m.group(1);
            }
            return defaultValue;
        }
    }
}

