/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.pipeline;

import org.apache.helix.common.DedupEventProcessor;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.AsyncWorkerType;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAsyncBaseStage
extends AbstractBaseStage {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAsyncBaseStage.class);

    @Override
    public void process(final ClusterEvent event) throws Exception {
        String pipelineType = (String)event.getAttribute(AttributeName.PipelineType.name());
        final String taskType = this.getAsyncTaskDedupType(pipelineType);
        DedupEventProcessor<String, Runnable> worker = this.getAsyncWorkerFromClusterEvent(event, this.getAsyncWorkerType());
        if (worker == null) {
            throw new StageException("No async worker found for " + taskType);
        }
        worker.queueEvent(taskType, new Runnable(){

            @Override
            public void run() {
                long startTimestamp = System.currentTimeMillis();
                logger.info("START AsyncProcess: {}", (Object)taskType);
                try {
                    AbstractAsyncBaseStage.this.execute(event);
                }
                catch (Exception e) {
                    logger.error("Failed to process {} asynchronously", (Object)taskType, (Object)e);
                }
                long endTimestamp = System.currentTimeMillis();
                logger.info("END AsyncProcess: {}, took {} ms", (Object)taskType, (Object)(endTimestamp - startTimestamp));
            }
        });
        logger.info("Submitted asynchronous {} task to worker", (Object)taskType);
    }

    public abstract AsyncWorkerType getAsyncWorkerType();

    public abstract void execute(ClusterEvent var1) throws Exception;

    private String getAsyncTaskDedupType(String pipelineType) {
        return String.format("%s::%s", pipelineType, this.getClass().getSimpleName());
    }
}

