/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk.zookeeper;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.I0Itec.zkclient.IZkConnection;
import org.I0Itec.zkclient.exception.ZkException;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class ZkConnection
implements IZkConnection {
    private static final Logger LOG = Logger.getLogger(ZkConnection.class);
    private static final int DEFAULT_SESSION_TIMEOUT = 30000;
    private ZooKeeper _zk = null;
    private Lock _zookeeperLock = new ReentrantLock();
    private final String _servers;
    private final int _sessionTimeOut;

    public ZkConnection(String zkServers) {
        this(zkServers, 30000);
    }

    public ZkConnection(String zkServers, int sessionTimeOut) {
        this._servers = zkServers;
        this._sessionTimeOut = sessionTimeOut;
    }

    public void connect(Watcher watcher) {
        this._zookeeperLock.lock();
        try {
            if (this._zk != null) {
                throw new IllegalStateException("zk client has already been started");
            }
            try {
                LOG.debug((Object)("Creating new ZookKeeper instance to connect to " + this._servers + "."));
                this._zk = new ZooKeeper(this._servers, this._sessionTimeOut, watcher);
            }
            catch (IOException e) {
                throw new ZkException("Unable to connect to " + this._servers, (Throwable)e);
            }
        }
        finally {
            this._zookeeperLock.unlock();
        }
    }

    public void close() throws InterruptedException {
        this._zookeeperLock.lock();
        try {
            if (this._zk != null) {
                LOG.debug((Object)("Closing ZooKeeper connected to " + this._servers));
                this._zk.close();
                this._zk = null;
            }
        }
        finally {
            this._zookeeperLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reconnect(Watcher watcher) throws InterruptedException {
        this._zookeeperLock.lock();
        try {
            if (this._zk == null) {
                throw new IllegalStateException("zk client has not been connected or already been closed");
            }
            ZooKeeper prevZk = this._zk;
            try {
                LOG.debug((Object)("Creating new ZookKeeper instance to reconnect to " + this._servers + "."));
                this._zk = new ZooKeeper(this._servers, this._sessionTimeOut, watcher);
                prevZk.close();
            }
            catch (IOException e) {
                throw new ZkException("Unable to connect to " + this._servers, (Throwable)e);
            }
        }
        finally {
            this._zookeeperLock.unlock();
        }
    }

    public String create(String path, byte[] data, CreateMode mode) throws KeeperException, InterruptedException {
        return this._zk.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, mode);
    }

    public String create(String path, byte[] data, List<ACL> acl, CreateMode mode) throws KeeperException, InterruptedException {
        return this._zk.create(path, data, acl, mode);
    }

    public void delete(String path) throws InterruptedException, KeeperException {
        this._zk.delete(path, -1);
    }

    public boolean exists(String path, boolean watch) throws KeeperException, InterruptedException {
        return this._zk.exists(path, watch) != null;
    }

    public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        return this._zk.getChildren(path, watch);
    }

    public byte[] readData(String path, Stat stat, boolean watch) throws KeeperException, InterruptedException {
        return this._zk.getData(path, watch, stat);
    }

    public void writeData(String path, byte[] data) throws KeeperException, InterruptedException {
        this.writeData(path, data, -1);
    }

    public void writeData(String path, byte[] data, int version) throws KeeperException, InterruptedException {
        this._zk.setData(path, data, version);
    }

    public Stat writeDataReturnStat(String path, byte[] data, int version) throws KeeperException, InterruptedException {
        return this._zk.setData(path, data, version);
    }

    public ZooKeeper.States getZookeeperState() {
        return this._zk != null ? this._zk.getState() : null;
    }

    public ZooKeeper getZookeeper() {
        return this._zk;
    }

    public long getCreateTime(String path) throws KeeperException, InterruptedException {
        Stat stat = this._zk.exists(path, false);
        if (stat != null) {
            return stat.getCtime();
        }
        return -1L;
    }

    public String getServers() {
        return this._servers;
    }

    public List<OpResult> multi(Iterable<Op> ops) throws KeeperException, InterruptedException {
        return this._zk.multi(ops);
    }

    public void addAuthInfo(String scheme, byte[] auth) {
        this._zk.addAuthInfo(scheme, auth);
    }
}

