/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.helix.ZNRecord;
import org.apache.helix.model.IdealState;

public class IdealCalculatorByConsistentHashing {
    public static ZNRecord calculateIdealState(List<String> instanceNames, int partitions, int replicas, String resourceName, HashFunction hashFunc) {
        return IdealCalculatorByConsistentHashing.calculateIdealState(instanceNames, partitions, replicas, resourceName, hashFunc, 65536);
    }

    public static ZNRecord calculateIdealState(List<String> instanceNames, int partitions, int replicas, String resourceName, HashFunction hashFunc, int hashRingSize) {
        ZNRecord result = new ZNRecord(resourceName);
        int[] hashRing = IdealCalculatorByConsistentHashing.generateEvenHashRing(instanceNames, hashRingSize);
        result.setSimpleField(IdealState.IdealStateProperty.NUM_PARTITIONS.toString(), String.valueOf(partitions));
        Random rand = new Random(12648430L);
        for (int i = 0; i < partitions; ++i) {
            String partitionName = resourceName + ".partition-" + i;
            int hashPos = rand.nextInt() % hashRingSize;
            hashPos = hashPos < 0 ? hashPos + hashRingSize : hashPos;
            TreeMap<String, String> partitionAssignment = new TreeMap<String, String>();
            int masterPos = hashRing[hashPos];
            partitionAssignment.put(instanceNames.get(masterPos), "MASTER");
            for (int j = 1; j <= replicas; ++j) {
                String next = instanceNames.get(hashRing[(hashPos + j) % hashRingSize]);
                while (partitionAssignment.containsKey(next)) {
                    next = instanceNames.get(hashRing[(++hashPos + j) % hashRingSize]);
                }
                partitionAssignment.put(next, "SLAVE");
            }
            result.setMapField(partitionName, partitionAssignment);
        }
        return result;
    }

    public static int[] generateHashRing(List<String> instanceNames, int hashRingSize) {
        int[] result = new int[hashRingSize];
        for (int i = 0; i < result.length; ++i) {
            result[i] = 0;
        }
        int instances = instanceNames.size();
        for (int i = 1; i < instances; ++i) {
            IdealCalculatorByConsistentHashing.putNodeOnHashring(result, i, hashRingSize / (i + 1), i);
        }
        return result;
    }

    public static int[] generateEvenHashRing(List<String> instanceNames, int hashRingSize) {
        int[] result = new int[hashRingSize];
        for (int i = 0; i < result.length; ++i) {
            result[i] = 0;
        }
        int instances = instanceNames.size();
        for (int i = 1; i < instances; ++i) {
            IdealCalculatorByConsistentHashing.putNodeEvenOnHashRing(result, i, i + 1);
        }
        return result;
    }

    private static void putNodeEvenOnHashRing(int[] hashRing, int nodeVal, int totalValues) {
        int newValNum = hashRing.length / totalValues;
        assert (newValNum > 0);
        Map<Integer, List<Integer>> valueIndex = IdealCalculatorByConsistentHashing.buildValueIndex(hashRing);
        int nSources = valueIndex.size();
        int remainder = newValNum % nSources;
        ArrayList<List<Integer>> positionLists = new ArrayList<List<Integer>>();
        for (List<Integer> list : valueIndex.values()) {
            positionLists.add(list);
        }
        class ListComparator
        implements Comparator<List<Integer>> {
            ListComparator() {
            }

            @Override
            public int compare(List<Integer> o1, List<Integer> o2) {
                return o1.size() > o2.size() ? -1 : (o1.size() == o2.size() ? 0 : 1);
            }
        }
        Collections.sort(positionLists, new ListComparator());
        for (List<Integer> oldValPositions : positionLists) {
            int nValsToReplace = newValNum / nSources;
            assert (nValsToReplace > 0);
            if (remainder > 0) {
                ++nValsToReplace;
                --remainder;
            }
            IdealCalculatorByConsistentHashing.putNodeValueOnHashRing(hashRing, nodeVal, nValsToReplace, oldValPositions);
        }
    }

    private static void putNodeValueOnHashRing(int[] hashRing, int nodeVal, int numberOfValues, List<Integer> positions) {
        Random rand = new Random(nodeVal);
        int[] index = new int[positions.size()];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        int nodesLeft = index.length;
        for (int i = 0; i < numberOfValues; ++i) {
            int randIndex = rand.nextInt() % nodesLeft;
            if (randIndex < 0) {
                randIndex += nodesLeft;
            }
            hashRing[positions.get((int)index[randIndex]).intValue()] = nodeVal;
            int temp = index[randIndex];
            index[randIndex] = index[nodesLeft - 1];
            index[nodesLeft - 1] = temp;
            --nodesLeft;
        }
    }

    private static Map<Integer, List<Integer>> buildValueIndex(int[] hashRing) {
        TreeMap<Integer, List<Integer>> result = new TreeMap<Integer, List<Integer>>();
        for (int i = 0; i < hashRing.length; ++i) {
            if (!result.containsKey(hashRing[i])) {
                ArrayList list = new ArrayList();
                result.put(hashRing[i], list);
            }
            ((List)result.get(hashRing[i])).add(i);
        }
        return result;
    }

    public static void putNodeOnHashring(int[] result, int nodeValue, int numberOfNodes, int randomSeed) {
        Random rand = new Random(randomSeed);
        int[] index = new int[result.length];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        int nodesLeft = index.length;
        for (int i = 0; i < numberOfNodes; ++i) {
            int randIndex = rand.nextInt() % nodesLeft;
            if (randIndex < 0) {
                randIndex += nodesLeft;
            }
            if (result[index[randIndex]] == nodeValue) assert (false);
            result[index[randIndex]] = nodeValue;
            int temp = index[randIndex];
            index[randIndex] = index[nodesLeft - 1];
            index[nodesLeft - 1] = temp;
            --nodesLeft;
        }
    }

    public static void printDiff(ZNRecord record1, ZNRecord record2) {
        int diffCount = 0;
        for (String key : record1.getMapFields().keySet()) {
            Map<String, String> map1 = record1.getMapField(key);
            Map<String, String> map2 = record2.getMapField(key);
            for (String k : map1.keySet()) {
                if (!map2.containsKey(k)) {
                    ++diffCount;
                    continue;
                }
                if (map1.get(k).equalsIgnoreCase(map2.get(k))) continue;
                ++diffCount;
            }
        }
        System.out.println("diff count = " + diffCount);
    }

    public static void compareHashrings(int[] ring1, int[] ring2) {
        int diff = 0;
        for (int i = 0; i < ring1.length; ++i) {
            if (ring1[i] == ring2[i]) continue;
            ++diff;
        }
        System.out.println("ring diff: " + diff);
    }

    public static void printNodeOfflineOverhead(ZNRecord record) {
        TreeMap nodeNextMap = new TreeMap();
        for (String partitionName : record.getMapFields().keySet()) {
            Map<String, String> map1 = record.getMapField(partitionName);
            String master = "";
            String slave = "";
            for (String nodeName : map1.keySet()) {
                if (!nodeNextMap.containsKey(nodeName)) {
                    nodeNextMap.put(nodeName, new TreeSet());
                }
                if (map1.get(nodeName).equalsIgnoreCase("MASTER")) {
                    master = nodeName;
                    continue;
                }
                if (!slave.equalsIgnoreCase("")) continue;
                slave = nodeName;
            }
            ((Set)nodeNextMap.get(master)).add(slave);
        }
        System.out.println("next count: ");
        for (String key : nodeNextMap.keySet()) {
            System.out.println(((Set)nodeNextMap.get(key)).size() + " ");
        }
        System.out.println();
    }

    public static void printIdealStateStats(ZNRecord record, String value) {
        TreeMap<String, Integer> countsMap = new TreeMap<String, Integer>();
        for (String key : record.getMapFields().keySet()) {
            Map<String, String> map1 = record.getMapField(key);
            for (String string : map1.keySet()) {
                if (!countsMap.containsKey(string)) {
                    countsMap.put(string, new Integer(0));
                }
                if (!value.equals("") && !map1.get(string).equalsIgnoreCase(value)) continue;
                countsMap.put(string, (Integer)countsMap.get(string) + 1);
            }
        }
        double sum = 0.0;
        int maxCount = 0;
        int minCount = Integer.MAX_VALUE;
        System.out.println("Partition distributions: ");
        for (String k : countsMap.keySet()) {
            int count = (Integer)countsMap.get(k);
            sum += (double)count;
            if (maxCount < count) {
                maxCount = count;
            }
            if (minCount > count) {
                minCount = count;
            }
            System.out.print(count + " ");
        }
        System.out.println();
        double d = sum / (double)countsMap.size();
        double deviation = 0.0;
        for (String k : countsMap.keySet()) {
            double count = ((Integer)countsMap.get(k)).intValue();
            deviation += (count - d) * (count - d);
        }
        System.out.println("Mean: " + d + " normal deviation:" + Math.sqrt(deviation / (double)countsMap.size()));
        System.out.println("Max count: " + maxCount + " min count:" + minCount);
    }

    public static void printHashRingStat(int[] hashRing) {
        int count;
        double sum = 0.0;
        double mean = 0.0;
        double deviation = 0.0;
        TreeMap<Integer, Integer> countsMap = new TreeMap<Integer, Integer>();
        for (int i = 0; i < hashRing.length; ++i) {
            if (!countsMap.containsKey(hashRing[i])) {
                countsMap.put(hashRing[i], new Integer(0));
            }
            countsMap.put(hashRing[i], (Integer)countsMap.get(hashRing[i]) + 1);
        }
        int maxCount = Integer.MIN_VALUE;
        int minCount = Integer.MAX_VALUE;
        for (Integer k : countsMap.keySet()) {
            count = (Integer)countsMap.get(k);
            sum += (double)count;
            if (maxCount < count) {
                maxCount = count;
            }
            if (minCount <= count) continue;
            minCount = count;
        }
        mean = sum / (double)countsMap.size();
        for (Integer k : countsMap.keySet()) {
            count = (Integer)countsMap.get(k);
            deviation += ((double)count - mean) * ((double)count - mean);
        }
        System.out.println("hashring Mean: " + mean + " normal deviation:" + Math.sqrt(deviation / (double)countsMap.size()));
    }

    static int[] getFnvHashArray(List<String> strings) {
        int[] result = new int[strings.size()];
        int i = 0;
        FnvHash hashfunc = new FnvHash();
        for (String s : strings) {
            int val = hashfunc.getHashValue(s) % 65536;
            if (val < 0) {
                val += 65536;
            }
            result[i++] = val;
        }
        return result;
    }

    static void printArrayStat(int[] vals) {
        int i;
        double sum = 0.0;
        double mean = 0.0;
        double deviation = 0.0;
        for (i = 0; i < vals.length; ++i) {
            sum += (double)vals[i];
        }
        mean = sum / (double)vals.length;
        for (i = 0; i < vals.length; ++i) {
            deviation += (mean - (double)vals[i]) * (mean - (double)vals[i]);
        }
        System.out.println("normalized deviation: " + Math.sqrt(deviation / (double)vals.length) / mean);
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> instanceNames = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            instanceNames.add("localhost_123" + i);
        }
        int partitions = 200;
        int replicas = 2;
        String dbName = "espressoDB1";
        ZNRecord result = IdealCalculatorByConsistentHashing.calculateIdealState(instanceNames, partitions, replicas, dbName, new FnvHash());
        System.out.println("\nMaster :");
        IdealCalculatorByConsistentHashing.printIdealStateStats(result, "MASTER");
        System.out.println("\nSlave :");
        IdealCalculatorByConsistentHashing.printIdealStateStats(result, "SLAVE");
        System.out.println("\nTotal :");
        IdealCalculatorByConsistentHashing.printIdealStateStats(result, "");
        IdealCalculatorByConsistentHashing.printNodeOfflineOverhead(result);
    }

    public static class FnvHash
    implements HashFunction {
        private static final long FNV_BASIS = -2128831035L;
        private static final long FNV_PRIME = 16777619L;
        public static final long FNV_BASIS_64 = -3750763034362895579L;
        public static final long FNV_PRIME_64 = 1099511628211L;

        public int hash(byte[] key) {
            long hash = -2128831035L;
            for (int i = 0; i < key.length; ++i) {
                hash ^= (long)(0xFF & key[i]);
                hash *= 16777619L;
            }
            return (int)hash;
        }

        public long hash64(long val) {
            long hashval = -3750763034362895579L;
            for (int i = 0; i < 8; ++i) {
                long octet = val & 0xFFL;
                val >>= 8;
                hashval ^= octet;
                hashval *= 1099511628211L;
            }
            return Math.abs(hashval);
        }

        @Override
        public int getHashValue(String key) {
            return this.hash(key.getBytes());
        }
    }

    public static interface HashFunction {
        public int getHashValue(String var1);
    }
}

