/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.MetaStorePreEventListener;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.PreDropTableEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;

public class MetaDataExportListener
extends MetaStorePreEventListener {
    public static final Logger LOG = LoggerFactory.getLogger(MetaDataExportListener.class);

    public MetaDataExportListener(Configuration config) {
        super(config);
    }

    private void export_meta_data(PreDropTableEvent tableEvent) throws MetaException {
        FileSystem fs = null;
        org.apache.hadoop.hive.metastore.api.Table tbl = tableEvent.getTable();
        String name = tbl.getTableName();
        Table mTbl = new Table(tbl);
        IHMSHandler handler = tableEvent.getHandler();
        Configuration conf = handler.getConf();
        Warehouse wh = new Warehouse(conf);
        Path tblPath = new Path(tbl.getSd().getLocation());
        fs = wh.getFs(tblPath);
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        String dateString = sdf.format(now);
        String exportPathString = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.METADATA_EXPORT_LOCATION);
        boolean moveMetadataToTrash = MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.MOVE_EXPORTED_METADATA_TO_TRASH);
        Path exportPath = null;
        exportPath = exportPathString != null && exportPathString.length() == 0 ? fs.getHomeDirectory() : new Path(exportPathString);
        Path metaPath = new Path(exportPath, name + "." + dateString);
        LOG.info("Exporting the metadata of table " + tbl.toString() + " to path " + metaPath.toString());
        try {
            fs.mkdirs(metaPath);
        }
        catch (IOException e) {
            throw new MetaException(e.getMessage());
        }
        Path outFile = new Path(metaPath, name + "_metadata");
        try {
            SessionState.getConsole().printInfo("Beginning metadata export");
            EximUtil.createExportDump(fs, outFile, mTbl, null, null, new HiveConf(conf, MetaDataExportListener.class));
            if (moveMetadataToTrash) {
                wh.deleteDir(metaPath, true, false, false);
            }
        }
        catch (IOException | SemanticException e) {
            throw new MetaException(e.getMessage());
        }
    }

    @Override
    public void onEvent(PreEventContext context) throws MetaException, NoSuchObjectException, InvalidOperationException {
        if (context.getEventType() == PreEventContext.PreEventType.DROP_TABLE) {
            this.export_meta_data((PreDropTableEvent)context);
        }
    }
}

