/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kinesis;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"kinesis.checkpoint-interval"})
public class KinesisConfig {
    private String defaultSchema = "default";
    private String tableDescriptionLocation = "etc/kinesis/";
    private Duration tableDescriptionRefreshInterval = new Duration(10.0, TimeUnit.MINUTES);
    private boolean hideInternalColumns = true;
    private String awsRegion = "us-east-1";
    private int batchSize = 10000;
    private int maxBatches = 600;
    private int fetchAttempts = 2;
    private Duration sleepTime = new Duration(1000.0, TimeUnit.MILLISECONDS);
    private boolean isIteratorFromTimestamp = true;
    private long iteratorOffsetSeconds = 86400L;
    private String accessKey;
    private String secretKey;
    private boolean logKinesisBatches = true;
    private boolean checkpointEnabled;
    private long dynamoReadCapacity = 50L;
    private long dynamoWriteCapacity = 10L;
    private String logicalProcessName = "process1";
    private int iteratorNumber;

    @NotNull
    public String getTableDescriptionLocation() {
        return this.tableDescriptionLocation;
    }

    @Config(value="kinesis.table-description-location")
    @ConfigDescription(value="S3 or local filesystem directory location where table schema descriptions are present")
    public KinesisConfig setTableDescriptionLocation(String tableDescriptionLocation) {
        this.tableDescriptionLocation = tableDescriptionLocation;
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public @NotNull @MinDuration(value="1ms") Duration getTableDescriptionRefreshInterval() {
        return this.tableDescriptionRefreshInterval;
    }

    @Config(value="kinesis.table-description-refresh-interval")
    @ConfigDescription(value="How often to get the table description from S3")
    public KinesisConfig setTableDescriptionRefreshInterval(Duration tableDescriptionRefreshInterval) {
        this.tableDescriptionRefreshInterval = tableDescriptionRefreshInterval;
        return this;
    }

    public boolean isHideInternalColumns() {
        return this.hideInternalColumns;
    }

    @Config(value="kinesis.hide-internal-columns")
    @ConfigDescription(value="Toggle to decide whether to show Kinesis internal columns or not")
    public KinesisConfig setHideInternalColumns(boolean hideInternalColumns) {
        this.hideInternalColumns = hideInternalColumns;
        return this;
    }

    @NotNull
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    @Config(value="kinesis.default-schema")
    @ConfigDescription(value="Sets default schema for kinesis catalogs")
    public KinesisConfig setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
        return this;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    @Config(value="kinesis.access-key")
    @ConfigDescription(value="S3 Access Key to access s3 locations")
    public KinesisConfig setAccessKey(String accessKey) {
        this.accessKey = accessKey;
        return this;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    @Config(value="kinesis.secret-key")
    @ConfigDescription(value="S3 Secret Key to access s3 locations")
    public KinesisConfig setSecretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    public String getAwsRegion() {
        return this.awsRegion;
    }

    @Config(value="kinesis.aws-region")
    @ConfigDescription(value="Region to set while creating S3 client")
    public KinesisConfig setAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
        return this;
    }

    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    public @Min(value=1L) @Max(value=0x7FFFFFFFL) int getBatchSize() {
        return this.batchSize;
    }

    @Config(value="kinesis.batch-size")
    @ConfigDescription(value="Limit maximum number of rows to return in a batch")
    public KinesisConfig setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxBatches() {
        return this.maxBatches;
    }

    @Config(value="kinesis.max-batches")
    @ConfigDescription(value="Maximum number of calls to Kinesis per query")
    public KinesisConfig setMaxBatches(int maxBatches) {
        this.maxBatches = maxBatches;
        return this;
    }

    @Min(value=1L)
    @Max(value=1000L)
    public @Min(value=1L) @Max(value=1000L) int getFetchAttempts() {
        return this.fetchAttempts;
    }

    @Config(value="kinesis.fetch-attempts")
    @ConfigDescription(value="Maximum number of attempts to fetch the next batch from a shard iterator")
    public KinesisConfig setFetchAttempts(int fetchAttempts) {
        this.fetchAttempts = fetchAttempts;
        return this;
    }

    public Duration getSleepTime() {
        return this.sleepTime;
    }

    @Config(value="kinesis.sleep-time")
    @ConfigDescription(value="Sleep time between fetch attempt retries")
    public KinesisConfig setSleepTime(Duration sleepTime) {
        this.sleepTime = sleepTime;
        return this;
    }

    public boolean isLogBatches() {
        return this.logKinesisBatches;
    }

    @Config(value="kinesis.log-batches")
    @ConfigDescription(value="Decides whether to log batch fetch details")
    public KinesisConfig setLogBatches(boolean logBatches) {
        this.logKinesisBatches = logBatches;
        return this;
    }

    public boolean isIteratorFromTimestamp() {
        return this.isIteratorFromTimestamp;
    }

    @Config(value="kinesis.iterator-from-timestamp")
    @ConfigDescription(value="Whether to use start timestamp from shard iterator")
    public KinesisConfig setIteratorFromTimestamp(boolean isIteratorFromTimestamp) {
        this.isIteratorFromTimestamp = isIteratorFromTimestamp;
        return this;
    }

    public long getIteratorOffsetSeconds() {
        return this.iteratorOffsetSeconds;
    }

    @Config(value="kinesis.iterator-offset-seconds")
    @ConfigDescription(value="Seconds before current time to start fetching records from")
    public KinesisConfig setIteratorOffsetSeconds(long iteratorOffsetSeconds) {
        this.iteratorOffsetSeconds = iteratorOffsetSeconds;
        return this;
    }

    public boolean isCheckpointEnabled() {
        return this.checkpointEnabled;
    }

    @Config(value="kinesis.checkpoint-enabled")
    @ConfigDescription(value="Whether to remember last read sequence number and use it in later requests")
    public KinesisConfig setCheckpointEnabled(boolean checkpointEnabled) {
        this.checkpointEnabled = checkpointEnabled;
        return this;
    }

    public long getDynamoReadCapacity() {
        return this.dynamoReadCapacity;
    }

    @Config(value="kinesis.dynamo-read-capacity")
    @ConfigDescription(value="DynamoDB read capacity to be set in client")
    public KinesisConfig setDynamoReadCapacity(long dynamoReadCapacity) {
        this.dynamoReadCapacity = dynamoReadCapacity;
        return this;
    }

    public long getDynamoWriteCapacity() {
        return this.dynamoWriteCapacity;
    }

    @Config(value="kinesis.dynamo-write-capacity")
    @ConfigDescription(value="DynamoDB read capacity to be set in client")
    public KinesisConfig setDynamoWriteCapacity(long dynamoWriteCapacity) {
        this.dynamoWriteCapacity = dynamoWriteCapacity;
        return this;
    }

    public String getLogicalProcessName() {
        return this.logicalProcessName;
    }

    @Config(value="kinesis.checkpoint-logical-name")
    @ConfigDescription(value="Prefix to the checkpoint name")
    public KinesisConfig setLogicalProcessName(String logicalPrcessName) {
        this.logicalProcessName = logicalPrcessName;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getIteratorNumber() {
        return this.iteratorNumber;
    }

    @Config(value="kinesis.iterator-number")
    @ConfigDescription(value="Checkpoint iteration number")
    public KinesisConfig setIteratorNumber(int iteratorNumber) {
        this.iteratorNumber = iteratorNumber;
        return this;
    }
}

