/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kinesis;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.trino.plugin.kinesis.KinesisStreamFieldGroup;
import java.util.Objects;

public class KinesisStreamDescription {
    private final String tableName;
    private final String streamName;
    private final String schemaName;
    private final KinesisStreamFieldGroup message;

    @JsonCreator
    public KinesisStreamDescription(@JsonProperty(value="tableName") String tableName, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="streamName") String streamName, @JsonProperty(value="message") KinesisStreamFieldGroup message) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableName) ? 1 : 0) != 0, (Object)"tableName is null or is empty");
        this.tableName = tableName;
        this.streamName = Objects.requireNonNull(streamName, "streamName is null");
        this.schemaName = schemaName;
        this.message = message;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getStreamName() {
        return this.streamName;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public KinesisStreamFieldGroup getMessage() {
        return this.message;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("streamName", (Object)this.streamName).add("schemaName", (Object)this.schemaName).add("message", (Object)this.message).toString();
    }
}

