/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.oracle;

import io.airlift.units.Duration;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.spi.connector.ConnectorSession;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import oracle.jdbc.pool.OracleDataSource;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceFactory;

public class OraclePoolConnectionFactory
implements ConnectionFactory {
    private final PoolDataSource dataSource = PoolDataSourceFactory.getPoolDataSource();

    public OraclePoolConnectionFactory(String connectionUrl, Properties connectionProperties, CredentialProvider credentialProvider, int connectionPoolMinSize, int connectionPoolMaxSize, Duration inactiveConnectionTimeout) throws SQLException {
        this.dataSource.setConnectionFactoryClassName(OracleDataSource.class.getName());
        this.dataSource.setURL(connectionUrl);
        this.dataSource.setInitialPoolSize(connectionPoolMinSize);
        this.dataSource.setMinPoolSize(connectionPoolMinSize);
        this.dataSource.setMaxPoolSize(connectionPoolMaxSize);
        this.dataSource.setValidateConnectionOnBorrow(true);
        this.dataSource.setConnectionProperties(connectionProperties);
        this.dataSource.setInactiveConnectionTimeout(Math.toIntExact(inactiveConnectionTimeout.roundTo(TimeUnit.SECONDS)));
        credentialProvider.getConnectionUser(Optional.empty()).ifPresent(user -> {
            try {
                this.dataSource.setUser(user);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
        credentialProvider.getConnectionPassword(Optional.empty()).ifPresent(password -> {
            try {
                this.dataSource.setPassword(password);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public Connection openConnection(ConnectorSession session) throws SQLException {
        Connection connection = this.dataSource.getConnection();
        connection.setAutoCommit(true);
        return connection;
    }
}

