/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.creator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.creator.name.FixedSegmentNameGenerator;
import org.apache.pinot.segment.spi.creator.name.SegmentNameGenerator;
import org.apache.pinot.segment.spi.creator.name.SimpleSegmentNameGenerator;
import org.apache.pinot.segment.spi.index.creator.H3IndexConfig;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.IndexingConfig;
import org.apache.pinot.spi.config.table.SegmentPartitionConfig;
import org.apache.pinot.spi.config.table.StarTreeIndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.FileFormat;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentGeneratorConfig
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentGeneratorConfig.class);
    private TableConfig _tableConfig;
    private final Map<String, String> _customProperties = new HashMap<String, String>();
    private final Set<String> _rawIndexCreationColumns = new HashSet<String>();
    private final Map<String, ChunkCompressionType> _rawIndexCompressionType = new HashMap<String, ChunkCompressionType>();
    private final List<String> _invertedIndexCreationColumns = new ArrayList<String>();
    private final List<String> _textIndexCreationColumns = new ArrayList<String>();
    private final List<String> _fstIndexCreationColumns = new ArrayList<String>();
    private final List<String> _jsonIndexCreationColumns = new ArrayList<String>();
    private final Map<String, H3IndexConfig> _h3IndexConfigs = new HashMap<String, H3IndexConfig>();
    private final List<String> _columnSortOrder = new ArrayList<String>();
    private List<String> _varLengthDictionaryColumns = new ArrayList<String>();
    private String _inputFilePath = null;
    private FileFormat _format = FileFormat.AVRO;
    private String _recordReaderPath = null;
    private String _outDir = null;
    private String _rawTableName = null;
    private String _segmentName = null;
    private String _segmentNamePrefix = null;
    private String _segmentNamePostfix = null;
    private String _segmentTimeColumnName = null;
    private TimeUnit _segmentTimeUnit = null;
    private String _segmentCreationTime = null;
    private String _segmentStartTime = null;
    private String _segmentEndTime = null;
    private SegmentVersion _segmentVersion = SegmentVersion.v3;
    private Schema _schema = null;
    private RecordReaderConfig _readerConfig = null;
    private List<StarTreeIndexConfig> _starTreeIndexConfigs = null;
    private boolean _enableDefaultStarTree = false;
    private String _creatorVersion = null;
    private SegmentNameGenerator _segmentNameGenerator = null;
    private SegmentPartitionConfig _segmentPartitionConfig = null;
    private int _sequenceId = -1;
    private TimeColumnType _timeColumnType = TimeColumnType.EPOCH;
    private String _simpleDateFormat = null;
    private boolean _onHeap = false;
    private boolean _skipTimeValueCheck = false;
    private boolean _nullHandlingEnabled = false;
    private boolean _failOnEmptySegment = false;
    private Map<String, Map<String, String>> _columnProperties = new HashMap<String, Map<String, String>>();

    @Deprecated
    public SegmentGeneratorConfig() {
    }

    public SegmentGeneratorConfig(TableConfig tableConfig, Schema schema) {
        Preconditions.checkNotNull((Object)schema);
        Preconditions.checkNotNull((Object)tableConfig);
        this.setSchema(schema);
        this._tableConfig = tableConfig;
        this.setTableName(tableConfig.getTableName());
        String timeColumnName = null;
        if (tableConfig.getValidationConfig() != null) {
            timeColumnName = tableConfig.getValidationConfig().getTimeColumnName();
        }
        this.setTime(timeColumnName, schema);
        IndexingConfig indexingConfig = tableConfig.getIndexingConfig();
        if (indexingConfig != null) {
            List fieldConfigList;
            Map customConfigs;
            String segmentVersion = indexingConfig.getSegmentFormatVersion();
            if (segmentVersion != null) {
                this._segmentVersion = SegmentVersion.valueOf(segmentVersion);
            }
            List noDictionaryColumns = indexingConfig.getNoDictionaryColumns();
            Map noDictionaryColumnMap = indexingConfig.getNoDictionaryConfig();
            if (noDictionaryColumns != null) {
                this.setRawIndexCreationColumns(noDictionaryColumns);
                if (noDictionaryColumnMap != null) {
                    Map<String, ChunkCompressionType> serializedNoDictionaryColumnMap = noDictionaryColumnMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ChunkCompressionType.valueOf((String)e.getValue())));
                    this.setRawIndexCompressionType(serializedNoDictionaryColumnMap);
                }
            }
            if (indexingConfig.getVarLengthDictionaryColumns() != null) {
                this.setVarLengthDictionaryColumns(indexingConfig.getVarLengthDictionaryColumns());
            }
            this._segmentPartitionConfig = indexingConfig.getSegmentPartitionConfig();
            this.setStarTreeIndexConfigs(indexingConfig.getStarTreeIndexConfigs());
            this.setEnableDefaultStarTree(indexingConfig.isEnableDefaultStarTree());
            if (indexingConfig.getInvertedIndexColumns() != null && ((customConfigs = tableConfig.getCustomConfig().getCustomConfigs()) != null && Boolean.parseBoolean((String)customConfigs.get("generate.inverted.index.before.push")) || indexingConfig.isCreateInvertedIndexDuringSegmentGeneration())) {
                this._invertedIndexCreationColumns.addAll(indexingConfig.getInvertedIndexColumns());
            }
            if (indexingConfig.getJsonIndexColumns() != null) {
                this._jsonIndexCreationColumns.addAll(indexingConfig.getJsonIndexColumns());
            }
            if ((fieldConfigList = tableConfig.getFieldConfigList()) != null) {
                for (FieldConfig fieldConfig : fieldConfigList) {
                    this._columnProperties.put(fieldConfig.getName(), fieldConfig.getProperties());
                }
            }
            this.extractTextIndexColumnsFromTableConfig(tableConfig);
            this.extractFSTIndexColumnsFromTableConfig(tableConfig);
            this.extractH3IndexConfigsFromTableConfig(tableConfig);
            this.extractCompressionCodecConfigsFromTableConfig(tableConfig);
            this._nullHandlingEnabled = indexingConfig.isNullHandlingEnabled();
        }
    }

    public Map<String, Map<String, String>> getColumnProperties() {
        return this._columnProperties;
    }

    private void setTime(@Nullable String timeColumnName, Schema schema) {
        DateTimeFieldSpec dateTimeFieldSpec;
        if (timeColumnName != null && (dateTimeFieldSpec = schema.getSpecForTimeColumn(timeColumnName)) != null) {
            this.setTimeColumnName(dateTimeFieldSpec.getName());
            DateTimeFormatSpec formatSpec = new DateTimeFormatSpec(dateTimeFieldSpec.getFormat());
            if (formatSpec.getTimeFormat() == DateTimeFieldSpec.TimeFormat.SIMPLE_DATE_FORMAT) {
                this.setSimpleDateFormat(formatSpec.getSDFPattern());
            } else {
                this.setSegmentTimeUnit(formatSpec.getColumnUnit());
            }
        }
    }

    private void extractTextIndexColumnsFromTableConfig(TableConfig tableConfig) {
        List fieldConfigList = tableConfig.getFieldConfigList();
        if (fieldConfigList != null) {
            for (FieldConfig fieldConfig : fieldConfigList) {
                if (fieldConfig.getIndexType() != FieldConfig.IndexType.TEXT) continue;
                this._textIndexCreationColumns.add(fieldConfig.getName());
            }
        }
    }

    private void extractFSTIndexColumnsFromTableConfig(TableConfig tableConfig) {
        List fieldConfigList = tableConfig.getFieldConfigList();
        if (fieldConfigList != null) {
            for (FieldConfig fieldConfig : fieldConfigList) {
                if (fieldConfig.getIndexType() != FieldConfig.IndexType.FST) continue;
                this._fstIndexCreationColumns.add(fieldConfig.getName());
            }
        }
    }

    private void extractH3IndexConfigsFromTableConfig(TableConfig tableConfig) {
        List fieldConfigList = tableConfig.getFieldConfigList();
        if (fieldConfigList != null) {
            for (FieldConfig fieldConfig : fieldConfigList) {
                if (fieldConfig.getIndexType() != FieldConfig.IndexType.H3) continue;
                this._h3IndexConfigs.put(fieldConfig.getName(), new H3IndexConfig(fieldConfig.getProperties()));
            }
        }
    }

    private void extractCompressionCodecConfigsFromTableConfig(TableConfig tableConfig) {
        List fieldConfigList = tableConfig.getFieldConfigList();
        if (fieldConfigList != null) {
            for (FieldConfig fieldConfig : fieldConfigList) {
                if (fieldConfig.getEncodingType() != FieldConfig.EncodingType.RAW || fieldConfig.getCompressionCodec() == null) continue;
                this._rawIndexCreationColumns.add(fieldConfig.getName());
                this._rawIndexCompressionType.put(fieldConfig.getName(), ChunkCompressionType.valueOf(fieldConfig.getCompressionCodec().name()));
            }
        }
    }

    public Map<String, String> getCustomProperties() {
        return this._customProperties;
    }

    public void setCustomProperties(Map<String, String> properties) {
        Preconditions.checkNotNull(properties);
        this._customProperties.putAll(properties);
    }

    public void setSimpleDateFormat(String simpleDateFormat) {
        this._timeColumnType = TimeColumnType.SIMPLE_DATE;
        try {
            DateTimeFormat.forPattern((String)simpleDateFormat);
        }
        catch (Exception e) {
            throw new RuntimeException("Illegal simple date format specification", e);
        }
        this._simpleDateFormat = simpleDateFormat;
    }

    public String getSimpleDateFormat() {
        return this._simpleDateFormat;
    }

    public TimeColumnType getTimeColumnType() {
        return this._timeColumnType;
    }

    public boolean containsCustomProperty(String key) {
        Preconditions.checkNotNull((Object)key);
        return this._customProperties.containsKey(key);
    }

    public Set<String> getRawIndexCreationColumns() {
        return this._rawIndexCreationColumns;
    }

    public List<String> getInvertedIndexCreationColumns() {
        return this._invertedIndexCreationColumns;
    }

    public List<String> getTextIndexCreationColumns() {
        return this._textIndexCreationColumns;
    }

    public List<String> getFSTIndexCreationColumns() {
        return this._fstIndexCreationColumns;
    }

    public List<String> getJsonIndexCreationColumns() {
        return this._jsonIndexCreationColumns;
    }

    public Map<String, H3IndexConfig> getH3IndexConfigs() {
        return this._h3IndexConfigs;
    }

    public List<String> getColumnSortOrder() {
        return this._columnSortOrder;
    }

    public void setRawIndexCreationColumns(List<String> rawIndexCreationColumns) {
        Preconditions.checkNotNull(rawIndexCreationColumns);
        this._rawIndexCreationColumns.addAll(rawIndexCreationColumns);
    }

    @Deprecated
    public void setInvertedIndexCreationColumns(List<String> indexCreationColumns) {
        Preconditions.checkNotNull(indexCreationColumns);
        this._invertedIndexCreationColumns.addAll(indexCreationColumns);
    }

    public void setTextIndexCreationColumns(List<String> textIndexCreationColumns) {
        if (textIndexCreationColumns != null) {
            this._textIndexCreationColumns.addAll(textIndexCreationColumns);
        }
    }

    @VisibleForTesting
    public void setColumnProperties(Map<String, Map<String, String>> columnProperties) {
        this._columnProperties = columnProperties;
    }

    public void setFSTIndexCreationColumns(List<String> fstIndexCreationColumns) {
        if (fstIndexCreationColumns != null) {
            this._fstIndexCreationColumns.addAll(fstIndexCreationColumns);
        }
    }

    public void setColumnSortOrder(List<String> sortOrder) {
        Preconditions.checkNotNull(sortOrder);
        this._columnSortOrder.addAll(sortOrder);
    }

    public List<String> getVarLengthDictionaryColumns() {
        return this._varLengthDictionaryColumns;
    }

    public void setVarLengthDictionaryColumns(List<String> varLengthDictionaryColumns) {
        this._varLengthDictionaryColumns = varLengthDictionaryColumns;
    }

    public void createInvertedIndexForColumn(String column) {
        Preconditions.checkNotNull((Object)column);
        if (this._schema != null && this._schema.getFieldSpecFor(column) == null) {
            LOGGER.warn("Cannot find column {} in schema, will not create inverted index.", (Object)column);
            return;
        }
        if (this._schema == null) {
            LOGGER.warn("Schema has not been set, column {} might not exist in schema after all.", (Object)column);
        }
        this._invertedIndexCreationColumns.add(column);
    }

    public void createInvertedIndexForAllColumns() {
        if (this._schema == null) {
            LOGGER.warn("Schema has not been set, will not create inverted index for all columns.");
            return;
        }
        for (FieldSpec spec : this._schema.getAllFieldSpecs()) {
            this._invertedIndexCreationColumns.add(spec.getName());
        }
    }

    public String getInputFilePath() {
        return this._inputFilePath;
    }

    public void setInputFilePath(String inputFilePath) {
        Preconditions.checkNotNull((Object)inputFilePath);
        File inputFile = new File(inputFilePath);
        Preconditions.checkState((boolean)inputFile.exists(), (String)"Input path {} does not exist.", (Object)inputFilePath);
        this._inputFilePath = inputFile.getAbsolutePath();
    }

    public FileFormat getFormat() {
        return this._format;
    }

    public void setFormat(FileFormat format) {
        this._format = format;
    }

    public String getRecordReaderPath() {
        return this._recordReaderPath;
    }

    public void setRecordReaderPath(String recordReaderPath) {
        this._recordReaderPath = recordReaderPath;
    }

    public String getOutDir() {
        return this._outDir;
    }

    public void setOutDir(String dir) {
        Preconditions.checkNotNull((Object)dir);
        File outputDir = new File(dir);
        if (outputDir.exists()) {
            Preconditions.checkState((boolean)outputDir.isDirectory(), (String)"Path: %s is not a directory", (Object)dir);
        } else {
            Preconditions.checkState((boolean)outputDir.mkdirs(), (String)"Cannot create output dir: %s", (Object)dir);
        }
        this._outDir = outputDir.getAbsolutePath();
    }

    public String getTableName() {
        return this._rawTableName;
    }

    public void setTableName(String tableName) {
        this._rawTableName = tableName != null ? TableNameBuilder.extractRawTableName((String)tableName) : null;
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    public void setSegmentName(String segmentName) {
        this._segmentName = segmentName;
    }

    public String getCreatorVersion() {
        return this._creatorVersion;
    }

    public void setCreatorVersion(String creatorVersion) {
        this._creatorVersion = creatorVersion;
    }

    public String getSegmentNamePrefix() {
        return this._segmentNamePrefix;
    }

    public void setSegmentNamePrefix(String segmentNamePrefix) {
        this._segmentNamePrefix = segmentNamePrefix;
    }

    public String getSegmentNamePostfix() {
        return this._segmentNamePostfix;
    }

    public void setSegmentNamePostfix(String postfix) {
        this._segmentNamePostfix = postfix;
    }

    public String getTimeColumnName() {
        return this._segmentTimeColumnName;
    }

    public void setTimeColumnName(String timeColumnName) {
        this._segmentTimeColumnName = timeColumnName;
    }

    public int getSequenceId() {
        return this._sequenceId;
    }

    public void setSequenceId(int sequenceId) {
        this._sequenceId = sequenceId;
    }

    public TimeUnit getSegmentTimeUnit() {
        return this._segmentTimeUnit;
    }

    public void setSegmentTimeUnit(TimeUnit timeUnit) {
        this._segmentTimeUnit = timeUnit;
    }

    public String getCreationTime() {
        return this._segmentCreationTime;
    }

    public void setCreationTime(String creationTime) {
        this._segmentCreationTime = creationTime;
    }

    public String getStartTime() {
        return this._segmentStartTime;
    }

    public void setStartTime(String startTime) {
        this._segmentStartTime = startTime;
    }

    public String getEndTime() {
        return this._segmentEndTime;
    }

    public void setEndTime(String endTime) {
        this._segmentEndTime = endTime;
    }

    public SegmentVersion getSegmentVersion() {
        return this._segmentVersion;
    }

    public void setSegmentVersion(SegmentVersion segmentVersion) {
        this._segmentVersion = segmentVersion;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public TableConfig getTableConfig() {
        return this._tableConfig;
    }

    private void setSchema(Schema schema) {
        Preconditions.checkNotNull((Object)schema);
        this._schema = schema;
        if (this._invertedIndexCreationColumns != null) {
            Iterator<String> iterator = this._invertedIndexCreationColumns.iterator();
            while (iterator.hasNext()) {
                String column = iterator.next();
                if (this._schema.getFieldSpecFor(column) != null) continue;
                LOGGER.warn("Cannot find column {} in schema, will not create inverted index.", (Object)column);
                iterator.remove();
            }
        }
    }

    public RecordReaderConfig getReaderConfig() {
        return this._readerConfig;
    }

    public void setReaderConfig(RecordReaderConfig readerConfig) {
        this._readerConfig = readerConfig;
    }

    @Nullable
    public List<StarTreeIndexConfig> getStarTreeIndexConfigs() {
        return this._starTreeIndexConfigs;
    }

    public void setStarTreeIndexConfigs(List<StarTreeIndexConfig> starTreeIndexConfigs) {
        this._starTreeIndexConfigs = starTreeIndexConfigs;
    }

    public boolean isEnableDefaultStarTree() {
        return this._enableDefaultStarTree;
    }

    public void setEnableDefaultStarTree(boolean enableDefaultStarTree) {
        this._enableDefaultStarTree = enableDefaultStarTree;
    }

    public SegmentNameGenerator getSegmentNameGenerator() {
        if (this._segmentNameGenerator != null) {
            return this._segmentNameGenerator;
        }
        if (this._segmentName != null) {
            return new FixedSegmentNameGenerator(this._segmentName);
        }
        if (this._segmentNamePrefix != null) {
            return new SimpleSegmentNameGenerator(this._segmentNamePrefix, this._segmentNamePostfix);
        }
        return new SimpleSegmentNameGenerator(this._rawTableName, this._segmentNamePostfix);
    }

    public void setSegmentNameGenerator(SegmentNameGenerator segmentNameGenerator) {
        this._segmentNameGenerator = segmentNameGenerator;
    }

    public boolean isOnHeap() {
        return this._onHeap;
    }

    public void setOnHeap(boolean onHeap) {
        this._onHeap = onHeap;
    }

    public boolean isSkipTimeValueCheck() {
        return this._skipTimeValueCheck;
    }

    public void setSkipTimeValueCheck(boolean skipTimeValueCheck) {
        this._skipTimeValueCheck = skipTimeValueCheck;
    }

    public Map<String, ChunkCompressionType> getRawIndexCompressionType() {
        return this._rawIndexCompressionType;
    }

    public void setRawIndexCompressionType(Map<String, ChunkCompressionType> rawIndexCompressionType) {
        this._rawIndexCompressionType.clear();
        this._rawIndexCompressionType.putAll(rawIndexCompressionType);
    }

    public String getMetrics() {
        return this.getQualifyingFields(FieldSpec.FieldType.METRIC, true);
    }

    public String getDimensions() {
        return this.getQualifyingFields(FieldSpec.FieldType.DIMENSION, true);
    }

    public String getDateTimeColumnNames() {
        return this.getQualifyingFields(FieldSpec.FieldType.DATE_TIME, true);
    }

    public void setSegmentPartitionConfig(SegmentPartitionConfig segmentPartitionConfig) {
        this._segmentPartitionConfig = segmentPartitionConfig;
    }

    public SegmentPartitionConfig getSegmentPartitionConfig() {
        return this._segmentPartitionConfig;
    }

    private String getQualifyingFields(FieldSpec.FieldType type, boolean excludeVirtualColumns) {
        ArrayList<String> fields = new ArrayList<String>();
        for (FieldSpec fieldSpec : this.getSchema().getAllFieldSpecs()) {
            if (excludeVirtualColumns && fieldSpec.isVirtualColumn() || fieldSpec.getFieldType() != type) continue;
            fields.add(fieldSpec.getName());
        }
        Collections.sort(fields);
        return StringUtils.join(fields, (String)",");
    }

    public boolean isNullHandlingEnabled() {
        return this._nullHandlingEnabled;
    }

    public void setNullHandlingEnabled(boolean nullHandlingEnabled) {
        this._nullHandlingEnabled = nullHandlingEnabled;
    }

    public boolean isFailOnEmptySegment() {
        return this._failOnEmptySegment;
    }

    public void setFailOnEmptySegment(boolean failOnEmptySegment) {
        this._failOnEmptySegment = failOnEmptySegment;
    }

    public static enum TimeColumnType {
        EPOCH,
        SIMPLE_DATE;

    }
}

