/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.loader;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.segment.spi.loader.SegmentDirectoryLoader;
import org.apache.pinot.segment.spi.loader.SegmentLoader;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentDirectoryLoaderRegistry {
    private static final String LOCAL_TIER_BACKEND_NAME = "local";
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentDirectoryLoaderRegistry.class);
    private static final Map<String, SegmentDirectoryLoader> _segmentDirectoryLoaderMap = new HashMap<String, SegmentDirectoryLoader>();

    private SegmentDirectoryLoaderRegistry() {
    }

    public static SegmentDirectoryLoader getSegmentDirectoryLoader(String tierBackend) {
        return _segmentDirectoryLoaderMap.get(tierBackend);
    }

    public static SegmentDirectoryLoader getLocalSegmentDirectoryLoader() {
        return _segmentDirectoryLoaderMap.get(LOCAL_TIER_BACKEND_NAME);
    }

    static {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)"org.apache.pinot.segment", (ClassLoader[])new ClassLoader[0])).filterInputsBy((Predicate)new FilterBuilder.Include(".*\\.loader\\..*")).setScanners(new Scanner[]{new ResourcesScanner(), new TypeAnnotationsScanner(), new SubTypesScanner()}));
        Set classes = reflections.getTypesAnnotatedWith(SegmentLoader.class);
        classes.forEach(loaderClass -> {
            SegmentLoader segmentLoaderAnnotation = loaderClass.getAnnotation(SegmentLoader.class);
            if (segmentLoaderAnnotation.enabled()) {
                if (segmentLoaderAnnotation.name().isEmpty()) {
                    LOGGER.error("Cannot register an unnamed SegmentDirectoryLoader for annotation {} ", (Object)segmentLoaderAnnotation.toString());
                } else {
                    String segmentLoaderName = segmentLoaderAnnotation.name();
                    try {
                        SegmentDirectoryLoader segmentDirectoryLoader = (SegmentDirectoryLoader)loaderClass.newInstance();
                        _segmentDirectoryLoaderMap.putIfAbsent(segmentLoaderName, segmentDirectoryLoader);
                    }
                    catch (Exception e) {
                        LOGGER.error(String.format("Unable to register SegmentDirectoryLoader %s . Cannot instantiate.", segmentLoaderName), (Throwable)e);
                    }
                }
            }
        });
        LOGGER.info("Initialized {} with {} segmentDirectoryLoaders: {}", new Object[]{SegmentDirectoryLoaderRegistry.class.getName(), _segmentDirectoryLoaderMap.size(), _segmentDirectoryLoaderMap.keySet()});
    }
}

