/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.memory;

import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.segment.spi.memory.BasePinotLBuffer;
import xerial.larray.buffer.LBuffer;
import xerial.larray.buffer.LBufferAPI;
import xerial.larray.mmap.MMapBuffer;
import xerial.larray.mmap.MMapMode;

@ThreadSafe
public class PinotNonNativeOrderLBuffer
extends BasePinotLBuffer {
    static PinotNonNativeOrderLBuffer allocateDirect(long size) {
        LBuffer buffer = new LBuffer(size);
        return new PinotNonNativeOrderLBuffer((LBufferAPI)buffer, true, false);
    }

    static PinotNonNativeOrderLBuffer loadFile(File file, long offset, long size) throws IOException {
        PinotNonNativeOrderLBuffer buffer = PinotNonNativeOrderLBuffer.allocateDirect(size);
        buffer.readFrom(0L, file, offset, size);
        return buffer;
    }

    public static PinotNonNativeOrderLBuffer mapFile(File file, boolean readOnly, long offset, long size) throws IOException {
        if (readOnly) {
            return new PinotNonNativeOrderLBuffer((LBufferAPI)new MMapBuffer(file, offset, size, MMapMode.READ_ONLY), true, false);
        }
        return new PinotNonNativeOrderLBuffer((LBufferAPI)new MMapBuffer(file, offset, size, MMapMode.READ_WRITE), true, true);
    }

    PinotNonNativeOrderLBuffer(LBufferAPI buffer, boolean closeable, boolean flushable) {
        super(buffer, closeable, flushable);
    }

    @Override
    public char getChar(int offset) {
        return Character.reverseBytes(this._buffer.getChar(offset));
    }

    @Override
    public char getChar(long offset) {
        return Character.reverseBytes(this._buffer.getChar(offset));
    }

    @Override
    public void putChar(int offset, char value) {
        this._buffer.putChar(offset, Character.reverseBytes(value));
    }

    @Override
    public void putChar(long offset, char value) {
        this._buffer.putChar(offset, Character.reverseBytes(value));
    }

    @Override
    public short getShort(int offset) {
        return Short.reverseBytes(this._buffer.getShort(offset));
    }

    @Override
    public short getShort(long offset) {
        return Short.reverseBytes(this._buffer.getShort(offset));
    }

    @Override
    public void putShort(int offset, short value) {
        this._buffer.putShort(offset, Short.reverseBytes(value));
    }

    @Override
    public void putShort(long offset, short value) {
        this._buffer.putShort(offset, Short.reverseBytes(value));
    }

    @Override
    public int getInt(int offset) {
        return Integer.reverseBytes(this._buffer.getInt(offset));
    }

    @Override
    public int getInt(long offset) {
        return Integer.reverseBytes(this._buffer.getInt(offset));
    }

    @Override
    public void putInt(int offset, int value) {
        this._buffer.putInt(offset, Integer.reverseBytes(value));
    }

    @Override
    public void putInt(long offset, int value) {
        this._buffer.putInt(offset, Integer.reverseBytes(value));
    }

    @Override
    public long getLong(int offset) {
        return Long.reverseBytes(this._buffer.getLong(offset));
    }

    @Override
    public long getLong(long offset) {
        return Long.reverseBytes(this._buffer.getLong(offset));
    }

    @Override
    public void putLong(int offset, long value) {
        this._buffer.putLong(offset, Long.reverseBytes(value));
    }

    @Override
    public void putLong(long offset, long value) {
        this._buffer.putLong(offset, Long.reverseBytes(value));
    }

    @Override
    public float getFloat(int offset) {
        return Float.intBitsToFloat(Integer.reverseBytes(this._buffer.getInt(offset)));
    }

    @Override
    public float getFloat(long offset) {
        return Float.intBitsToFloat(Integer.reverseBytes(this._buffer.getInt(offset)));
    }

    @Override
    public void putFloat(int offset, float value) {
        this._buffer.putInt(offset, Integer.reverseBytes(Float.floatToRawIntBits(value)));
    }

    @Override
    public void putFloat(long offset, float value) {
        this._buffer.putInt(offset, Integer.reverseBytes(Float.floatToRawIntBits(value)));
    }

    @Override
    public double getDouble(int offset) {
        return Double.longBitsToDouble(Long.reverseBytes(this._buffer.getLong(offset)));
    }

    @Override
    public double getDouble(long offset) {
        return Double.longBitsToDouble(Long.reverseBytes(this._buffer.getLong(offset)));
    }

    @Override
    public void putDouble(int offset, double value) {
        this._buffer.putLong(offset, Long.reverseBytes(Double.doubleToRawLongBits(value)));
    }

    @Override
    public void putDouble(long offset, double value) {
        this._buffer.putLong(offset, Long.reverseBytes(Double.doubleToRawLongBits(value)));
    }

    @Override
    public ByteOrder order() {
        return NON_NATIVE_ORDER;
    }
}

