/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.partition.metadata;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(using=ColumnPartitionMetadataDeserializer.class)
public class ColumnPartitionMetadata {
    private final String _functionName;
    private final int _numPartitions;
    private final Set<Integer> _partitions;

    public ColumnPartitionMetadata(String functionName, int numPartitions, Set<Integer> partitions) {
        this._functionName = functionName;
        this._numPartitions = numPartitions;
        this._partitions = partitions;
    }

    public String getFunctionName() {
        return this._functionName;
    }

    public int getNumPartitions() {
        return this._numPartitions;
    }

    public Set<Integer> getPartitions() {
        return this._partitions;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ColumnPartitionMetadata) {
            ColumnPartitionMetadata that = (ColumnPartitionMetadata)obj;
            return this._functionName.equals(that._functionName) && this._numPartitions == that._numPartitions && this._partitions.equals(that._partitions);
        }
        return false;
    }

    public int hashCode() {
        return 1369 * this._functionName.hashCode() + 37 * this._numPartitions + this._partitions.hashCode();
    }

    public static Set<Integer> extractPartitions(List partitionList) {
        HashSet<Integer> partitions = new HashSet<Integer>();
        for (Object o : partitionList) {
            String partitionString = o.toString();
            if (partitionString.charAt(0) == '[') {
                ColumnPartitionMetadata.addRangeToPartitions(partitionString, partitions);
                continue;
            }
            partitions.add(Integer.parseInt(partitionString));
        }
        return partitions;
    }

    private static void addRangeToPartitions(String rangeString, Set<Integer> partitions) {
        int delimiterIndex = rangeString.indexOf(32);
        int start = Integer.parseInt(rangeString.substring(1, delimiterIndex));
        int end = Integer.parseInt(rangeString.substring(delimiterIndex + 1, rangeString.length() - 1));
        for (int i = start; i <= end; ++i) {
            partitions.add(i);
        }
    }

    public static class ColumnPartitionMetadataDeserializer
    extends JsonDeserializer<ColumnPartitionMetadata> {
        private static final String FUNCTION_NAME_KEY = "functionName";
        private static final String NUM_PARTITIONS_KEY = "numPartitions";
        private static final String PARTITIONS_KEY = "partitions";
        private static final String LEGACY_PARTITIONS_KEY = "partitionRanges";
        private static final char LEGACY_PARTITION_DELIMITER = ',';

        public ColumnPartitionMetadata deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode jsonMetadata = (JsonNode)p.getCodec().readTree(p);
            HashSet<Integer> partitions = new HashSet<Integer>();
            JsonNode jsonPartitions = jsonMetadata.get(PARTITIONS_KEY);
            if (jsonPartitions != null) {
                for (JsonNode jsonPartition : jsonPartitions) {
                    partitions.add(jsonPartition.asInt());
                }
            } else {
                String partitionRanges = jsonMetadata.get(LEGACY_PARTITIONS_KEY).asText();
                for (String partitionRange : StringUtils.split((String)partitionRanges, (char)',')) {
                    ColumnPartitionMetadata.addRangeToPartitions(partitionRange, partitions);
                }
            }
            return new ColumnPartitionMetadata(jsonMetadata.get(FUNCTION_NAME_KEY).asText(), jsonMetadata.get(NUM_PARTITIONS_KEY).asInt(), partitions);
        }
    }
}

