/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.store;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Set;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.ColumnIndexType;

public abstract class SegmentDirectory
implements Closeable {
    public abstract URI getIndexDir();

    public abstract SegmentMetadataImpl getSegmentMetadata();

    public abstract void reloadMetadata() throws Exception;

    public abstract Path getPath();

    public abstract long getDiskSizeBytes();

    public void prefetch(Set<String> columns) {
    }

    public abstract Reader createReader() throws IOException, ConfigurationException;

    public abstract Writer createWriter() throws IOException;

    public abstract String toString();

    protected SegmentDirectory() {
    }

    public abstract class Writer
    extends Reader {
        public abstract PinotDataBuffer newIndexFor(String var1, ColumnIndexType var2, long var3) throws IOException;

        public abstract boolean isIndexRemovalSupported();

        public abstract void removeIndex(String var1, ColumnIndexType var2);

        public abstract void save() throws IOException;

        public SegmentDirectory toSegmentDirectory() {
            return SegmentDirectory.this;
        }

        @Override
        public abstract String toString();
    }

    public abstract class Reader
    implements Closeable {
        public abstract PinotDataBuffer getIndexFor(String var1, ColumnIndexType var2) throws IOException;

        public abstract boolean hasIndexFor(String var1, ColumnIndexType var2);

        public abstract String toString();
    }
}

